/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.gui.Main_MouseAdapter;
import com.dandymadeproductions.ajqvue.gui.forms.AdvancedSortSearchForm;
import com.dandymadeproductions.ajqvue.gui.forms.TableEntryForm;
import com.dandymadeproductions.ajqvue.gui.forms.TableViewForm;
import com.dandymadeproductions.ajqvue.gui.forms.UpdateForm;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.TableFieldSelectionPreferencesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabInterface;
import com.dandymadeproductions.ajqvue.io.CSVDataImportThread;
import com.dandymadeproductions.ajqvue.io.WriteDataFile;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.BlobTextKey;
import com.dandymadeproductions.ajqvue.utilities.ImageUtil;
import com.dandymadeproductions.ajqvue.utilities.InputDialog;
import com.dandymadeproductions.ajqvue.utilities.TableModel;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;

public abstract class TableTabPanel
extends JPanel
implements TableTabInterface,
ActionListener,
KeyListener,
TableColumnModelListener,
Printable {
    private static final long serialVersionUID = -1025915869411393685L;
    protected int columnSizeScaling;
    protected int stateHistoryIndex;
    private int selectedRow;
    private int horizontalScrollBarPosition;
    private int verticalScrollBarPosition;
    protected int tableRowStart;
    protected int tableRowLimit;
    private Object panelSource;
    protected boolean historyAction;
    private boolean busyProcessing = false;
    private boolean settingState;
    private boolean viewOnly;
    protected static final int MAX_PREFERRED_COLUMN_SIZE = 350;
    protected static final int STATE_HISTORY_LIMIT = 25;
    private static final String STATE_DELIMITER = "%;%";
    protected String sqlTable;
    protected String schemaTableName;
    private String saveFileName;
    private String lastSaveDirectory;
    protected String lob_sqlTableFieldsString;
    protected String sqlTableFieldsString;
    protected StringBuffer sqlTableStatement;
    protected String identifierQuoteString;
    protected ArrayList<String> fields;
    protected ArrayList<String> formFields;
    protected ArrayList<String> viewFormFields;
    protected ArrayList<String> comboBoxFields;
    protected ArrayList<String> currentTableHeadings;
    protected ArrayList<String> allTableHeadings;
    protected ArrayList<String> primaryKeys;
    protected ArrayList<String> foreignKeys;
    protected ArrayList<String> exportedKeys;
    private AResourceBundle resourceBundle;
    private ImageIcon previousStateIcon;
    private ImageIcon nextStateIcon;
    private ImageIcon ascUpIcon;
    private ImageIcon ascDownIcon;
    private ImageIcon descUpIcon;
    private ImageIcon descDownIcon;
    private ImageIcon searchIcon;
    private ImageIcon removeIcon;
    private ImageIcon updateIcon;
    private ImageIcon advancedSortSearchIcon;
    private ImageIcon previousViewIcon;
    private ImageIcon nextViewIcon;
    private ImageIcon refreshIcon;
    private ImageIcon previousTableRowsIcon;
    private ImageIcon nextTableRowsIcon;
    private ImageIcon deleteDataIcon;
    private JButton previousStateButton;
    private JButton nextStateButton;
    private JButton searchButton;
    private JButton clearSearchTextFieldButton;
    protected String ascDescString;
    private JRadioButton ascSortRadioButton;
    private JRadioButton descSortRadioButton;
    protected JComboBox<Object> sortComboBox;
    protected JComboBox<Object> searchComboBox;
    protected JTextField searchTextField;
    protected MouseListener summaryTablePopupListener;
    protected AdvancedSortSearchForm advancedSortSearchFrame;
    protected JButton activateAdvancedSortSearchButton;
    private JButton advSortSearchApplyButton;
    protected boolean advancedSortSearch;
    private UpdateForm updateFrame;
    protected JButton activateUpdateButton;
    private JButton updateFormFindButton;
    protected JPanel centerPanel;
    protected JScrollPane tableScrollPane;
    protected CardLayout centerCardLayout;
    protected JTable listTable;
    protected TableModel tableModel;
    protected TableViewForm tableViewForm;
    protected Object[][] tableData;
    protected LinkedList<String> stateHistory = new LinkedList();
    protected HashMap<String, String> columnNamesHashMap;
    protected HashMap<String, String> columnClassHashMap;
    protected HashMap<String, Integer> columnSQLTypeHashMap;
    protected HashMap<String, String> columnTypeNameHashMap;
    protected HashMap<String, Integer> columnSizeHashMap;
    protected HashMap<String, Integer> preferredColumnSizeHashMap;
    protected HashMap<String, String> lobDataTypesHashMap;
    protected HashMap<String, String> autoIncrementHashMap;
    protected HashMap<String, Integer> keyLengthHashMap;
    protected HashMap<String, String> columnEnumHashMap;
    protected HashMap<String, String> columnSetHashMap;
    private JLabel rowsLabel;
    protected JButton refreshButton;
    private JButton previousTableRowsButton;
    private JButton nextTableRowsButton;
    private JButton viewButton;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private JButton deleteAllButton;
    private JButton previousViewButton;
    private JButton nextViewButton;
    private JButton closeViewButton;

    TableTabPanel(String string, Connection connection, boolean bl) {
        this.sqlTable = string;
        this.viewOnly = bl;
        String string2 = Utils.getIconsDirectory() + Utils.getFileSeparator();
        boolean bl2 = false;
        this.identifierQuoteString = ConnectionManager.getIdentifierQuoteString();
        this.schemaTableName = Utils.getSchemaTableName(this.sqlTable);
        this.columnSizeScaling = Ajqvue.getGeneralProperties().getFontSize() > 16 ? Ajqvue.getGeneralProperties().getFontSize() - 12 + 8 : 11;
        this.stateHistoryIndex = -1;
        this.selectedRow = -1;
        this.horizontalScrollBarPosition = -1;
        this.verticalScrollBarPosition = -1;
        this.tableRowStart = 0;
        this.tableRowLimit = 50;
        this.saveFileName = "";
        this.lastSaveDirectory = "";
        this.sqlTableStatement = new StringBuffer();
        this.fields = new ArrayList();
        this.formFields = new ArrayList();
        this.viewFormFields = new ArrayList();
        this.comboBoxFields = new ArrayList();
        this.currentTableHeadings = new ArrayList();
        this.allTableHeadings = new ArrayList();
        this.primaryKeys = new ArrayList();
        this.foreignKeys = new ArrayList();
        this.exportedKeys = new ArrayList();
        this.resourceBundle = Ajqvue.getResourceBundle();
        this.columnNamesHashMap = new HashMap();
        this.columnClassHashMap = new HashMap();
        this.columnSQLTypeHashMap = new HashMap();
        this.columnTypeNameHashMap = new HashMap();
        this.columnSizeHashMap = new HashMap();
        this.preferredColumnSizeHashMap = new HashMap();
        this.lobDataTypesHashMap = new HashMap();
        this.autoIncrementHashMap = new HashMap();
        this.keyLengthHashMap = new HashMap();
        this.columnEnumHashMap = new HashMap();
        this.columnSetHashMap = new HashMap();
        this.historyAction = true;
        this.advancedSortSearch = false;
        this.settingState = false;
        this.ascDescString = "ASC";
        this.previousStateIcon = this.resourceBundle.getResourceImage(string2 + "previousStateIcon.png");
        this.nextStateIcon = this.resourceBundle.getResourceImage(string2 + "nextStateIcon.png");
        this.ascUpIcon = this.resourceBundle.getResourceImage(string2 + "ascUpIcon.png");
        this.ascDownIcon = this.resourceBundle.getResourceImage(string2 + "ascDownIcon.png");
        this.descUpIcon = this.resourceBundle.getResourceImage(string2 + "descUpIcon.png");
        this.descDownIcon = this.resourceBundle.getResourceImage(string2 + "descDownIcon.png");
        this.searchIcon = this.resourceBundle.getResourceImage(string2 + "searchIcon.png");
        this.removeIcon = this.resourceBundle.getResourceImage(string2 + "removeIcon.png");
        this.advancedSortSearchIcon = this.resourceBundle.getResourceImage(string2 + "advancedSortSearchIcon.gif");
        this.updateIcon = this.resourceBundle.getResourceImage(string2 + "updateIcon.gif");
        this.previousViewIcon = this.resourceBundle.getResourceImage(string2 + "previousViewIcon.png");
        this.nextViewIcon = this.resourceBundle.getResourceImage(string2 + "nextViewIcon.png");
        this.refreshIcon = this.resourceBundle.getResourceImage(string2 + "refreshIcon.png");
        this.previousTableRowsIcon = this.resourceBundle.getResourceImage(string2 + "previousTableRowsIcon.png");
        this.nextTableRowsIcon = this.resourceBundle.getResourceImage(string2 + "nextTableRowsIcon.png");
        this.deleteDataIcon = this.resourceBundle.getResourceImage(string2 + "deleteDataIcon.gif");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(0, 1, 0, 2)));
        this.previousStateButton = new JButton(this.previousStateIcon);
        this.previousStateButton.setMargin(new Insets(0, 0, 0, 0));
        this.previousStateButton.setEnabled(false);
        this.previousStateButton.addActionListener(this);
        jPanel2.add(this.previousStateButton);
        this.nextStateButton = new JButton(this.nextStateIcon);
        this.nextStateButton.setMargin(new Insets(0, 0, 0, 0));
        this.nextStateButton.setEnabled(false);
        this.nextStateButton.addActionListener(this);
        jPanel2.add(this.nextStateButton);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1.0, 100.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createRaisedBevelBorder());
        String string3 = this.resourceBundle.getResourceString("TableTabPanel.label.SortBy", "Sort By");
        JLabel jLabel = new JLabel(string3 + " : ", 2);
        jPanel3.add(jLabel);
        try {
            bl2 = this.getColumnNames(connection);
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "TableTabPanel executeActions()");
        }
        if (!bl2) {
            this.fields = null;
            return;
        }
        this.validatePrimaryKeys();
        this.sortComboBox = new JComboBox<Object>(this.comboBoxFields.toArray());
        this.sortComboBox.addActionListener(this);
        jPanel3.add(this.sortComboBox);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setBorder(BorderFactory.createEmptyBorder());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.ascSortRadioButton = new JRadioButton(this.ascUpIcon, true);
        this.ascSortRadioButton.setSelectedIcon(this.ascDownIcon);
        this.ascSortRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.ascSortRadioButton.setFocusPainted(false);
        this.ascSortRadioButton.addActionListener(this);
        buttonGroup.add(this.ascSortRadioButton);
        this.descSortRadioButton = new JRadioButton(this.descUpIcon, false);
        this.descSortRadioButton.setSelectedIcon(this.descDownIcon);
        this.descSortRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.descSortRadioButton.setFocusPainted(false);
        this.descSortRadioButton.addActionListener(this);
        buttonGroup.add(this.descSortRadioButton);
        jPanel4.add(this.ascSortRadioButton);
        jPanel4.add(this.descSortRadioButton);
        jPanel3.add(jPanel4);
        this.buildConstraints(gridBagConstraints, 1, 0, 4, 1, 47.0, 100.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createRaisedBevelBorder());
        string3 = this.resourceBundle.getResourceString("TableTabPanel.label.Search", "Search");
        JLabel jLabel2 = new JLabel(string3 + " : ");
        jPanel5.add(jLabel2);
        this.searchComboBox = new JComboBox<Object>(this.comboBoxFields.toArray());
        this.searchComboBox.insertItemAt("", 0);
        this.searchComboBox.setSelectedIndex(0);
        this.searchComboBox.addActionListener(this);
        jPanel5.add(this.searchComboBox);
        string3 = this.resourceBundle.getResourceString("TableTabPanel.label.SearchFor", "For");
        JLabel jLabel3 = new JLabel(string3 + " : ", 2);
        jPanel5.add(jLabel3);
        this.searchTextField = new JTextField(12);
        this.searchTextField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.searchTextField.addKeyListener(this);
        jPanel5.add(this.searchTextField);
        this.searchButton = new JButton(this.searchIcon);
        this.searchButton.setMargin(new Insets(0, 0, 0, 0));
        this.searchButton.setFocusPainted(false);
        this.searchButton.addActionListener(this);
        jPanel5.add(this.searchButton);
        this.clearSearchTextFieldButton = new JButton(this.removeIcon);
        this.clearSearchTextFieldButton.setMargin(new Insets(2, 2, 2, 2));
        this.clearSearchTextFieldButton.setFocusPainted(false);
        this.clearSearchTextFieldButton.addActionListener(this);
        jPanel5.add(this.clearSearchTextFieldButton);
        this.buildConstraints(gridBagConstraints, 5, 0, 8, 1, 52.0, 100.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel.add(jPanel5);
        this.add((Component)jPanel, "North");
        this.centerCardLayout = new CardLayout();
        this.centerPanel = new JPanel(this.centerCardLayout);
        if (!this.loadTable(connection)) {
            this.fields = null;
            return;
        }
        this.tableModel = new TableModel(this.currentTableHeadings, this.tableData);
        this.listTable = new JTable(this.tableModel);
        this.listTable.setAutoResizeMode(0);
        this.listTable.getActionMap().put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        this.listTable.getActionMap().put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        this.listTable.getTableHeader().setFont(new Font(this.getFont().getName(), 1, this.getFont().getSize()));
        this.listTable.setDragEnabled(true);
        this.createListTablePopupMenu();
        this.listTable.addMouseListener(this.summaryTablePopupListener);
        this.listTable.getColumnModel().addColumnModelListener(this);
        Iterator<String> iterator = this.currentTableHeadings.iterator();
        TableColumn tableColumn = null;
        int n = 0;
        while (iterator.hasNext()) {
            tableColumn = this.listTable.getColumnModel().getColumn(n++);
            int n2 = this.preferredColumnSizeHashMap.get(iterator.next());
            if (n2 < 20) {
                n2 = 45;
            }
            tableColumn.setPreferredWidth(n2);
        }
        this.tableScrollPane = new JScrollPane(this.listTable);
        this.activateAdvancedSortSearchButton = new JButton(this.advancedSortSearchIcon);
        this.activateAdvancedSortSearchButton.addActionListener(this);
        this.tableScrollPane.setCorner("UPPER_RIGHT_CORNER", this.activateAdvancedSortSearchButton);
        this.activateUpdateButton = new JButton(this.updateIcon);
        this.activateUpdateButton.addActionListener(this);
        this.tableScrollPane.setCorner("LOWER_RIGHT_CORNER", this.activateUpdateButton);
        this.tableScrollPane.setVerticalScrollBarPolicy(22);
        this.tableScrollPane.setHorizontalScrollBarPolicy(32);
        this.centerPanel.add(this.sqlTable, this.tableScrollPane);
        this.previousViewButton = new JButton(this.previousViewIcon);
        this.previousViewButton.setMargin(new Insets(0, 0, 0, 0));
        this.previousViewButton.addActionListener(this);
        string3 = this.resourceBundle.getResourceString("TableTabPanel.button.Close", "Close");
        this.closeViewButton = new JButton(string3);
        this.closeViewButton.addActionListener(this);
        this.nextViewButton = new JButton(this.nextViewIcon);
        this.nextViewButton.setMargin(new Insets(0, 0, 0, 0));
        this.nextViewButton.addActionListener(this);
        this.tableViewForm = new TableViewForm(this.viewFormFields, this.columnClassHashMap, this.columnTypeNameHashMap, this.columnSizeHashMap, this.previousViewButton, this.closeViewButton, this.nextViewButton);
        this.centerPanel.add(this.sqlTable + " Form", this.tableViewForm);
        this.add((Component)this.centerPanel, "Center");
        JPanel jPanel6 = new JPanel(gridBagLayout);
        jPanel6.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        JPanel jPanel7 = new JPanel();
        string3 = this.resourceBundle.getResourceString("TableTabPanel.button.View", "View");
        this.viewButton = new JButton(string3);
        this.viewButton.setMnemonic(86);
        this.viewButton.addActionListener(this);
        jPanel7.add(this.viewButton);
        if (!this.primaryKeys.isEmpty() && !this.viewOnly) {
            string3 = this.resourceBundle.getResourceString("TableTabPanel.button.Add", "Add");
            this.addButton = new JButton(string3);
            this.addButton.setMnemonic(65);
            this.addButton.addActionListener(this);
            jPanel7.add(this.addButton);
            string3 = this.resourceBundle.getResourceString("TableTabPanel.button.Edit", "Edit");
            this.editButton = new JButton(string3);
            this.editButton.setMnemonic(69);
            this.editButton.addActionListener(this);
            jPanel7.add(this.editButton);
            string3 = this.resourceBundle.getResourceString("TableTabPanel.button.Delete", "Delete");
            this.deleteButton = new JButton(string3);
            this.deleteButton.setMnemonic(68);
            this.deleteButton.addActionListener(this);
            jPanel7.add(this.deleteButton);
            string3 = this.resourceBundle.getResourceString("TableTabPanel.button.DeleteAll", "Delete All");
            this.deleteAllButton = new JButton(string3);
            this.deleteAllButton.addActionListener(this);
        }
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 98.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        jPanel6.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        jPanel9.setBorder(BorderFactory.createLoweredBevelBorder());
        this.refreshButton = new JButton(this.refreshIcon);
        this.refreshButton.setHorizontalAlignment(4);
        this.refreshButton.setMargin(new Insets(0, 0, 0, 0));
        this.refreshButton.setMnemonic(82);
        this.refreshButton.addActionListener(this);
        jPanel8.add(this.refreshButton);
        this.rowsLabel = new JLabel();
        this.setRowsLabel(this.tableRowStart + 1, this.tableRowStart + this.tableRowLimit);
        jPanel9.add(this.rowsLabel);
        jPanel8.add(jPanel9);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(gridBagLayout);
        this.previousTableRowsButton = new JButton(this.previousTableRowsIcon);
        this.previousTableRowsButton.setHorizontalAlignment(0);
        this.previousTableRowsButton.setMargin(new Insets(0, 0, 0, 0));
        this.previousTableRowsButton.setMnemonic(90);
        this.previousTableRowsButton.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100.0, 50.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.previousTableRowsButton, gridBagConstraints);
        jPanel10.add(this.previousTableRowsButton);
        this.nextTableRowsButton = new JButton(this.nextTableRowsIcon);
        this.nextTableRowsButton.setHorizontalAlignment(0);
        this.nextTableRowsButton.setMargin(new Insets(0, 0, 0, 0));
        this.nextTableRowsButton.setMnemonic(88);
        this.nextTableRowsButton.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100.0, 50.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.nextTableRowsButton, gridBagConstraints);
        jPanel10.add(this.nextTableRowsButton);
        jPanel8.add(jPanel10);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 2.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.nextTableRowsButton, gridBagConstraints);
        jPanel6.add(jPanel8);
        this.add((Component)jPanel6, "South");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.busyProcessing && !this.settingState) {
            this.panelSource = actionEvent.getSource();
            if (this.panelSource instanceof JButton || this.panelSource instanceof JRadioButton || this.panelSource instanceof JComboBox || this.panelSource instanceof JMenuItem) {
                if (this.panelSource instanceof JMenuItem) {
                    String string = ((JMenuItem)this.panelSource).getActionCommand();
                    if (string.equals("Select Fields")) {
                        this.selectTableFields();
                    } else if (string.equals("View")) {
                        this.viewButton.doClick();
                    } else if (string.equals("Add")) {
                        this.addButton.doClick();
                    } else if (string.equals("Edit")) {
                        this.editButton.doClick();
                    } else if (string.equals("Delete")) {
                        this.deleteButton.doClick();
                    } else if (string.equals("Delete All")) {
                        this.deleteAllButton.doClick();
                    } else if (string.equals("Select All")) {
                        this.listTable.selectAll();
                    } else if (string.equals("DeSelect All")) {
                        this.listTable.clearSelection();
                    } else if (string.equals((String)TransferHandler.getCopyAction().getValue("Name"))) {
                        Action action = this.listTable.getActionMap().get(string);
                        if (action != null) {
                            action.actionPerformed(new ActionEvent(this.listTable, 1001, null));
                        }
                    } else if (string.equals((String)TransferHandler.getPasteAction().getValue("Name"))) {
                        this.pasteClipboardContents();
                    } else if (string.equals("Clear History")) {
                        this.clearHistory();
                    } else if (string.equals("Save As Image")) {
                        this.listTable.clearSelection();
                        this.tableScrollPane.setVerticalScrollBarPolicy(21);
                        this.tableScrollPane.setHorizontalScrollBarPolicy(31);
                        ImageUtil imageUtil = new ImageUtil(this.tableScrollPane, this.lastSaveDirectory, "png");
                        this.lastSaveDirectory = imageUtil.getLastSaveDiretory();
                        this.tableScrollPane.setVerticalScrollBarPolicy(22);
                        this.tableScrollPane.setHorizontalScrollBarPolicy(32);
                    }
                } else if (this.panelSource instanceof JButton && ((JButton)this.panelSource).isShowing() || this.panelSource instanceof JButton && this.panelSource == this.deleteAllButton || this.panelSource instanceof JRadioButton || this.panelSource instanceof JComboBox) {
                    if (this.panelSource == this.previousStateButton || this.panelSource == this.nextStateButton) {
                        this.executeHistoryAction();
                    } else if (this.panelSource instanceof JComboBox && this.panelSource == this.searchComboBox) {
                        this.searchTextField.grabFocus();
                        this.searchTextField.setCaretPosition(this.searchTextField.getText().length());
                    } else if (this.panelSource instanceof JButton && this.panelSource == this.activateAdvancedSortSearchButton) {
                        if (this.advancedSortSearchFrame == null) {
                            this.createAdvancedSortSearchFrame();
                            this.advancedSortSearchFrame.setVisible(true);
                        } else if (this.advancedSortSearchFrame.isShowing()) {
                            this.advancedSortSearchFrame.setVisible(false);
                        } else {
                            this.advancedSortSearchFrame.setVisible(true);
                        }
                    } else if (this.panelSource instanceof JButton && this.panelSource == this.activateUpdateButton) {
                        if (this.updateFrame == null) {
                            this.createUpdateFrame();
                            this.updateFrame.setVisible(true);
                        } else if (this.updateFrame.isShowing()) {
                            this.updateFrame.setVisible(false);
                        } else {
                            this.updateFrame.setVisible(true);
                        }
                    } else if (this.panelSource instanceof JButton && this.panelSource == this.closeViewButton) {
                        this.toggleCenterPanel();
                        this.tableViewForm.clearBlobBytesHashMap();
                    } else {
                        this.selectedRow = this.listTable.getSelectedRow();
                        this.horizontalScrollBarPosition = this.tableScrollPane.getHorizontalScrollBar().getValue();
                        this.verticalScrollBarPosition = this.tableScrollPane.getVerticalScrollBar().getValue();
                        if (this.panelSource instanceof JButton && (this.panelSource == this.addButton || this.panelSource == this.editButton || this.panelSource == this.deleteButton || this.panelSource == this.deleteAllButton || this.panelSource == this.refreshButton || this.panelSource == this.previousTableRowsButton || this.panelSource == this.nextTableRowsButton)) {
                            this.historyAction = false;
                        }
                        DBTablesPanel.startStatusTimer();
                        this.busyProcessing = true;
                        Thread thread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                TableTabPanel.this.executeActions();
                                DBTablesPanel.stopStatusTimer();
                                TableTabPanel.this.busyProcessing = false;
                                TableTabPanel.this.historyAction = true;
                            }
                        }, "TableTabPanel.actionThread");
                        thread.start();
                    }
                } else {
                    this.historyAction = false;
                    this.setTableHeadings(this.getCurrentTableHeadings());
                    if (this.selectedRow != -1) {
                        this.listTable.changeSelection(this.selectedRow, 0, false, false);
                    }
                    if (this.horizontalScrollBarPosition != -1) {
                        this.tableScrollPane.getHorizontalScrollBar().setValue(this.horizontalScrollBarPosition);
                    }
                    if (this.verticalScrollBarPosition != -1) {
                        this.tableScrollPane.getVerticalScrollBar().setValue(this.verticalScrollBarPosition);
                    }
                    this.historyAction = true;
                }
            }
        }
    }

    private void validatePrimaryKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.primaryKeys) {
            arrayList.add(string);
        }
        for (String string : arrayList) {
            if (this.columnNamesHashMap.containsValue(string)) continue;
            this.primaryKeys.remove(string);
        }
    }

    private void selectTableFields() {
        String string = this.resourceBundle.getResourceString("TableTabPanel.dialogtitle.SelectSummaryTableFields", "Set Summary Table Fields");
        String string2 = this.resourceBundle.getResourceString("TableTabPanel.dialogbutton.OK", "OK");
        String string3 = this.resourceBundle.getResourceString("TableTabPanel.dialogbutton.Cancel", "Cancel");
        TableFieldSelectionPreferencesPanel tableFieldSelectionPreferencesPanel = new TableFieldSelectionPreferencesPanel(this, this.resourceBundle);
        Object[] objectArray = new Object[]{tableFieldSelectionPreferencesPanel};
        InputDialog inputDialog = new InputDialog(null, string, string2, string3, objectArray, null);
        inputDialog.pack();
        inputDialog.center();
        inputDialog.setVisible(true);
        if (inputDialog.isActionResult()) {
            tableFieldSelectionPreferencesPanel.updatePreferences();
        }
        inputDialog.dispose();
    }

    private void executeHistoryAction() {
        if (this.panelSource == this.previousStateButton) {
            --this.stateHistoryIndex;
            if (this.stateHistoryIndex <= 0) {
                this.stateHistoryIndex = 0;
                this.previousStateButton.setEnabled(false);
            }
        } else if (this.panelSource == this.nextStateButton) {
            ++this.stateHistoryIndex;
            if (this.stateHistoryIndex > 24) {
                this.stateHistoryIndex = 24;
                this.nextStateButton.setEnabled(false);
            }
        }
        if (this.stateHistoryIndex == 0) {
            this.previousStateButton.setEnabled(false);
        } else {
            this.previousStateButton.setEnabled(true);
        }
        if (this.stateHistoryIndex < this.stateHistory.size() - 1) {
            this.nextStateButton.setEnabled(true);
        } else {
            this.nextStateButton.setEnabled(false);
        }
        DBTablesPanel.startStatusTimer();
        this.historyAction = false;
        String string = Utils.stateConvert(this.stateHistory.get(this.stateHistoryIndex).getBytes(), true);
        this.setState(string);
        this.setTableHeadings(this.getCurrentTableHeadings());
        this.historyAction = true;
        DBTablesPanel.stopStatusTimer();
    }

    private void executeActions() {
        int n = 0;
        if (this.panelSource instanceof JButton) {
            Connection connection = ConnectionManager.getConnection("TableTabPanel actionPerformed()");
            if (connection == null) {
                return;
            }
            if (this.panelSource == this.searchButton || this.panelSource == this.clearSearchTextFieldButton) {
                this.advancedSortSearch = false;
                this.tableRowStart = 0;
                if (this.panelSource == this.clearSearchTextFieldButton) {
                    this.searchTextField.setText("");
                }
                this.loadTable(connection);
                this.tableModel.setValues(this.tableData);
                this.tableScrollPane.getVerticalScrollBar().setValue(0);
                this.centerCardLayout.show(this.centerPanel, this.sqlTable);
                this.setRowsLabel(this.tableRowStart + 1, this.tableRowStart + this.tableRowLimit);
            } else if (this.panelSource == this.advSortSearchApplyButton) {
                this.advancedSortSearch = true;
                this.tableRowStart = 0;
                this.loadTable(connection);
                this.tableModel.setValues(this.tableData);
                this.tableScrollPane.getVerticalScrollBar().setValue(0);
                this.centerCardLayout.show(this.centerPanel, this.sqlTable);
                this.setRowsLabel(this.tableRowStart + 1, this.tableRowStart + this.tableRowLimit);
            } else if (this.panelSource == this.previousTableRowsButton) {
                this.tableRowStart -= this.tableRowLimit;
                if (this.tableRowStart <= 0) {
                    this.tableRowStart = 0;
                }
                this.loadTable(connection);
                this.tableModel.setValues(this.tableData);
                this.tableScrollPane.getVerticalScrollBar().setValue(0);
                this.centerCardLayout.show(this.centerPanel, this.sqlTable);
                this.setRowsLabel(this.tableRowStart + 1, this.tableRowStart + this.tableRowLimit);
            } else if (this.panelSource == this.viewButton) {
                Object object;
                if (this.selectedRow != -1 && (object = this.listTable.getValueAt(this.selectedRow, n)) != null) {
                    try {
                        this.viewSelectedItem(connection, this.selectedRow);
                    }
                    catch (SQLException sQLException) {
                        ConnectionManager.displaySQLErrors(sQLException, "TableTabPanel executeActions()");
                    }
                    this.centerCardLayout.show(this.centerPanel, this.sqlTable + " Form");
                    this.tableViewForm.setFocus();
                }
            } else if (this.panelSource == this.addButton) {
                this.addItem(connection);
            } else if (this.panelSource == this.editButton) {
                if (this.selectedRow != -1) {
                    for (int i = 0; i < this.listTable.getColumnCount(); ++i) {
                        if (!this.columnNamesHashMap.get(this.listTable.getColumnName(i)).equals(this.primaryKeys.get(0))) continue;
                        n = i;
                    }
                    Object object = this.listTable.getValueAt(this.selectedRow, n);
                    String string = this.columnNamesHashMap.get(this.listTable.getColumnName(n));
                    if (object != null) {
                        try {
                            this.editSelectedItem(connection, this.selectedRow, string, object);
                        }
                        catch (SQLException sQLException) {
                            ConnectionManager.displaySQLErrors(sQLException, "TableTabPanel executeActions()");
                        }
                    }
                }
            } else if (this.panelSource == this.updateFormFindButton) {
                this.advancedSortSearch = true;
                this.tableRowStart = 0;
                if (this.advancedSortSearchFrame == null) {
                    this.createAdvancedSortSearchFrame();
                }
                this.advancedSortSearchFrame.setKeyComponentsState(this.updateFrame.getKeyComponentsState());
                this.loadTable(connection);
                this.tableModel.setValues(this.tableData);
                this.tableScrollPane.getVerticalScrollBar().setValue(0);
                this.centerCardLayout.show(this.centerPanel, this.sqlTable);
                this.setRowsLabel(this.tableRowStart + 1, this.tableRowStart + this.tableRowLimit);
            } else if (this.panelSource == this.deleteButton) {
                Object object;
                if (this.selectedRow != -1 && (object = this.listTable.getValueAt(this.selectedRow, n)) != null) {
                    try {
                        this.deleteSelectedItems(connection);
                    }
                    catch (SQLException sQLException) {
                        ConnectionManager.displaySQLErrors(sQLException, "TableTabPanel executeActions()");
                    }
                    this.loadTable(connection);
                    this.tableModel.setValues(this.tableData);
                    this.centerCardLayout.show(this.centerPanel, this.sqlTable);
                }
            } else if (this.panelSource == this.deleteAllButton) {
                try {
                    this.deleteAllItems(connection);
                }
                catch (SQLException sQLException) {
                    ConnectionManager.displaySQLErrors(sQLException, "TableTabPanel executeActions()");
                }
                this.loadTable(connection);
                this.tableModel.setValues(this.tableData);
                this.centerCardLayout.show(this.centerPanel, this.sqlTable);
            } else if (this.panelSource == this.nextTableRowsButton) {
                this.tableRowStart += this.tableRowLimit;
                this.loadTable(connection);
                this.tableModel.setValues(this.tableData);
                this.tableScrollPane.getVerticalScrollBar().setValue(0);
                this.centerCardLayout.show(this.centerPanel, this.sqlTable);
                this.setRowsLabel(this.tableRowStart + 1, this.tableRowStart + this.tableRowLimit);
            } else if (this.panelSource == this.previousViewButton || this.panelSource == this.nextViewButton) {
                if (this.selectedRow != -1) {
                    int n2 = Integer.parseInt(this.selectedRow + "");
                    int n3 = this.panelSource == this.previousViewButton ? Integer.parseInt(this.selectedRow + "") - 1 : Integer.parseInt(this.selectedRow + "") + 1;
                    if (n3 < 0 || n3 > this.tableRowLimit - 1) {
                        n3 = n2;
                    }
                    this.listTable.changeSelection(n3, 0, false, false);
                    this.selectedRow = this.listTable.getSelectedRow();
                    Object object = this.listTable.getValueAt(this.selectedRow, 0);
                    if (object != null) {
                        this.tableViewForm.clearBlobBytesHashMap();
                        try {
                            this.viewSelectedItem(connection, this.selectedRow);
                        }
                        catch (SQLException sQLException) {
                            ConnectionManager.displaySQLErrors(sQLException, "TableTabPanel executeActions()");
                        }
                        this.centerCardLayout.show(this.centerPanel, this.sqlTable + " Form");
                        this.tableViewForm.setFocus();
                    } else {
                        this.listTable.changeSelection(n2, 0, false, false);
                    }
                }
            } else if (this.panelSource == this.refreshButton) {
                this.loadTable(connection);
                this.tableModel.setValues(this.tableData);
                this.tableScrollPane.getVerticalScrollBar().setValue(0);
                this.centerCardLayout.show(this.centerPanel, this.sqlTable);
            }
            ConnectionManager.closeConnection(connection, "TableTabPanel actionPerformed()");
        } else if (this.panelSource instanceof JRadioButton) {
            if (this.panelSource == this.ascSortRadioButton || this.panelSource == this.descSortRadioButton) {
                Connection connection = ConnectionManager.getConnection("TableTabPanel actionPerformed()");
                if (connection == null) {
                    return;
                }
                this.ascDescString = this.ascSortRadioButton.isSelected() ? "ASC" : "DESC";
                this.advancedSortSearch = false;
                this.loadTable(connection);
                this.tableModel.setValues(this.tableData);
                this.tableScrollPane.getVerticalScrollBar().setValue(0);
                this.centerCardLayout.show(this.centerPanel, this.sqlTable);
                ConnectionManager.closeConnection(connection, "TableTabPanel actionPerformed()");
            }
        } else if (this.panelSource instanceof JComboBox && this.panelSource == this.sortComboBox) {
            Connection connection = ConnectionManager.getConnection("TableTabPanel actionPerformed()");
            if (connection == null) {
                return;
            }
            Object object = this.sortComboBox.getSelectedItem();
            if (!this.columnNamesHashMap.containsKey(object)) {
                this.sortComboBox.removeActionListener(this);
                this.sortComboBox.setSelectedIndex(1);
                this.sortComboBox.addActionListener(this);
            }
            this.advancedSortSearch = false;
            this.loadTable(connection);
            this.tableModel.setValues(this.tableData);
            this.tableScrollPane.getVerticalScrollBar().setValue(0);
            this.centerCardLayout.show(this.centerPanel, this.sqlTable);
            ConnectionManager.closeConnection(connection, "TableTabPanel actionPerformed()");
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\n') {
            this.searchButton.doClick();
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        if (tableColumnModelEvent.getFromIndex() != tableColumnModelEvent.getToIndex()) {
            this.sqlTableFieldsString = "";
            for (int i = 0; i < this.listTable.getColumnCount(); ++i) {
                this.sqlTableFieldsString = this.sqlTableFieldsString + this.identifierQuoteString + this.columnNamesHashMap.get(this.listTable.getColumnName(i)) + this.identifierQuoteString + ", ";
            }
            if (!this.sqlTableFieldsString.equals("")) {
                this.sqlTableFieldsString = this.sqlTableFieldsString.substring(0, this.sqlTableFieldsString.length() - 2);
            }
            this.loadTable(null);
        }
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    private void createListTablePopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        String string = this.resourceBundle.getResourceString("TableTabPanel.popup.SelectFields", "Select Fields");
        JMenuItem jMenuItem = this.menuItem(string, "Select Fields");
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        if (!this.primaryKeys.isEmpty()) {
            string = this.resourceBundle.getResourceString("TableTabPanel.button.View", "View");
            jMenuItem = this.menuItem(string, "View");
            jPopupMenu.add(jMenuItem);
            if (!this.viewOnly) {
                string = this.resourceBundle.getResourceString("TableTabPanel.button.Add", "Add");
                jMenuItem = this.menuItem(string, "Add");
                jPopupMenu.add(jMenuItem);
                string = this.resourceBundle.getResourceString("TableTabPanel.button.Edit", "Edit");
                jMenuItem = this.menuItem(string, "Edit");
                jPopupMenu.add(jMenuItem);
                string = this.resourceBundle.getResourceString("TableTabPanel.button.Delete", "Delete");
                jMenuItem = this.menuItem(string, "Delete");
                jPopupMenu.add(jMenuItem);
                jPopupMenu.addSeparator();
                string = this.resourceBundle.getResourceString("TableTabPanel.button.DeleteAll", "Delete All");
                jMenuItem = this.menuItem(string, "Delete All");
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.addSeparator();
        }
        string = this.resourceBundle.getResourceString("TableTabPanel.popup.SelectAll", "Select All");
        jMenuItem = this.menuItem(string, "Select All");
        jPopupMenu.add(jMenuItem);
        string = this.resourceBundle.getResourceString("TableTabPanel.popup.DeSelectAll", "DeSelect All");
        jMenuItem = this.menuItem(string, "DeSelect All");
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        string = this.resourceBundle.getResourceString("TableTabPanel.popup.Copy", "Copy");
        jMenuItem = string.equals("") ? new JMenuItem("Copy") : new JMenuItem(string);
        jMenuItem.setActionCommand((String)TransferHandler.getCopyAction().getValue("Name"));
        jMenuItem.setMnemonic(67);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        if (!this.primaryKeys.isEmpty() && !this.viewOnly) {
            string = this.resourceBundle.getResourceString("TableTabPanel.popup.Paste", "Paste");
            jMenuItem = new JMenuItem(string);
            jMenuItem.setActionCommand((String)TransferHandler.getPasteAction().getValue("Name"));
            jMenuItem.setMnemonic(86);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.addSeparator();
        string = this.resourceBundle.getResourceString("TableTabPanel.popup.ClearHistory", "Clear History");
        jMenuItem = this.menuItem(string, "Clear History");
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        string = this.resourceBundle.getResourceString("TableTabPanel.popup.SaveAsImage", "Save As Image");
        jMenuItem = this.menuItem(string, "Save As Image");
        jPopupMenu.add(jMenuItem);
        this.summaryTablePopupListener = new Main_MouseAdapter(jPopupMenu);
    }

    @Override
    public void createAdvancedSortSearchFrame() {
        this.advancedSortSearchFrame = new AdvancedSortSearchForm(this.schemaTableName, this.resourceBundle, this.columnNamesHashMap, this.columnClassHashMap, this.columnSQLTypeHashMap, this.columnTypeNameHashMap, this.comboBoxFields);
        this.advSortSearchApplyButton = this.advancedSortSearchFrame.getApplyButton();
        this.advSortSearchApplyButton.addActionListener(this);
        this.advancedSortSearchFrame.pack();
        this.advancedSortSearchFrame.center();
    }

    @Override
    public void createUpdateFrame() {
        this.updateFrame = new UpdateForm(this.schemaTableName, this.resourceBundle, this.columnNamesHashMap, this.columnClassHashMap, this.columnSQLTypeHashMap, this.columnTypeNameHashMap, this.columnSizeHashMap, this.comboBoxFields);
        this.updateFormFindButton = this.updateFrame.getFindButton();
        this.updateFormFindButton.addActionListener(this);
        this.updateFrame.getDisposeButton().addActionListener(this);
        this.updateFrame.pack();
        this.updateFrame.center();
    }

    private JMenuItem menuItem(String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(string2);
        return jMenuItem;
    }

    protected static String displayMyDateString(String string) {
        return Utils.convertDBDateString_To_ViewDateString(string, DBTablesPanel.getGeneralDBProperties().getViewDateFormat());
    }

    public String parseColumnNameField(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.indexOf(95) != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            while (stringTokenizer.hasMoreTokens()) {
                if (stringTokenizer.countTokens() > 1) {
                    stringBuffer.append(this.firstLetterToUpperCase(stringTokenizer.nextToken()) + " ");
                    continue;
                }
                stringBuffer.append(this.firstLetterToUpperCase(stringTokenizer.nextToken()));
            }
            string = stringBuffer.toString();
        } else {
            string = this.firstLetterToUpperCase(string);
        }
        return string;
    }

    private String firstLetterToUpperCase(String string) {
        if (string.length() != 0) {
            String string2 = string.substring(0, 1);
            string2 = string2.toUpperCase(Ajqvue.getLocale());
            return string2 + string.substring(1);
        }
        return string;
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    @Override
    public void saveHistory() {
        if (this.stateHistory.size() > 25) {
            this.stateHistory.removeFirst();
        }
        this.stateHistory.add(this.getState());
        ++this.stateHistoryIndex;
        if (this.stateHistoryIndex == 0) {
            this.previousStateButton.setEnabled(false);
        } else {
            this.previousStateButton.setEnabled(true);
        }
        if (this.stateHistoryIndex < this.stateHistory.size() - 1) {
            this.nextStateButton.setEnabled(true);
        } else {
            this.nextStateButton.setEnabled(false);
        }
    }

    public void clearHistory() {
        this.stateHistory.clear();
        this.stateHistory.add(this.getState());
        this.stateHistoryIndex = 0;
        this.previousStateButton.setEnabled(false);
        this.nextStateButton.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setSpecialFieldData(TableEntryForm tableEntryForm, Connection connection, Object object, Object object2) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string;
            ArrayList<String> arrayList;
            statement = connection.createStatement();
            if (((String)object).equals("Your Table Field")) {
                resultSet = statement.executeQuery("SELECT YourTableField FROM YourTable");
                arrayList = new ArrayList<String>();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(1));
                }
                tableEntryForm.setComboBoxField(object, arrayList, object2);
            }
            if (!this.columnEnumHashMap.containsKey(object)) {
                if (!this.columnSetHashMap.containsKey(object)) return;
            }
            arrayList = new ArrayList();
            if (this.columnEnumHashMap.containsKey(object)) {
                string = this.columnEnumHashMap.get(object);
                if (string.equals("tinyint(1)") || string.toUpperCase(Locale.ENGLISH).equals("BOOL") || string.toUpperCase(Locale.ENGLISH).equals("BOOLEAN") || string.toUpperCase(Locale.ENGLISH).equals("BIT")) {
                    string = "('TRUE','FALSE')";
                }
            } else {
                string = this.columnSetHashMap.get(object);
            }
            if (string.indexOf("(") != -1 && string.indexOf(")") != -1) {
                string = string.substring(string.indexOf("(") + 1, string.lastIndexOf(")"));
            }
            string = string.replaceAll(",", "");
            string = string.replaceAll("''", "'");
            String[] stringArray = string.split("\\'");
            for (int i = 1; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            if (this.columnEnumHashMap.containsKey(object)) {
                tableEntryForm.setComboBoxField(object, arrayList, object2);
                return;
            }
            tableEntryForm.setSetFields(object, arrayList, object2);
            return;
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "TableTabPanel setSpecialFieldData()");
            return;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "TableTabPanel setSpecialFieldData()");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSelectedItems(Connection connection) throws SQLException {
        int n = 0;
        int[] nArray = this.listTable.getSelectedRows();
        if (nArray.length != 0) {
            String string = this.resourceBundle.getResourceString("TableTabPanel.message.DeleteItems", "Delete Selected Items(s)?");
            JLabel jLabel = new JLabel(string, 0);
            jLabel.setFont(new Font("DIALOG", 1, 14));
            jLabel.setForeground(Color.RED);
            Object[] objectArray = new Object[]{jLabel};
            String string2 = this.resourceBundle.getResourceString("TableTabPanel.dialogtitle.AlertDialog", "Alert Dialog");
            String string3 = this.resourceBundle.getResourceString("TableTabPanel.dialogbutton.Cancel", "Cancel");
            String string4 = this.resourceBundle.getResourceString("TableTabPanel.dialogbutton.OK", "OK");
            InputDialog inputDialog = new InputDialog(null, string2, string4, string3, objectArray, this.deleteDataIcon);
            inputDialog.pack();
            inputDialog.center();
            inputDialog.setResizable(false);
            inputDialog.setVisible(true);
            if (inputDialog.isActionResult()) {
                Statement statement = null;
                try {
                    connection.setAutoCommit(false);
                    statement = connection.createStatement();
                    String string5 = ConnectionManager.getDataSourceType();
                    if (string5.equals("mysql") || string5.equals("mariadb") || string5.equals("postgresql")) {
                        statement.executeUpdate("BEGIN");
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("DELETE FROM " + this.schemaTableName + " WHERE ");
                    for (int i = 0; i < nArray.length; ++i) {
                        if (this.listTable.getValueAt(nArray[i], 0) == null) continue;
                        for (String string6 : this.primaryKeys) {
                            String string7 = this.columnTypeNameHashMap.get(this.parseColumnNameField(string6));
                            String string8 = this.columnClassHashMap.get(this.parseColumnNameField(string6));
                            for (int j = 0; j < this.listTable.getColumnCount(); ++j) {
                                if (!this.listTable.getColumnName(j).equals(this.parseColumnNameField(string6))) continue;
                                n = j;
                            }
                            Object object = this.listTable.getValueAt(nArray[i], n);
                            if (object instanceof BlobTextKey) {
                                String string9 = ((BlobTextKey)object).getContent();
                                string9 = string9.replaceAll("'", "''");
                                stringBuffer.append(this.identifierQuoteString + string6 + this.identifierQuoteString + " LIKE '" + string9 + "%' AND ");
                                continue;
                            }
                            if (this.columnClassHashMap.get(this.parseColumnNameField(string6)).indexOf("String") != -1) {
                                object = ((String)object).replaceAll("'", "''");
                            }
                            if (string7.equals("DATE")) {
                                if (string5.equals("mysql") || string5.equals("mariadb")) {
                                    stringBuffer.append(this.identifierQuoteString + string6 + this.identifierQuoteString + "=STR_TO_DATE('" + Utils.convertViewDateString_To_DBDateString(object + "", DBTablesPanel.getGeneralDBProperties().getViewDateFormat()) + "', '%Y-%m-%d') AND ");
                                    continue;
                                }
                                if (string5.equals("oracle")) {
                                    stringBuffer.append(this.identifierQuoteString + string6 + this.identifierQuoteString + "=TO_DATE('" + Utils.convertViewDateString_To_DBDateString(object + "", DBTablesPanel.getGeneralDBProperties().getViewDateFormat()) + "', 'YYYY-MM-dd') AND ");
                                    continue;
                                }
                                stringBuffer.append(this.identifierQuoteString + string6 + this.identifierQuoteString + "='" + Utils.convertViewDateString_To_DBDateString(object + "", DBTablesPanel.getGeneralDBProperties().getViewDateFormat()) + "' AND ");
                                continue;
                            }
                            if (string7.equals("DATETIME")) {
                                String string10 = (String)object;
                                if (string10.indexOf(" ") != -1) {
                                    object = Utils.processDateFormatSearch(string10.substring(0, string10.indexOf(" "))) + string10.substring(string10.indexOf(" "));
                                } else if (string10.indexOf("-") != -1 || string10.indexOf("/") != -1) {
                                    object = Utils.processDateFormatSearch(string10);
                                }
                                if (string5.equals("odbc")) {
                                    stringBuffer.append(this.identifierQuoteString + string6 + this.identifierQuoteString + "=#" + object + "# AND ");
                                    continue;
                                }
                                stringBuffer.append(this.identifierQuoteString + string6 + this.identifierQuoteString + "='" + object + "' AND ");
                                continue;
                            }
                            if ((string5.equals("odbc") || string5.equals("derby") || string5.indexOf("hsql") != -1) && string8.toLowerCase(Locale.ENGLISH).indexOf("string") == -1) {
                                stringBuffer.append(this.identifierQuoteString + string6 + this.identifierQuoteString + "=" + object + " AND ");
                                continue;
                            }
                            stringBuffer.append(this.identifierQuoteString + string6 + this.identifierQuoteString + "='" + object + "' AND ");
                        }
                        stringBuffer.delete(stringBuffer.length() - 5, stringBuffer.length());
                        statement.executeUpdate(stringBuffer.toString());
                        stringBuffer.delete(0, stringBuffer.length());
                        stringBuffer.append("DELETE FROM " + this.schemaTableName + " WHERE ");
                    }
                    connection.commit();
                }
                catch (SQLException sQLException) {
                    ConnectionManager.displaySQLErrors(sQLException, "TableTabPanel deleteSelectedItems()");
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException2) {
                        ConnectionManager.displaySQLErrors(sQLException, "TableTabPanel deleteSelectedItems() rollback failed");
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                    connection.setAutoCommit(true);
                }
            }
            inputDialog.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllItems(Connection connection) throws SQLException {
        String string = this.resourceBundle.getResourceString("TableTabPanel.message.DeleteAllItems", "Delete All Table Rows!");
        JLabel jLabel = new JLabel(string, 0);
        jLabel.setFont(new Font("DIALOG", 1, 14));
        jLabel.setForeground(Color.RED);
        String string2 = this.resourceBundle.getResourceString("TableTabPanel.checkbox.ConfirmDeletion", "Confirm Deletion");
        JCheckBox jCheckBox = new JCheckBox(string2, false);
        Object[] objectArray = new Object[]{jLabel, jCheckBox};
        String string3 = this.resourceBundle.getResourceString("TableTabPanel.dialogtitle.AlertDialog", "Alert Dialog");
        String string4 = this.resourceBundle.getResourceString("TableTabPanel.dialogbutton.Cancel", "Cancel");
        String string5 = this.resourceBundle.getResourceString("TableTabPanel.dialogbutton.OK", "OK");
        InputDialog inputDialog = new InputDialog(null, string3, string5, string4, objectArray, this.deleteDataIcon);
        inputDialog.pack();
        inputDialog.center();
        inputDialog.setResizable(false);
        inputDialog.setVisible(true);
        if (inputDialog.isActionResult() && jCheckBox.isSelected()) {
            Statement statement = null;
            try {
                connection.setAutoCommit(false);
                statement = connection.createStatement();
                String string6 = ConnectionManager.getDataSourceType();
                if (string6.equals("mysql") || string6.equals("mariadb") || string6.equals("postgresql")) {
                    statement.executeUpdate("BEGIN");
                }
                String string7 = string6.indexOf("hsql") != -1 ? "TRUNCATE TABLE " + this.schemaTableName + " RESTART IDENTITY  AND COMMIT" : "DELETE FROM " + this.schemaTableName;
                statement.executeUpdate(string7);
                connection.commit();
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "TableTabPanel deleteAllItems()");
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException2) {
                    ConnectionManager.displaySQLErrors(sQLException2, "TableTabPanel deleteAllItems() rollback failed");
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                connection.setAutoCommit(true);
            }
        }
        inputDialog.dispose();
    }

    @Override
    public void pasteClipboardContents() {
        String string;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String string2 = System.getProperty("user.home") + System.getProperty("file.separator") + "tmpdata.txt";
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "";
        try {
            for (int i = 0; i < this.listTable.getColumnCount(); ++i) {
                stringBuffer.append(this.columnNamesHashMap.get(this.listTable.getColumnName(i)) + DBTablesPanel.getDataImportProperties().getDataDelimiter());
            }
            stringBuffer.append("\n");
            Object object = toolkit.getSystemClipboard().getContents(this).getTransferData(DataFlavor.stringFlavor);
            if (object == null) {
                return;
            }
            WriteDataFile.mainWriteDataString(string2, (stringBuffer.toString() + (String)object).getBytes(), false);
            ButtonGroup buttonGroup = new ButtonGroup();
            String string4 = this.resourceBundle.getResourceString("TableTabPanel.radiobutton.Insert", "Insert");
            JRadioButton jRadioButton = new JRadioButton(string4, true);
            buttonGroup.add(jRadioButton);
            string4 = this.resourceBundle.getResourceString("TableTabPanel.radiobutton.Update", "Update");
            JRadioButton jRadioButton2 = new JRadioButton(string4, false);
            buttonGroup.add(jRadioButton2);
            String string5 = this.resourceBundle.getResourceString("TableTabPanel.message.WarningLossData", "Warning Import May Cause Loss of Data!");
            JLabel jLabel = new JLabel(string5, 0);
            jLabel.setForeground(Color.RED);
            Object[] objectArray = new Object[]{jLabel, jRadioButton, jRadioButton2};
            string = this.resourceBundle.getResourceString("TableTabPanel.dialogtitle.InsertOrUpdate", "Insert Or Update");
            String string6 = this.resourceBundle.getResourceString("TableTabPanel.dialogbutton.Cancel", "Cancel");
            String string7 = this.resourceBundle.getResourceString("TableTabPanel.dialogbutton.OK", "OK");
            InputDialog inputDialog = new InputDialog(null, string, string7, string6, objectArray, this.deleteDataIcon);
            inputDialog.pack();
            inputDialog.setResizable(false);
            inputDialog.center();
            inputDialog.setVisible(true);
            if (inputDialog.isActionResult()) {
                String string8 = jRadioButton.isSelected() ? jRadioButton.getText() : jRadioButton2.getText();
                Thread thread = new Thread((Runnable)new CSVDataImportThread(string2, string8, true), "CSVDataImportThread");
                thread.start();
            }
            inputDialog.dispose();
        }
        catch (IllegalStateException illegalStateException) {
            String string9 = this.resourceBundle.getResourceString("TableTabPanel.message.ClipboardUnavailable", "Clipboard Currently Unavailable");
            string3 = string9 + " : " + illegalStateException;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            String string10 = this.resourceBundle.getResourceString("TableTabPanel.message.UnsupportedData", "Unsupported Data Flavor");
            string3 = string10 + " : " + unsupportedFlavorException;
        }
        catch (IOException iOException) {
            String string11 = this.resourceBundle.getResourceString("TableTabPanel.message.I/OException", "I/O Exception");
            string3 = string11 + " : " + iOException;
        }
        if (!string3.equals("")) {
            string = this.resourceBundle.getResourceString("TableTabPanel.dialogtitle.Alert", "Alert");
            JOptionPane.showMessageDialog(null, "TableTabPanel.pasteClipboardContents(), " + string3, string, 0);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        repaintManager.setDoubleBufferingEnabled(false);
        Rectangle rectangle = graphics2D.getClipBounds();
        double d = rectangle.getWidth() / (double)this.getWidth();
        graphics2D.scale(d, d);
        this.paintAll(graphics2D);
        repaintManager.setDoubleBufferingEnabled(true);
        return 0;
    }

    @Override
    public ArrayList<String> getTableFields() {
        if (this.fields == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    @Override
    public ArrayList<String> getCurrentTableHeadings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = this.currentTableHeadings.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    @Override
    public ArrayList<String> getAllTableHeadings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = this.allTableHeadings.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    @Override
    public String getTableName() {
        return this.sqlTable;
    }

    @Override
    public String getSaveFileName() {
        return this.saveFileName;
    }

    @Override
    public StringBuffer getTableSQLStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.sqlTableStatement.substring(0, this.sqlTableStatement.length()));
        return stringBuffer;
    }

    @Override
    public int getTableRowStart() {
        return this.tableRowStart;
    }

    @Override
    public int getTableRowLimit() {
        return this.tableRowLimit;
    }

    @Override
    public int getTableRowSize() {
        return this.tableRowLimit;
    }

    @Override
    public JTable getListTable() {
        return this.listTable;
    }

    @Override
    public int getValidDataRowCount() {
        int n = 0;
        for (int i = 0; i < this.listTable.getRowCount(); ++i) {
            if (this.listTable.getValueAt(i, 0) == null) continue;
            ++n;
        }
        return n;
    }

    @Override
    public ArrayList<String> getPrimaryKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = this.primaryKeys.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    @Override
    public ArrayList<String> getForeignKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = this.foreignKeys.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    @Override
    public ArrayList<String> getExportedKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = this.exportedKeys.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    @Override
    public HashMap<String, String> getAutoIncrementHashMap() {
        return this.autoIncrementHashMap;
    }

    @Override
    public HashMap<String, String> getColumnNamesHashMap() {
        return this.columnNamesHashMap;
    }

    @Override
    public HashMap<String, String> getColumnClassHashMap() {
        return this.columnClassHashMap;
    }

    @Override
    public HashMap<String, Integer> getColumnSQLTypeHashMap() {
        return this.columnSQLTypeHashMap;
    }

    @Override
    public HashMap<String, String> getColumnTypeNameHashMap() {
        return this.columnTypeNameHashMap;
    }

    @Override
    public HashMap<String, Integer> getColumnSizeHashMap() {
        return this.columnSizeHashMap;
    }

    @Override
    public HashMap<String, String> getColumnEnumHashMap() {
        return this.columnEnumHashMap;
    }

    @Override
    public HashMap<String, String> getColumnSetHashMap() {
        return this.columnSetHashMap;
    }

    @Override
    public String getState() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = TableTabPanel.getStateDelimiter();
        stringBuffer.append(this.sqlTable + string);
        stringBuffer.append(this.tableRowStart + string + this.tableRowLimit + string);
        Iterator<String> iterator = this.currentTableHeadings.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next() + ";");
        }
        stringBuffer.append(string);
        stringBuffer.append(this.sqlTableStatement + string + this.advancedSortSearch + string);
        if (this.advancedSortSearchFrame != null) {
            stringBuffer.append(this.advancedSortSearchFrame.getKeyComponentsState() + string);
        } else {
            stringBuffer.append(string);
        }
        stringBuffer.append(this.ascSortRadioButton.isSelected() + string + this.descSortRadioButton.isSelected() + string);
        stringBuffer.append(this.sortComboBox.getSelectedIndex() + string);
        stringBuffer.append(this.searchTextField.getText() + string);
        stringBuffer.append(this.searchComboBox.getSelectedIndex() + string);
        return Utils.stateConvert(stringBuffer.toString().getBytes(), false);
    }

    public static String getStateDelimiter() {
        return STATE_DELIMITER;
    }

    @Override
    public void setTableHeadings(ArrayList<String> arrayList) {
        Connection connection = ConnectionManager.getConnection("TableTabPanel setTableHeadings()");
        if (connection == null) {
            return;
        }
        this.centerPanel.remove(this.tableScrollPane);
        this.currentTableHeadings = arrayList;
        this.sqlTableFieldsString = "";
        Iterator<String> iterator = this.currentTableHeadings.iterator();
        while (iterator.hasNext()) {
            this.sqlTableFieldsString = this.sqlTableFieldsString + this.identifierQuoteString + this.columnNamesHashMap.get(iterator.next()) + this.identifierQuoteString + ", ";
        }
        if (this.sqlTableFieldsString.equals("")) {
            this.tableData = new Object[0][0];
        } else {
            this.sqlTableFieldsString = this.sqlTableFieldsString.substring(0, this.sqlTableFieldsString.length() - 2);
            this.loadTable(connection);
        }
        this.tableModel = new TableModel(this.currentTableHeadings, this.tableData);
        this.tableModel.setValues(this.tableData);
        this.listTable = new JTable(this.tableModel);
        this.listTable.setAutoResizeMode(0);
        this.listTable.getActionMap().put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        this.listTable.getActionMap().put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        this.listTable.addMouseListener(this.summaryTablePopupListener);
        this.listTable.getColumnModel().addColumnModelListener(this);
        iterator = this.currentTableHeadings.iterator();
        TableColumn tableColumn = null;
        int n = 0;
        while (iterator.hasNext()) {
            String string = iterator.next();
            tableColumn = this.listTable.getColumnModel().getColumn(n++);
            tableColumn.setPreferredWidth(this.preferredColumnSizeHashMap.get(string));
        }
        this.tableScrollPane = new JScrollPane(this.listTable);
        this.tableScrollPane.setCorner("UPPER_RIGHT_CORNER", this.activateAdvancedSortSearchButton);
        this.tableScrollPane.setCorner("LOWER_RIGHT_CORNER", this.activateUpdateButton);
        this.tableScrollPane.setVerticalScrollBarPolicy(22);
        this.tableScrollPane.setHorizontalScrollBarPolicy(32);
        this.centerPanel.add(this.sqlTable, this.tableScrollPane);
        this.centerCardLayout.show(this.centerPanel, this.sqlTable);
        ConnectionManager.closeConnection(connection, "TableTabPanel setTableHeadings()");
    }

    @Override
    public void setTableRowSize(int n) {
        this.tableRowLimit = n;
        this.setTableHeadings(this.getCurrentTableHeadings());
        this.setRowsLabel(this.tableRowStart + 1, this.tableRowStart + this.tableRowLimit);
    }

    @Override
    public void setSaveFileName(String string) {
        this.saveFileName = string;
    }

    @Override
    public void setSearchTextField(String string) {
        this.advancedSortSearch = false;
        this.searchComboBox.removeActionListener(this);
        this.searchComboBox.setSelectedIndex(0);
        this.searchComboBox.addActionListener(this);
        this.searchTextField.setText(string);
        this.setTableRowSize(this.tableRowLimit);
    }

    private void setRowsLabel(int n, int n2) {
        String string = this.resourceBundle.getResourceString("TableTabPanel.label.Rows", "Rows");
        this.rowsLabel.setText(string + ": " + n + " - " + n2);
    }

    @Override
    public void setState(String string) {
        String string2 = TableTabPanel.getStateDelimiter();
        String[] stringArray = string.split(string2);
        if (stringArray.length == 12) {
            try {
                this.settingState = true;
                for (int i = 1; i < stringArray.length; ++i) {
                    int n;
                    int n2;
                    if (i == 1) {
                        this.tableRowStart = Integer.parseInt(stringArray[i]);
                        continue;
                    }
                    if (i == 2) {
                        this.tableRowLimit = Integer.parseInt(stringArray[i]);
                        continue;
                    }
                    if (i == 3) {
                        String[] stringArray2 = stringArray[i].split(";");
                        if (stringArray2.length == 0) continue;
                        ArrayList<String> arrayList = new ArrayList<String>();
                        boolean bl = true;
                        for (int j = 0; j < stringArray2.length; ++j) {
                            if (!this.allTableHeadings.contains(stringArray2[j])) {
                                String string3 = this.resourceBundle.getResourceString("TableTabPanel.message.SetTableField", "Unable to Set Table Fields. Possible Corrupt File!");
                                String string4 = this.resourceBundle.getResourceString("TableTabPanel.dialogtitle.Alert", "Alert");
                                JOptionPane.showMessageDialog(null, string3, string4, 0);
                                bl = false;
                                break;
                            }
                            arrayList.add(stringArray2[j]);
                        }
                        if (!bl) continue;
                        this.currentTableHeadings = arrayList;
                        continue;
                    }
                    if (i == 4) {
                        this.sqlTableStatement.delete(0, this.sqlTableStatement.length());
                        this.sqlTableStatement.append(stringArray[i]);
                        continue;
                    }
                    if (i == 5) {
                        if (stringArray[i].equals("true")) {
                            this.advancedSortSearch = true;
                            continue;
                        }
                        this.advancedSortSearch = false;
                        continue;
                    }
                    if (i == 6) {
                        if (this.advancedSortSearchFrame != null) {
                            this.advancedSortSearchFrame.setKeyComponentsState(stringArray[i]);
                            continue;
                        }
                        if (stringArray[i].equals("")) continue;
                        this.createAdvancedSortSearchFrame();
                        this.advancedSortSearchFrame.setKeyComponentsState(stringArray[i]);
                        continue;
                    }
                    if (i == 7) {
                        if (stringArray[i].equals("true")) {
                            this.ascSortRadioButton.setSelected(true);
                            this.ascDescString = "ASC";
                            continue;
                        }
                        this.descSortRadioButton.setSelected(true);
                        this.ascDescString = "DESC";
                        continue;
                    }
                    if (i == 8) continue;
                    if (i == 9) {
                        n2 = this.sortComboBox.getItemCount();
                        n = Integer.parseInt(stringArray[i]);
                        if (n <= -1 || n >= n2) continue;
                        this.sortComboBox.setSelectedIndex(n);
                        continue;
                    }
                    if (i == 10) {
                        this.searchTextField.setText(stringArray[i]);
                        continue;
                    }
                    n2 = this.sortComboBox.getItemCount();
                    n = Integer.parseInt(stringArray[i]);
                    if (n <= -1 || n >= n2) continue;
                    this.searchComboBox.setSelectedIndex(n);
                }
                this.setRowsLabel(this.tableRowStart + 1, this.tableRowStart + this.tableRowLimit);
                this.settingState = false;
            }
            catch (NumberFormatException numberFormatException) {
                this.settingState = false;
                String string5 = "Unable to Set Sort or Search Fields. Possible Corrupt File!";
                JOptionPane.showMessageDialog(null, string5, "Alert", 0);
            }
        } else {
            String string6 = "Unable to Set Table State. Possible Corrupt File!";
            JOptionPane.showMessageDialog(null, string6, "Alert", 0);
        }
    }

    @Override
    public void setViewOnly(boolean bl) {
        this.viewOnly = bl;
        if (this.viewButton != null) {
            this.viewButton.setEnabled(!bl);
        }
        if (this.addButton != null && this.editButton != null && this.deleteButton != null) {
            this.addButton.setEnabled(!bl);
            this.editButton.setEnabled(!bl);
            this.deleteButton.setEnabled(!bl);
        }
        this.createListTablePopupMenu();
        this.listTable.addMouseListener(this.summaryTablePopupListener);
        this.listTable.getColumnModel().addColumnModelListener(this);
    }

    private void toggleCenterPanel() {
        this.centerCardLayout.next(this.centerPanel);
        this.centerPanel.requestFocus();
    }
}

