/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TableFieldSelectionPreferencesPanel
extends JPanel
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 3200553393287146930L;
    private TableTabPanel tableTabPanel;
    private ArrayList<String> checkBoxFields;
    private JCheckBox[] columnNamesCheckBoxes;
    private HashMap<String, JCheckBox> checkBoxesHashMap;
    private HashMap<String, String> columnNamesHashMap;
    private ArrayList<String> primaryKeys;
    private JButton selectAllButton;
    private JButton clearAllButton;
    private JButton applyButton;

    public TableFieldSelectionPreferencesPanel(TableTabPanel tableTabPanel, AResourceBundle aResourceBundle) {
        Object object;
        this.tableTabPanel = tableTabPanel;
        this.setLayout(new BorderLayout());
        this.checkBoxesHashMap = new HashMap();
        String string = Utils.getIconsDirectory() + Utils.getFileSeparator();
        ImageIcon imageIcon = aResourceBundle.getResourceImage(string + "keyUpIcon.png");
        ImageIcon imageIcon2 = aResourceBundle.getResourceImage(string + "keyDownIcon.png");
        this.checkBoxFields = tableTabPanel.getAllTableHeadings();
        int n = this.checkBoxFields.size() / 2;
        if (this.checkBoxFields.size() % 2 > 0) {
            n = this.checkBoxFields.size() / 2 + 1;
        }
        JPanel jPanel = new JPanel(new GridLayout(n, 4, 0, 0));
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        Iterator<String> iterator = this.checkBoxFields.iterator();
        this.columnNamesCheckBoxes = new JCheckBox[this.checkBoxFields.size()];
        this.columnNamesHashMap = tableTabPanel.getColumnNamesHashMap();
        this.primaryKeys = tableTabPanel.getPrimaryKeys();
        int n2 = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (this.primaryKeys.contains(this.columnNamesHashMap.get(object))) {
                this.columnNamesCheckBoxes[n2] = new JCheckBox((String)object, imageIcon);
                this.columnNamesCheckBoxes[n2].setSelectedIcon(imageIcon2);
            } else {
                this.columnNamesCheckBoxes[n2] = new JCheckBox((String)object);
            }
            jPanel.add(this.columnNamesCheckBoxes[n2]);
            this.checkBoxesHashMap.put((String)object, this.columnNamesCheckBoxes[n2++]);
        }
        this.loadPreferences();
        object = new JScrollPane(jPanel);
        ((JScrollPane)object).getVerticalScrollBar().setUnitIncrement(10);
        this.add((Component)object, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        String string2 = aResourceBundle.getResourceString("TableFieldSelectionPreferencesPanel.button.SelectAll", "Select All");
        this.selectAllButton = new JButton(string2);
        this.selectAllButton.setFocusPainted(false);
        this.selectAllButton.addActionListener(this);
        jPanel2.add(this.selectAllButton);
        string2 = aResourceBundle.getResourceString("TableFieldSelectionPreferencesPanel.button.ClearAll", "Clear All");
        this.clearAllButton = new JButton(string2);
        this.clearAllButton.setFocusPainted(false);
        this.clearAllButton.addActionListener(this);
        jPanel2.add(this.clearAllButton);
        string2 = aResourceBundle.getResourceString("TableFieldSelectionPreferencesPanel.button.Apply", "Apply");
        this.applyButton = new JButton(string2);
        this.applyButton.setFocusPainted(false);
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(this);
        jPanel2.add(this.applyButton);
        this.add((Component)jPanel2, "South");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.applyButton) {
            this.updatePreferences();
            this.applyButton.setEnabled(false);
        } else if (object == this.selectAllButton) {
            for (int i = 0; i < this.columnNamesCheckBoxes.length; ++i) {
                this.columnNamesCheckBoxes[i].setSelected(true);
            }
            this.applyButton.setEnabled(true);
        } else if (object == this.clearAllButton) {
            for (int i = 0; i < this.columnNamesCheckBoxes.length; ++i) {
                if (this.primaryKeys.contains(this.columnNamesHashMap.get(this.columnNamesCheckBoxes[i].getText()))) continue;
                this.columnNamesCheckBoxes[i].setSelected(false);
            }
            this.applyButton.setEnabled(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof JCheckBox) {
            this.applyButton.setEnabled(true);
        }
    }

    private void loadPreferences() {
        ArrayList<String> arrayList = this.tableTabPanel.getCurrentTableHeadings();
        for (String string : this.checkBoxFields) {
            JCheckBox jCheckBox = this.checkBoxesHashMap.get(string);
            if (arrayList.contains(string)) {
                jCheckBox.setSelected(true);
            }
            jCheckBox.addItemListener(this);
        }
    }

    public void updatePreferences() {
        if (this.applyButton.isEnabled()) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int n = TableFieldSelectionPreferencesPanel.this.columnNamesCheckBoxes.length;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    Boolean bl = false;
                    for (int i = 0; i < n; ++i) {
                        if (TableFieldSelectionPreferencesPanel.this.columnNamesCheckBoxes[i].isSelected()) {
                            arrayList.add(TableFieldSelectionPreferencesPanel.this.columnNamesCheckBoxes[i].getText());
                            continue;
                        }
                        if (!TableFieldSelectionPreferencesPanel.this.primaryKeys.contains(TableFieldSelectionPreferencesPanel.this.columnNamesHashMap.get(TableFieldSelectionPreferencesPanel.this.columnNamesCheckBoxes[i].getText()))) continue;
                        bl = true;
                    }
                    TableFieldSelectionPreferencesPanel.this.tableTabPanel.setTableHeadings(arrayList);
                    TableFieldSelectionPreferencesPanel.this.tableTabPanel.setViewOnly(bl);
                }
            }, "TableFieldSelectionPreferencesPanel.updatetableTabPanelFieldsThread");
            thread.start();
        }
    }
}

