/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class SplashPanel
extends JPanel
implements Runnable {
    private static final long serialVersionUID = -550868033213460847L;
    private transient Image backgroundImage;
    private int backgroundImageWidth;
    private int backgroundImageHeight;
    private transient Image offScreenGraphicsImage;
    private Font versionFont;
    private double xCoordinate;
    private double yCoordinate;
    private double symbolWidth;
    private double symbolHeight;
    private double symbol_XPosition;
    private double symbol_YPosition;
    private Random random;
    private boolean runThread;
    private boolean suspendThread;
    private static final int frameDelay = 200;
    private String versionString;

    public SplashPanel(AResourceBundle aResourceBundle) {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createLoweredBevelBorder()));
        String string = Utils.getFileSeparator();
        this.backgroundImage = aResourceBundle.getResourceImage("images" + string + "Ajqvue_Splash.jpg").getImage();
        this.backgroundImageWidth = this.backgroundImage.getWidth(null);
        this.backgroundImageHeight = this.backgroundImage.getHeight(null);
        this.versionFont = new Font("Serif", 2, 16);
        String string2 = aResourceBundle.getResourceString("SplashPanel.label.Version", "Version");
        this.versionString = string2 + " " + Ajqvue.getVersion()[1];
        this.xCoordinate = -5.0;
        this.yCoordinate = -5.0;
        this.symbolWidth = 8.0;
        this.symbolHeight = 20.0;
        this.symbol_XPosition = 35.0;
        this.symbol_YPosition = 180.0;
        this.random = new Random();
        this.runThread = true;
        this.suspendThread = false;
    }

    @Override
    public void run() {
        while (this.runThread) {
            this.render();
            this.timeStep();
        }
    }

    private void render() {
        Dimension dimension;
        if (this.getGraphics() != null && this.checkImage(dimension = this.getSize())) {
            this.drawPanel(this.offScreenGraphicsImage.getGraphics());
            this.getGraphics().drawImage(this.offScreenGraphicsImage, 0, 0, null);
        }
    }

    private boolean checkImage(Dimension dimension) {
        if (dimension.width == 0 || dimension.height == 0) {
            return false;
        }
        if (this.offScreenGraphicsImage == null || this.offScreenGraphicsImage.getWidth(null) != dimension.width || this.offScreenGraphicsImage.getHeight(null) != dimension.height) {
            this.offScreenGraphicsImage = this.createImage(dimension.width, dimension.height);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeStep() {
        try {
            Thread.sleep(200L);
            SplashPanel splashPanel = this;
            synchronized (splashPanel) {
                while (this.suspendThread) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            System.out.println("SplashPanel timeStep() Process Interrupted.");
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.drawPanel(graphics);
    }

    private void drawPanel(Graphics graphics) {
        int n;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n2, n3);
        int n4 = (n2 - this.backgroundImageWidth) / 2;
        if (n4 < 0) {
            n4 = 0;
        }
        if ((n = (n3 - this.backgroundImageHeight) / 2) < 0) {
            n = 0;
        }
        graphics.drawImage(this.backgroundImage, n4, n, this);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.versionFont);
        graphics2D.drawString(this.versionString, 30, 290);
        float f = 0.9f;
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
        graphics2D.setComposite(alphaComposite);
        Color color = new Color(249, this.random.nextInt(256), 31);
        Color color2 = new Color(this.random.nextInt(256), 157, 71);
        GradientPaint gradientPaint = new GradientPaint(20.0f, 70.0f, color, 40.0f, 90.0f, color2, true);
        Ellipse2D.Double double_ = new Ellipse2D.Double(this.xCoordinate, this.yCoordinate, this.symbolWidth, this.symbolHeight);
        double_.setFrame(this.symbol_XPosition, this.symbol_YPosition, this.symbolWidth, this.symbolHeight);
        Area area = new Area(double_);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setPaint(gradientPaint);
        graphics2D.draw(double_);
        double d = 0.7853981633974483;
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d, this.symbol_XPosition + this.symbolWidth / 2.0, this.symbol_YPosition + this.symbolHeight);
        for (int i = 0; i < 7; ++i) {
            graphics2D.draw(area);
            graphics2D.transform(affineTransform);
            area.exclusiveOr(new Area(affineTransform.createTransformedShape(double_)));
            affineTransform.rotate(d, this.symbol_XPosition + this.symbolWidth / 2.0, this.symbol_YPosition + this.symbolHeight);
        }
        affineTransform.setToIdentity();
        graphics2D.setTransform(affineTransform);
    }

    public synchronized void setThreadAction(boolean bl) {
        this.suspendThread = bl;
        if (!this.suspendThread) {
            this.notifyAll();
        }
    }

    public void suspendPanel(boolean bl) {
        this.runThread = !bl;
    }
}

