/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.GraphicsCanvasPanel;
import com.dandymadeproductions.ajqvue.structures.DataImportProperties;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class SQLImportPreferencesPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -7558028181502132490L;
    private JCheckBox identityInsertCheckBox;
    private JButton restoreDefaultsButton;
    private JButton applyButton;
    public static final boolean DEFAULT_IDENTITY_INSERT = false;

    public SQLImportPreferencesPanel(AResourceBundle aResourceBundle) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), BorderFactory.createLoweredBevelBorder()));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 0, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        GraphicsCanvasPanel graphicsCanvasPanel = new GraphicsCanvasPanel("sqlImport.jpg");
        graphicsCanvasPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), BorderFactory.createLoweredBevelBorder()));
        jPanel2.add(graphicsCanvasPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()));
        String string = aResourceBundle.getResourceString("SQLImportPreferencesPanel.checkbox.IdentityInsert", "Identity Insert");
        this.identityInsertCheckBox = new JCheckBox(string, false);
        this.identityInsertCheckBox.setFocusPainted(false);
        this.identityInsertCheckBox.addActionListener(this);
        jPanel3.add(this.identityInsertCheckBox);
        jPanel2.add(jPanel3);
        jPanel.add((Component)jPanel2, "Center");
        this.add((Component)jPanel, "Center");
        JPanel jPanel4 = new JPanel();
        string = aResourceBundle.getResourceString("CSVImportPreferencesPanel.button.RestoreDefaults", "Restore Defaults");
        this.restoreDefaultsButton = new JButton(string);
        this.restoreDefaultsButton.addActionListener(this);
        jPanel4.add(this.restoreDefaultsButton);
        string = aResourceBundle.getResourceString("CSVImportPreferencesPanel.button.Apply", "Apply");
        this.applyButton = new JButton(string);
        this.applyButton.addActionListener(this);
        jPanel4.add(this.applyButton);
        this.add((Component)jPanel4, "South");
        this.setSQLImportProperties(DBTablesPanel.getDataImportProperties());
        this.applyButton.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (object == this.restoreDefaultsButton) {
                this.identityInsertCheckBox.setSelected(false);
                this.applyButton.setEnabled(true);
            } else if (object == this.applyButton) {
                DBTablesPanel.setDataImportProperties(this.getSQLImportOptions());
                this.applyButton.setEnabled(false);
            }
        }
        if (object instanceof JCheckBox) {
            this.applyButton.setEnabled(true);
        }
    }

    public DataImportProperties getSQLImportOptions() {
        DataImportProperties dataImportProperties = DBTablesPanel.getDataImportProperties();
        dataImportProperties.setIdentityInsert(this.identityInsertCheckBox.isSelected());
        return dataImportProperties;
    }

    public void setSQLImportProperties(DataImportProperties dataImportProperties) {
        this.identityInsertCheckBox.setSelected(dataImportProperties.getIdentityInsert());
    }
}

