/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.gui.panels.PreferencesPanel;
import com.dandymadeproductions.ajqvue.gui.sprites.FireFly;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Random;

public class PreferencesPanelSummer
extends PreferencesPanel {
    private static final long serialVersionUID = -9169861459455585662L;
    private transient Image backgroundImage;
    private int backgroundImageWidth;
    private int backgroundImageHeight;
    private transient Image offScreenGraphicsImage;
    private static final int fireFlyColors = 6;
    private transient Image[] fireFlyImages = new Image[6];
    private int fireFlyImageWidth;
    private int fireFlyImageHeight;
    private transient ArrayList<FireFly> fireFlies;
    private volatile boolean runThread;
    private volatile boolean suspendThread;
    private static final int frameDelay = 40;

    public PreferencesPanelSummer() {
        String[] stringArray = new String[]{"red_firefly.gif", "green_firefly.gif", "blue_firefly.gif", "yellow_firefly.gif", "purple_firefly.gif", "white_firefly.gif"};
        AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
        String string = Utils.getFileSeparator();
        this.backgroundImage = aResourceBundle.getResourceImage("images" + string + "PreferencesPanelSummer.jpg").getImage();
        this.backgroundImageWidth = this.backgroundImage.getWidth(null);
        this.backgroundImageHeight = this.backgroundImage.getHeight(null);
        for (int i = 0; i < 6; ++i) {
            this.fireFlyImages[i] = aResourceBundle.getResourceImage("images" + string + stringArray[i]).getImage();
        }
        this.fireFlyImageWidth = this.fireFlyImages[0].getWidth(null);
        this.fireFlyImageHeight = this.fireFlyImages[0].getHeight(null);
        this.fireFlies = new ArrayList();
        this.runThread = true;
        this.suspendThread = false;
    }

    @Override
    public void run() {
        int n = 15;
        Random random = new Random(System.currentTimeMillis());
        Rectangle rectangle = new Rectangle(0, 0, this.backgroundImageWidth, this.backgroundImageHeight);
        for (int i = 0; i < n; ++i) {
            Point point = this.getEmptyPosition();
            this.fireFlies.add(new FireFly(this, rectangle, this.fireFlyImages[i % this.fireFlyImages.length], point, new Point(random.nextInt() % 4, random.nextInt() % 4)));
        }
        while (this.runThread) {
            this.updateFireFlies();
            this.render();
            this.timeStep();
        }
    }

    private Point getEmptyPosition() {
        Rectangle rectangle = new Rectangle(0, 0, this.fireFlyImageWidth, this.fireFlyImageHeight);
        Random random = new Random(System.currentTimeMillis());
        boolean bl = false;
        int n = 0;
        while (!bl && n++ < 100) {
            rectangle.x = Math.abs(random.nextInt() % this.backgroundImageWidth);
            rectangle.y = Math.abs(random.nextInt() % this.backgroundImageHeight);
            boolean bl2 = false;
            for (int i = 0; i < this.fireFlies.size(); ++i) {
                Rectangle rectangle2 = this.fireFlies.get(i).getSpaceOccupied();
                if (!rectangle.intersects(rectangle2)) continue;
                bl2 = true;
            }
            bl = !bl2;
        }
        return new Point(rectangle.x, rectangle.y);
    }

    private void updateFireFlies() {
        for (int i = 0; i < this.fireFlies.size(); ++i) {
            FireFly fireFly = this.fireFlies.get(i);
            fireFly.updatePosition();
            int n = this.testForCollision(fireFly);
            if (n < 0) continue;
            Point point = fireFly.getNextPosition();
            fireFly.setNextPosition(this.fireFlies.get(n).getNextPosition());
            this.fireFlies.get(n).setNextPosition(point);
        }
    }

    private int testForCollision(FireFly fireFly) {
        for (int i = 0; i < this.fireFlies.size(); ++i) {
            FireFly fireFly2 = this.fireFlies.get(i);
            if (fireFly2 == fireFly || !fireFly.testCollision(fireFly2)) continue;
            return i;
        }
        return -1;
    }

    private void render() {
        Dimension dimension;
        if (this.getGraphics() != null && this.checkImage(dimension = this.getSize())) {
            this.drawPanel(this.offScreenGraphicsImage.getGraphics());
            this.getGraphics().drawImage(this.offScreenGraphicsImage, 0, 0, null);
        }
    }

    private boolean checkImage(Dimension dimension) {
        if (dimension.width <= 0 || dimension.height <= 0) {
            return false;
        }
        if (this.offScreenGraphicsImage == null || this.offScreenGraphicsImage.getWidth(null) != dimension.width || this.offScreenGraphicsImage.getHeight(null) != dimension.height) {
            this.offScreenGraphicsImage = this.createImage(dimension.width, dimension.height);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeStep() {
        try {
            Thread.sleep(40L);
            PreferencesPanelSummer preferencesPanelSummer = this;
            synchronized (preferencesPanelSummer) {
                while (this.suspendThread) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Process Interrupted.");
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.drawPanel(graphics);
    }

    private void drawPanel(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, n, n2);
        if (n != this.backgroundImageWidth || n2 != this.backgroundImageHeight) {
            AffineTransform affineTransform2 = AffineTransform.getScaleInstance((double)n / (double)this.backgroundImageWidth, (double)n2 / (double)this.backgroundImageHeight);
            graphics2D.setTransform(affineTransform2);
        }
        graphics2D.drawImage(this.backgroundImage, 0, 0, this);
        graphics2D.setFont(this.fontSerifPlain_12);
        graphics2D.drawString(this.dateString, 10, 20);
        for (int i = 0; i < this.fireFlies.size(); ++i) {
            graphics2D.drawImage(this.fireFlies.get(i).getImage(), this.fireFlies.get((int)i).getSpaceOccupied().x, this.fireFlies.get((int)i).getSpaceOccupied().y, this);
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.dispose();
    }

    @Override
    public synchronized void setThreadAction(boolean bl) {
        this.suspendThread = bl;
        if (!this.suspendThread) {
            this.notifyAll();
        }
    }

    @Override
    public void suspendPanel(boolean bl) {
        this.runThread = !bl;
    }
}

