/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.gui.panels.PreferencesPanel;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.Random;

public class PreferencesPanelSpring
extends PreferencesPanel {
    private static final long serialVersionUID = -1653725363649126705L;
    private transient Image backgroundImage;
    private int backgroundImageWidth;
    private int backgroundImageHeight;
    private transient Image offScreenGraphicsImage;
    private static final int owlImagesNumber = 4;
    private transient Image[] owlImages = new Image[4];
    private transient Image currentOwlImage;
    private volatile boolean runThread;
    private volatile boolean suspendThread;
    private static final int frameDelay = 3000;

    public PreferencesPanelSpring() {
        String[] stringArray = new String[]{"owl1.gif", "owl2.gif", "owl3.gif", "owl4.gif"};
        AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
        String string = Utils.getFileSeparator();
        this.backgroundImage = aResourceBundle.getResourceImage("images" + string + "PreferencesPanelSpring.jpg").getImage();
        this.backgroundImageWidth = this.backgroundImage.getWidth(null);
        this.backgroundImageHeight = this.backgroundImage.getHeight(null);
        for (int i = 0; i < 4; ++i) {
            this.owlImages[i] = aResourceBundle.getResourceImage("images" + string + stringArray[i]).getImage();
        }
        this.runThread = true;
        this.suspendThread = false;
    }

    @Override
    public void run() {
        while (this.runThread) {
            this.updateOwlImage();
            this.render();
            this.timeStep();
        }
    }

    private void updateOwlImage() {
        Random random = new Random(System.currentTimeMillis());
        this.currentOwlImage = this.owlImages[Math.abs(random.nextInt() % 4)];
    }

    private void render() {
        Dimension dimension;
        if (this.getGraphics() != null && this.checkImage(dimension = this.getSize())) {
            this.drawPanel(this.offScreenGraphicsImage.getGraphics());
            this.getGraphics().drawImage(this.offScreenGraphicsImage, 0, 0, null);
        }
    }

    private boolean checkImage(Dimension dimension) {
        if (dimension.width <= 0 || dimension.height <= 0) {
            return false;
        }
        if (this.offScreenGraphicsImage == null || this.offScreenGraphicsImage.getWidth(null) != dimension.width || this.offScreenGraphicsImage.getHeight(null) != dimension.height) {
            this.offScreenGraphicsImage = this.createImage(dimension.width, dimension.height);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeStep() {
        try {
            Thread.sleep(3000L);
            PreferencesPanelSpring preferencesPanelSpring = this;
            synchronized (preferencesPanelSpring) {
                while (this.suspendThread) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Process Interrupted.");
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.drawPanel(graphics);
    }

    private void drawPanel(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, n, n2);
        if (n != this.backgroundImageWidth || n2 != this.backgroundImageHeight) {
            AffineTransform affineTransform2 = AffineTransform.getScaleInstance((double)n / (double)this.backgroundImageWidth, (double)n2 / (double)this.backgroundImageHeight);
            graphics2D.setTransform(affineTransform2);
        }
        graphics2D.drawImage(this.backgroundImage, 0, 0, this);
        graphics2D.setFont(this.fontSerifPlain_12);
        graphics2D.drawString(this.dateString, 10, 20);
        graphics2D.drawImage(this.currentOwlImage, 154, 98, this);
        graphics2D.setTransform(affineTransform);
        graphics2D.dispose();
    }

    @Override
    public synchronized void setThreadAction(boolean bl) {
        this.suspendThread = bl;
        if (!this.suspendThread) {
            this.notifyAll();
        }
    }

    @Override
    public void suspendPanel(boolean bl) {
        this.runThread = !bl;
    }
}

