/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.structures.DataExportProperties;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PDFExportPreferencesPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1773630314816388122L;
    private GridBagLayout gridbag;
    private GridBagConstraints constraints;
    private JRadioButton titleNoneRadioButton;
    private JRadioButton titleDefaultRadioButton;
    private JRadioButton titleCustomRadioButton;
    private JTextField customTitleTextField;
    private JSpinner titleFontSizeSpinner;
    private JButton titleColorButton;
    private JSpinner headerFontSizeSpinner;
    private JSpinner headerBorderSizeSpinner;
    private JButton headerColorButton;
    private JButton headerBorderColorButton;
    private JComboBox<Object> numberAlignmentComboBox;
    private JComboBox<Object> dateAlignmentComboBox;
    private JComboBox<Object> dateFormatComboBox;
    private JComboBox<Object> fontComboBox;
    private JComboBox<Object> pageLayoutComboBox;
    private JButton restoreDefaultsButton;
    private JButton applyButton;
    private JColorChooser panelColorChooser;
    private String fileSeparator = Utils.getFileSeparator();
    private String iconsDirectory = Utils.getIconsDirectory() + this.fileSeparator;
    private String actionCommand;
    public static final String DEFAULT_FONT = "Undefined";
    public static final Color DEFAULT_COLOR = Color.BLACK;
    public static final String DEFAULT_TITLE = "";
    public static final int DEFAULT_TITLE_FONT_SIZE = 14;
    public static final int DEFAULT_HEADER_FONT_SIZE = 12;
    public static final int MINIMUM_FONT_SIZE = 8;
    public static final int MAX_FONT_SIZE = 32;
    public static final int DEFAULT_BORDER_SIZE = 1;
    public static final int MINIMUM_BORDER_SIZE = 1;
    public static final int MAX_BORDER_SIZE = 6;
    public static final int SPINNER_SIZE_STEP = 1;
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int LAYOUT_PORTRAIT = 0;
    public static final int LAYOUT_LANDSCAPE = 1;

    public PDFExportPreferencesPanel(AResourceBundle aResourceBundle) {
        this.setLayout(new BorderLayout());
        this.gridbag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0), BorderFactory.createLoweredBevelBorder()));
        JPanel jPanel2 = new JPanel(this.gridbag);
        this.panelColorChooser = Utils.createColorChooser(this);
        this.actionCommand = DEFAULT_TITLE;
        JPanel jPanel3 = new JPanel(this.gridbag);
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createEtchedBorder()));
        this.fillTitlePanel(jPanel3, aResourceBundle);
        jPanel.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel(this.gridbag);
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createEtchedBorder()));
        this.fillHeaderPanel(jPanel4, aResourceBundle);
        this.buildConstraints(this.constraints, 0, 0, 1, 1, 100.0, 38.0);
        this.constraints.fill = 1;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jPanel4, this.constraints);
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel(this.gridbag);
        jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createEtchedBorder()));
        this.fillNumberPanel(jPanel5, aResourceBundle);
        this.buildConstraints(this.constraints, 0, 1, 1, 1, 100.0, 24.0);
        this.constraints.fill = 1;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jPanel5, this.constraints);
        jPanel2.add(jPanel5);
        JPanel jPanel6 = new JPanel(this.gridbag);
        jPanel6.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createEtchedBorder()));
        this.fillDatePanel(jPanel6, aResourceBundle);
        this.buildConstraints(this.constraints, 0, 2, 1, 1, 100.0, 38.0);
        this.constraints.fill = 1;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jPanel6, this.constraints);
        jPanel2.add(jPanel6);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel7 = new JPanel(this.gridbag);
        jPanel7.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createEtchedBorder()));
        this.fillFontPageLayoutPanel(jPanel7, aResourceBundle);
        jPanel.add((Component)jPanel7, "South");
        this.add((Component)jPanel, "Center");
        JPanel jPanel8 = new JPanel();
        String string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.button.RestoreDefaults", "Restore Defaults");
        this.restoreDefaultsButton = new JButton(string);
        this.restoreDefaultsButton.addActionListener(this);
        jPanel8.add(this.restoreDefaultsButton);
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.button.Apply", "Apply");
        this.applyButton = new JButton(string);
        this.applyButton.addActionListener(this);
        jPanel8.add(this.applyButton);
        this.add((Component)jPanel8, "South");
        this.setPDFExportProperties(DBTablesPanel.getDataExportProperties());
        this.applyButton.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (object == this.titleColorButton || object == this.headerColorButton || object == this.headerBorderColorButton) {
                JButton jButton = (JButton)object;
                this.actionCommand = jButton.getActionCommand();
                if (jButton == this.titleColorButton) {
                    this.panelColorChooser.setBorder(BorderFactory.createTitledBorder("Title Color"));
                    this.panelColorChooser.setColor(this.titleColorButton.getBackground());
                } else if (jButton == this.headerColorButton) {
                    this.panelColorChooser.setBorder(BorderFactory.createTitledBorder("Header Color"));
                    this.panelColorChooser.setColor(this.headerColorButton.getBackground());
                } else {
                    this.panelColorChooser.setBorder(BorderFactory.createTitledBorder("Header Border Color"));
                    this.panelColorChooser.setColor(this.headerBorderColorButton.getBackground());
                }
                JDialog jDialog = JColorChooser.createDialog(this, "Color Selector", true, this.panelColorChooser, this, null);
                jDialog.setVisible(true);
                jDialog.dispose();
                return;
            }
            if (((JButton)object).getText().equals("OK")) {
                this.applyButton.setEnabled(true);
                if (this.actionCommand.equals("Title Color")) {
                    this.titleColorButton.setBackground(this.panelColorChooser.getColor());
                } else if (this.actionCommand.equals("Header Color")) {
                    this.headerColorButton.setBackground(this.panelColorChooser.getColor());
                } else {
                    this.headerBorderColorButton.setBackground(this.panelColorChooser.getColor());
                }
                this.actionCommand = DEFAULT_TITLE;
            }
            if (object == this.restoreDefaultsButton) {
                this.titleNoneRadioButton.setSelected(true);
                this.customTitleTextField.setText(DEFAULT_TITLE);
                this.customTitleTextField.setEnabled(false);
                this.titleFontSizeSpinner.setValue(14);
                this.titleColorButton.setBackground(Color.BLACK);
                this.headerFontSizeSpinner.setValue(12);
                this.headerColorButton.setBackground(Color.BLACK);
                this.headerBorderSizeSpinner.setValue(1);
                this.headerBorderColorButton.setBackground(Color.BLACK);
                this.numberAlignmentComboBox.setSelectedIndex(2);
                this.dateFormatComboBox.setSelectedItem(DBTablesPanel.getGeneralDBProperties().getViewDateFormat());
                this.dateAlignmentComboBox.setSelectedIndex(1);
                this.fontComboBox.setSelectedItem(DEFAULT_FONT);
                this.pageLayoutComboBox.setSelectedIndex(0);
            } else if (object == this.applyButton) {
                DBTablesPanel.setDataExportProperties(this.getPDFExportOptions());
                this.applyButton.setEnabled(false);
            }
        }
        if (object instanceof JRadioButton || object instanceof JComboBox) {
            this.applyButton.setEnabled(true);
            if (object instanceof JRadioButton) {
                if (this.titleCustomRadioButton.isSelected()) {
                    this.customTitleTextField.setEnabled(true);
                } else {
                    this.customTitleTextField.setEnabled(false);
                }
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JSpinner && this.applyButton != null) {
            this.applyButton.setEnabled(true);
        }
    }

    private void fillTitlePanel(JPanel jPanel, AResourceBundle aResourceBundle) {
        String string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.label.Title", "Title");
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.buildConstraints(this.constraints, 0, 0, 4, 1, 100.0, 33.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jLabel, this.constraints);
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel(this.gridbag);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0), BorderFactory.createLoweredBevelBorder()));
        ButtonGroup buttonGroup = new ButtonGroup();
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.radiobutton.None", "None");
        this.titleNoneRadioButton = new JRadioButton(string, true);
        this.titleNoneRadioButton.setFocusPainted(false);
        this.titleNoneRadioButton.addActionListener(this);
        buttonGroup.add(this.titleNoneRadioButton);
        this.buildConstraints(this.constraints, 0, 0, 1, 1, 12.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(this.titleNoneRadioButton, this.constraints);
        jPanel2.add(this.titleNoneRadioButton);
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.radiobutton.Default", "Default");
        this.titleDefaultRadioButton = new JRadioButton(string, false);
        this.titleDefaultRadioButton.setFocusPainted(false);
        this.titleDefaultRadioButton.addActionListener(this);
        buttonGroup.add(this.titleDefaultRadioButton);
        this.buildConstraints(this.constraints, 1, 0, 1, 1, 12.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(this.titleDefaultRadioButton, this.constraints);
        jPanel2.add(this.titleDefaultRadioButton);
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.radiobutton.Custom", "Custom");
        this.titleCustomRadioButton = new JRadioButton(string, true);
        this.titleCustomRadioButton.setFocusPainted(false);
        this.titleCustomRadioButton.addActionListener(this);
        buttonGroup.add(this.titleCustomRadioButton);
        this.buildConstraints(this.constraints, 2, 0, 1, 1, 12.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(this.titleCustomRadioButton, this.constraints);
        jPanel2.add(this.titleCustomRadioButton);
        this.customTitleTextField = new JTextField(10);
        this.customTitleTextField.addMouseListener(Ajqvue.getPopupMenuListener());
        this.customTitleTextField.setEnabled(false);
        this.buildConstraints(this.constraints, 3, 0, 1, 1, 64.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(this.customTitleTextField, this.constraints);
        jPanel2.add(this.customTitleTextField);
        this.buildConstraints(this.constraints, 0, 1, 4, 1, 100.0, 33.0);
        this.constraints.fill = 2;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jPanel2, this.constraints);
        jPanel.add(jPanel2);
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.label.TitleFontSize", "Font Size");
        JLabel jLabel2 = new JLabel(string);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(3, 0, 8, 0));
        this.buildConstraints(this.constraints, 0, 2, 1, 1, 12.0, 33.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.gridbag.setConstraints(jLabel2, this.constraints);
        jPanel.add(jLabel2);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(14, 8, 32, 1);
        this.titleFontSizeSpinner = new JSpinner(spinnerNumberModel);
        this.titleFontSizeSpinner.addChangeListener(this);
        this.buildConstraints(this.constraints, 1, 2, 1, 1, 38.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(this.titleFontSizeSpinner, this.constraints);
        jPanel.add(this.titleFontSizeSpinner);
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.label.TitleFontColor", "Font Color");
        JLabel jLabel3 = new JLabel(string);
        jLabel3.setBorder(BorderFactory.createEmptyBorder(3, 0, 8, 0));
        this.buildConstraints(this.constraints, 2, 2, 1, 1, 12.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.gridbag.setConstraints(jLabel3, this.constraints);
        jPanel.add(jLabel3);
        this.titleColorButton = new JButton(aResourceBundle.getResourceImage(this.iconsDirectory + "transparentUpIcon.png"));
        this.titleColorButton.setActionCommand("Title Color");
        this.titleColorButton.setBackground(DEFAULT_COLOR);
        this.titleColorButton.setFocusable(false);
        this.titleColorButton.setMargin(new Insets(0, 0, 0, 0));
        this.titleColorButton.addActionListener(this);
        this.buildConstraints(this.constraints, 3, 2, 1, 1, 38.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(this.titleColorButton, this.constraints);
        jPanel.add(this.titleColorButton);
    }

    private void fillHeaderPanel(JPanel jPanel, AResourceBundle aResourceBundle) {
        String string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.label.HeaderColumns", "Header Columns");
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.buildConstraints(this.constraints, 0, 0, 6, 1, 100.0, 50.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jLabel, this.constraints);
        jPanel.add(jLabel);
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.label.HeaderFont", "Font");
        JLabel jLabel2 = new JLabel(string);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        this.buildConstraints(this.constraints, 0, 1, 1, 1, 18.0, 50.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.gridbag.setConstraints(jLabel2, this.constraints);
        jPanel.add(jLabel2);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(12, 8, 32, 1);
        this.headerFontSizeSpinner = new JSpinner(spinnerNumberModel);
        this.headerFontSizeSpinner.addChangeListener(this);
        this.buildConstraints(this.constraints, 1, 1, 1, 1, 16.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(this.headerFontSizeSpinner, this.constraints);
        jPanel.add(this.headerFontSizeSpinner);
        this.headerColorButton = new JButton(aResourceBundle.getResourceImage(this.iconsDirectory + "transparentUpIcon.png"));
        this.headerColorButton.setActionCommand("Header Color");
        this.headerColorButton.setBackground(Color.BLACK);
        this.headerColorButton.setFocusable(false);
        this.headerColorButton.setMargin(new Insets(0, 0, 0, 0));
        this.headerColorButton.addActionListener(this);
        this.buildConstraints(this.constraints, 2, 1, 1, 1, 16.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(this.headerColorButton, this.constraints);
        jPanel.add(this.headerColorButton);
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.label.HeaderBorder", "Border");
        JLabel jLabel3 = new JLabel(string);
        jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        this.buildConstraints(this.constraints, 3, 1, 1, 1, 18.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.gridbag.setConstraints(jLabel3, this.constraints);
        jPanel.add(jLabel3);
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(1, 1, 6, 1);
        this.headerBorderSizeSpinner = new JSpinner(spinnerNumberModel2);
        this.headerBorderSizeSpinner.addChangeListener(this);
        this.buildConstraints(this.constraints, 4, 1, 1, 1, 16.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(this.headerBorderSizeSpinner, this.constraints);
        jPanel.add(this.headerBorderSizeSpinner);
        this.headerBorderColorButton = new JButton(aResourceBundle.getResourceImage(this.iconsDirectory + "transparentUpIcon.png"));
        this.headerBorderColorButton.setActionCommand("Border Color");
        this.headerBorderColorButton.setBackground(DEFAULT_COLOR);
        this.headerBorderColorButton.setFocusable(false);
        this.headerBorderColorButton.setMargin(new Insets(0, 0, 0, 0));
        this.headerBorderColorButton.addActionListener(this);
        this.buildConstraints(this.constraints, 5, 1, 1, 1, 16.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(this.headerBorderColorButton, this.constraints);
        jPanel.add(this.headerBorderColorButton);
    }

    private void fillNumberPanel(JPanel jPanel, AResourceBundle aResourceBundle) {
        String string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.label.NumberFieldsAlignment", "Number Fields Alignment");
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(BorderFactory.createEmptyBorder(3, 10, 10, 10));
        this.buildConstraints(this.constraints, 0, 1, 1, 1, 50.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.gridbag.setConstraints(jLabel, this.constraints);
        jPanel.add(jLabel);
        this.numberAlignmentComboBox = new JComboBox();
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.combobox.Left", "LEFT");
        this.numberAlignmentComboBox.addItem(string);
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.combobox.Center", "Center");
        this.numberAlignmentComboBox.addItem(string);
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.combobox.Right", "Right");
        this.numberAlignmentComboBox.addItem(string);
        this.numberAlignmentComboBox.setSelectedIndex(2);
        this.numberAlignmentComboBox.addActionListener(this);
        this.buildConstraints(this.constraints, 1, 1, 1, 1, 50.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.gridbag.setConstraints(this.numberAlignmentComboBox, this.constraints);
        jPanel.add(this.numberAlignmentComboBox);
    }

    private void fillDatePanel(JPanel jPanel, AResourceBundle aResourceBundle) {
        String string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.label.DateFields", "Date Fields");
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.buildConstraints(this.constraints, 0, 0, 4, 1, 100.0, 50.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jLabel, this.constraints);
        jPanel.add(jLabel);
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.label.DateFormat", "Format");
        JLabel jLabel2 = new JLabel(string);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.buildConstraints(this.constraints, 0, 1, 1, 1, 12.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jLabel2, this.constraints);
        jPanel.add(jLabel2);
        this.dateFormatComboBox = new JComboBox<Object>(Utils.getDateFormatOption());
        this.dateFormatComboBox.addActionListener(this);
        this.buildConstraints(this.constraints, 1, 1, 1, 1, 38.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(this.dateFormatComboBox, this.constraints);
        jPanel.add(this.dateFormatComboBox);
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.label.DateAlignment", "Alignment");
        JLabel jLabel3 = new JLabel(string);
        jLabel3.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.buildConstraints(this.constraints, 2, 1, 1, 1, 12.0, 50.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jLabel3, this.constraints);
        jPanel.add(jLabel3);
        this.dateAlignmentComboBox = new JComboBox();
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.combobox.Left", "Left");
        this.dateAlignmentComboBox.addItem(string);
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.combobox.Center", "Center");
        this.dateAlignmentComboBox.addItem(string);
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.combobox.Right", "Right");
        this.dateAlignmentComboBox.addItem(string);
        this.dateAlignmentComboBox.setSelectedIndex(1);
        this.dateAlignmentComboBox.addActionListener(this);
        this.buildConstraints(this.constraints, 3, 1, 1, 1, 38.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(this.dateAlignmentComboBox, this.constraints);
        jPanel.add(this.dateAlignmentComboBox);
    }

    private void fillFontPageLayoutPanel(JPanel jPanel, AResourceBundle aResourceBundle) {
        String string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.label.Font", "Font");
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.buildConstraints(this.constraints, 0, 0, 1, 1, 12.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jLabel, this.constraints);
        jPanel.add(jLabel);
        this.fontComboBox = new JComboBox<Object>(DBTablesPanel.getDataExportProperties().getFonts());
        this.fontComboBox.addActionListener(this);
        this.buildConstraints(this.constraints, 1, 0, 1, 1, 38.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(this.fontComboBox, this.constraints);
        jPanel.add(this.fontComboBox);
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.label.PageLayout", "Page Layout");
        JLabel jLabel2 = new JLabel(string);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.buildConstraints(this.constraints, 2, 0, 1, 1, 12.0, 50.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jLabel2, this.constraints);
        jPanel.add(jLabel2);
        this.pageLayoutComboBox = new JComboBox();
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.combobox.Portrait", "Portrait");
        this.pageLayoutComboBox.addItem(string);
        string = aResourceBundle.getResourceString("PDFExportPreferencesPanel.combobox.Landscape", "Landscape");
        this.pageLayoutComboBox.addItem(string);
        this.pageLayoutComboBox.setSelectedIndex(0);
        this.pageLayoutComboBox.addActionListener(this);
        this.buildConstraints(this.constraints, 3, 0, 1, 1, 38.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(this.pageLayoutComboBox, this.constraints);
        jPanel.add(this.pageLayoutComboBox);
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    public DataExportProperties getPDFExportOptions() {
        DataExportProperties dataExportProperties = DBTablesPanel.getDataExportProperties();
        if (this.titleNoneRadioButton.isSelected()) {
            dataExportProperties.setTitle(DEFAULT_TITLE);
        } else if (this.titleDefaultRadioButton.isSelected()) {
            dataExportProperties.setTitle("EXPORTED TABLE");
        } else {
            dataExportProperties.setTitle(this.customTitleTextField.getText());
        }
        dataExportProperties.setTitleFontSize(Integer.parseInt(this.titleFontSizeSpinner.getValue().toString()));
        dataExportProperties.setTitleColor(this.titleColorButton.getBackground());
        dataExportProperties.setHeaderFontSize(Integer.parseInt(this.headerFontSizeSpinner.getValue().toString()));
        dataExportProperties.setHeaderColor(this.headerColorButton.getBackground());
        dataExportProperties.setHeaderBorderSize(Integer.parseInt(this.headerBorderSizeSpinner.getValue().toString()));
        dataExportProperties.setHeaderBorderColor(this.headerBorderColorButton.getBackground());
        dataExportProperties.setNumberAlignment(this.numberAlignmentComboBox.getSelectedIndex());
        dataExportProperties.setPDFDateFormat((String)this.dateFormatComboBox.getSelectedItem());
        dataExportProperties.setDateAlignment(this.dateAlignmentComboBox.getSelectedIndex());
        dataExportProperties.setPageLayout(this.pageLayoutComboBox.getSelectedIndex());
        dataExportProperties.setFontName((String)this.fontComboBox.getSelectedItem());
        return dataExportProperties;
    }

    public void setPDFExportProperties(DataExportProperties dataExportProperties) {
        if (dataExportProperties.getTitle().equals(DEFAULT_TITLE)) {
            this.titleNoneRadioButton.setSelected(true);
        } else if (dataExportProperties.getTitle().equals("EXPORTED TABLE")) {
            this.titleDefaultRadioButton.setSelected(true);
        } else {
            this.titleCustomRadioButton.setSelected(true);
            this.customTitleTextField.setText(dataExportProperties.getTitle());
            this.customTitleTextField.setEnabled(true);
        }
        this.titleFontSizeSpinner.setValue(dataExportProperties.getTitleFontSize());
        this.titleColorButton.setBackground(dataExportProperties.getTitleColor());
        this.headerFontSizeSpinner.setValue(dataExportProperties.getHeaderFontSize());
        this.headerColorButton.setBackground(dataExportProperties.getHeaderColor());
        this.headerBorderSizeSpinner.setValue(dataExportProperties.getHeaderBorderSize());
        this.headerBorderColorButton.setBackground(dataExportProperties.getHeaderBorderColor());
        this.numberAlignmentComboBox.setSelectedIndex(dataExportProperties.getNumberAlignment());
        this.dateFormatComboBox.setSelectedItem(dataExportProperties.getPDFDateFormat());
        this.dateAlignmentComboBox.setSelectedIndex(dataExportProperties.getDateAlignment());
        this.pageLayoutComboBox.setSelectedIndex(dataExportProperties.getPageLayout());
        this.fontComboBox.setSelectedItem(dataExportProperties.getFontName());
    }
}

