/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class GraphicsCanvasPanel
extends JPanel {
    private static final long serialVersionUID = 7618323328966733483L;
    private transient Image backgroundImage;
    private int backgroundImageWidth;
    private int backgroundImageHeight;
    private transient Image offScreenGraphicsImage;

    public GraphicsCanvasPanel(String string) {
        this(Ajqvue.getResourceBundle().getResourceImage("images" + Utils.getFileSeparator() + string).getImage());
    }

    public GraphicsCanvasPanel(Image image) {
        this.backgroundImage = image;
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createLoweredBevelBorder()));
        this.backgroundImageWidth = image.getWidth(null);
        this.backgroundImageHeight = image.getHeight(null);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        if (this.checkImage(dimension)) {
            this.drawPanel(graphics);
        }
    }

    private boolean checkImage(Dimension dimension) {
        if (dimension.width <= 0 || dimension.height <= 0) {
            return false;
        }
        if (this.offScreenGraphicsImage == null || this.offScreenGraphicsImage.getWidth(null) != dimension.width || this.offScreenGraphicsImage.getHeight(null) != dimension.height) {
            this.offScreenGraphicsImage = this.createImage(dimension.width, dimension.height);
        }
        return true;
    }

    private void drawPanel(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, n, n2);
        if (n != this.backgroundImageWidth || n2 != this.backgroundImageHeight) {
            AffineTransform affineTransform = AffineTransform.getScaleInstance((double)n / (double)this.backgroundImageWidth, (double)n2 / (double)this.backgroundImageHeight);
            Graphics2D graphics2D2 = (Graphics2D)this.offScreenGraphicsImage.getGraphics();
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D2.setTransform(affineTransform);
            graphics2D2.drawImage(this.backgroundImage, 0, 0, null);
            graphics2D2.dispose();
        }
        graphics2D.drawImage(this.offScreenGraphicsImage, 0, 0, this);
        graphics2D.dispose();
    }
}

