/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.GeneralOptionsPreferencesFiller;
import com.dandymadeproductions.ajqvue.structures.GeneralDBProperties;
import com.dandymadeproductions.ajqvue.structures.GeneralProperties;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GeneralPreferencesPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = -38018440091231375L;
    public GeneralOptionsPreferencesFiller generalOptionsPanelFiller;
    private JComboBox<Object> dateFormatComboBox;
    private JSpinner limitIncrementSpinner;
    private JSpinner batchSizeSpinner;
    private JCheckBox batchEnabledCheckBox;
    private JCheckBox sequencerEnablerCheckBox;
    private JButton sequencerResetButton;
    private JButton restoreDefaultsButton;
    private JButton applyButton;
    private boolean generateSequence;
    public static final int DEFAULT_LIMIT_INCREMENT = 50000;
    public static final boolean DEFAULT_BATCH_SIZE_ENABLED = false;
    public static final int DEFAULT_BATCH_SIZE = 50000;
    public static final int DEFAULT_SEQUENCE_SIZE = 15;
    public static final int DEFAULT_SEQUENCE_MAX = 41;

    public GeneralPreferencesPanel(AResourceBundle aResourceBundle) {
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String string = Utils.getIconsDirectory() + Utils.getFileSeparator();
        this.generateSequence = false;
        JPanel jPanel = new JPanel(new GridLayout(4, 1, 2, 2));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0), BorderFactory.createLoweredBevelBorder()));
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createEtchedBorder()));
        String string2 = aResourceBundle.getResourceString("GeneralPreferencesPanel.label.DateFormat", "Date Format");
        JLabel jLabel = new JLabel(string2);
        jLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        this.dateFormatComboBox = new JComboBox<Object>(Utils.getDateFormatOption());
        this.dateFormatComboBox.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.dateFormatComboBox, gridBagConstraints);
        jPanel2.add(this.dateFormatComboBox);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(gridBagLayout);
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createEtchedBorder()));
        string2 = aResourceBundle.getResourceString("GeneralPreferencesPanel.label.TableReadLimitIcrement", "Table Read Limit Increment");
        JLabel jLabel2 = new JLabel(" " + string2);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel3.add(jLabel2);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(50000, 2, 500000, 10000);
        this.limitIncrementSpinner = new JSpinner(spinnerNumberModel);
        this.limitIncrementSpinner.addChangeListener(this);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.limitIncrementSpinner, gridBagConstraints);
        jPanel3.add(this.limitIncrementSpinner);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createEtchedBorder()));
        string2 = aResourceBundle.getResourceString("GeneralPreferencesPanel.label.EnableTableWriteBatch", "Enable Table Write Batch");
        this.batchEnabledCheckBox = new JCheckBox(string2, false);
        this.batchEnabledCheckBox.setFocusPainted(false);
        this.batchEnabledCheckBox.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 34.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.batchEnabledCheckBox, gridBagConstraints);
        jPanel4.add(this.batchEnabledCheckBox);
        string2 = aResourceBundle.getResourceString("GeneralPreferencesPanel.label.BatchSize", "Batch Size");
        JLabel jLabel3 = new JLabel(" " + string2);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel4.add(jLabel3);
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(50000, 2, 500000, 10000);
        this.batchSizeSpinner = new JSpinner(spinnerNumberModel2);
        this.batchSizeSpinner.addChangeListener(this);
        this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 33.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.batchSizeSpinner, gridBagConstraints);
        jPanel4.add(this.batchSizeSpinner);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel(gridBagLayout);
        jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createEtchedBorder()));
        string2 = aResourceBundle.getResourceString("GeneralPreferencesPanel.label.ResetPasswordSequencer", "Reset Password Sequencer");
        this.sequencerEnablerCheckBox = new JCheckBox(string2, false);
        this.sequencerEnablerCheckBox.setFocusPainted(false);
        this.sequencerEnablerCheckBox.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 60.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.sequencerEnablerCheckBox, gridBagConstraints);
        jPanel5.add(this.sequencerEnablerCheckBox);
        string2 = aResourceBundle.getResourceString("GeneralPreferencesPanel.label.Reset", "Reset");
        ImageIcon imageIcon = aResourceBundle.getResourceImage(string + "resetIcon_16x16.png");
        this.sequencerResetButton = new JButton(string2, imageIcon);
        this.sequencerResetButton.setEnabled(false);
        this.sequencerResetButton.setFocusable(false);
        this.sequencerResetButton.setMargin(new Insets(0, 0, 0, 0));
        this.sequencerResetButton.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 40.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.sequencerResetButton, gridBagConstraints);
        jPanel5.add(this.sequencerResetButton);
        jPanel.add(jPanel5);
        this.add((Component)jPanel, "North");
        JPanel jPanel6 = new JPanel(new GridLayout(1, 1, 0, 0));
        jPanel6.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), BorderFactory.createLoweredBevelBorder()));
        this.generalOptionsPanelFiller = new GeneralOptionsPreferencesFiller();
        this.generalOptionsPanelFiller.setThreadAction(true);
        jPanel6.add(this.generalOptionsPanelFiller);
        this.add((Component)jPanel6, "Center");
        JPanel jPanel7 = new JPanel();
        string2 = aResourceBundle.getResourceString("GeneralPreferencesPanel.button.RestoreDefaults", "Restore Defaults");
        this.restoreDefaultsButton = new JButton(string2);
        this.restoreDefaultsButton.addActionListener(this);
        jPanel7.add(this.restoreDefaultsButton);
        string2 = aResourceBundle.getResourceString("GeneralPreferencesPanel.button.Apply", "Apply");
        this.applyButton = new JButton(string2);
        this.applyButton.addActionListener(this);
        jPanel7.add(this.applyButton);
        this.add((Component)jPanel7, "South");
        this.setGeneralDBProperties(DBTablesPanel.getGeneralDBProperties());
        this.applyButton.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (object == this.sequencerResetButton) {
                this.generateSequence = true;
                this.applyButton.setEnabled(true);
            } else if (object == this.restoreDefaultsButton) {
                this.dateFormatComboBox.setSelectedIndex(0);
                this.limitIncrementSpinner.setValue(50000);
                this.batchEnabledCheckBox.setSelected(false);
                this.batchSizeSpinner.setValue(50000);
                this.sequencerEnablerCheckBox.setSelected(false);
                this.generateSequence = false;
                this.applyButton.setEnabled(true);
            } else if (object == this.applyButton) {
                DBTablesPanel.setGeneralDBProperties(this.getGeneralDBOptions());
                if (this.generateSequence) {
                    Ajqvue.setGeneralProperties(this.getGeneralOptions());
                }
                this.applyButton.setEnabled(false);
            }
        }
        if (object instanceof JRadioButton || object instanceof JComboBox || object instanceof JCheckBox) {
            if (object == this.sequencerEnablerCheckBox) {
                this.sequencerResetButton.setEnabled(this.sequencerEnablerCheckBox.isSelected());
                if (this.generateSequence) {
                    this.generateSequence = this.sequencerEnablerCheckBox.isSelected();
                }
            } else {
                this.applyButton.setEnabled(true);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JSpinner && this.applyButton != null) {
            this.applyButton.setEnabled(true);
        }
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    public GeneralProperties getGeneralOptions() {
        GeneralProperties generalProperties = Ajqvue.getGeneralProperties();
        if (this.generateSequence) {
            generalProperties.setSequenceList(Utils.getChartList(15, 41));
        }
        return generalProperties;
    }

    public GeneralDBProperties getGeneralDBOptions() {
        GeneralDBProperties generalDBProperties = DBTablesPanel.getGeneralDBProperties();
        generalDBProperties.setViewDateFormat((String)this.dateFormatComboBox.getSelectedItem());
        generalDBProperties.setLimitIncrement(Integer.parseInt(this.limitIncrementSpinner.getValue().toString()));
        generalDBProperties.setBatchSizeEnabled(this.batchEnabledCheckBox.isSelected());
        generalDBProperties.setBatchSize(Integer.parseInt(this.batchSizeSpinner.getValue().toString()));
        return generalDBProperties;
    }

    public void setGeneralDBProperties(GeneralDBProperties generalDBProperties) {
        this.dateFormatComboBox.setSelectedItem(generalDBProperties.getViewDateFormat());
        this.limitIncrementSpinner.setValue(generalDBProperties.getLimitIncrement());
        this.batchEnabledCheckBox.setSelected(generalDBProperties.getBatchSizeEnabled());
        this.batchSizeSpinner.setValue(generalDBProperties.getBatchSize());
    }
}

