/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.gui.sprites.Blossom;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;

public class GeneralOptionsPreferencesFiller
extends Canvas
implements Runnable {
    private static final long serialVersionUID = -5699524708347678314L;
    private transient Image offScreenGraphicsImage;
    private transient Blossom blossom = new Blossom();
    private boolean restartBlossoms;
    private double positionIncrementX;
    private double positionIncrementY;
    private boolean runThread;
    private boolean suspendThread;
    private static final double DEFAULT_POSITION_INCREMENT_X = 5.0;
    private static final double DEFAULT_POSITION_INCREMENT_Y = Math.pow(5.0, 0.8);
    private static final int FRAMEDELAY = 100;

    public GeneralOptionsPreferencesFiller() {
        this.blossom.isPetalFilled(true);
        this.blossom.setPosition(new Point2D.Double(0.0, 0.0));
        Dimension dimension = new Dimension();
        ((Dimension2D)dimension).setSize(10.0, 30.0);
        this.blossom.setPetalSize(dimension);
        this.restartBlossoms = true;
        this.positionIncrementX = 5.0;
        this.positionIncrementY = DEFAULT_POSITION_INCREMENT_Y;
        this.setBackground(Color.BLACK);
        this.runThread = true;
        this.suspendThread = false;
    }

    @Override
    public void run() {
        while (this.runThread) {
            this.updateAnimatedObjects();
            this.render();
            this.timeStep();
        }
    }

    private void updateAnimatedObjects() {
        double d = this.blossom.getPosition().getX();
        double d2 = this.blossom.getPosition().getY();
        double d3 = this.blossom.getPetalSize().getWidth() + this.blossom.getPetalSize().getHeight();
        double d4 = 2.0 * this.blossom.getPetalSize().getHeight();
        if (d + d3 > (double)this.getWidth()) {
            this.positionIncrementX = -5.0;
        }
        if (d - this.blossom.getPetalSize().getHeight() < 0.0) {
            this.positionIncrementX = 5.0;
        }
        if (d2 + d4 > (double)this.getHeight()) {
            this.positionIncrementY = -DEFAULT_POSITION_INCREMENT_Y;
        }
        if (d2 < 0.0) {
            this.positionIncrementY = DEFAULT_POSITION_INCREMENT_Y;
        }
        this.blossom.setPosition(new Point2D.Double(this.blossom.getPosition().getX() + this.positionIncrementX, this.blossom.getPosition().getY() + this.positionIncrementY));
    }

    private void render() {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D != null) {
            Dimension dimension = this.getSize();
            if (this.checkImage(dimension)) {
                Graphics2D graphics2D2 = (Graphics2D)this.offScreenGraphicsImage.getGraphics();
                this.paint(graphics2D2);
                graphics2D.drawImage(this.offScreenGraphicsImage, 0, 0, null);
                graphics2D2.dispose();
            }
            graphics2D.dispose();
        }
    }

    private boolean checkImage(Dimension dimension) {
        if (dimension.width <= 0 || dimension.height <= 0) {
            return false;
        }
        if (this.offScreenGraphicsImage == null || this.offScreenGraphicsImage.getWidth(null) != dimension.width || this.offScreenGraphicsImage.getHeight(null) != dimension.height) {
            this.offScreenGraphicsImage = this.createImage(dimension.width, dimension.height);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeStep() {
        try {
            Thread.sleep(100L);
            GeneralOptionsPreferencesFiller generalOptionsPreferencesFiller = this;
            synchronized (generalOptionsPreferencesFiller) {
                while (this.suspendThread) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Process Interrupted.");
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.restartBlossoms) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, n, n2);
            this.restartBlossoms = false;
        }
        this.blossom.draw(graphics2D);
    }

    public synchronized void setThreadAction(boolean bl) {
        this.suspendThread = bl;
        if (!this.suspendThread) {
            this.notifyAll();
        }
    }

    public void suspendPanel(boolean bl) {
        this.runThread = !bl;
    }
}

