/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.gui.Main_Frame;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel_Derby;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel_Generic;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel_HSQL;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel_MSAccess;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel_MSSQL;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel_MySQL;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel_Oracle;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel_PostgreSQL;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel_SQLite;
import com.dandymadeproductions.ajqvue.structures.DataExportProperties;
import com.dandymadeproductions.ajqvue.structures.DataImportProperties;
import com.dandymadeproductions.ajqvue.structures.GeneralDBProperties;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DBTablesPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -2513425626736158682L;
    private static final int tableTabPanelCardLimit = 10;
    private static LinkedList<String> tableCards = new LinkedList();
    private static CardLayout tablesCardLayout = new CardLayout();
    private static JPanel tablesPanel = new JPanel(tablesCardLayout);
    private static JLabel statusIndicator = new JLabel("", 2);
    private static JLabel statusLabel = new JLabel("Idle");
    private JButton sqlQueryBucketButton;
    private static JComboBox<Object> tableSelectionComboBox = new JComboBox();
    private static HashMap<String, TableTabPanel> tableTabHashMap = new HashMap();
    private static boolean disableActions = true;
    private static long statusTimer;
    private static volatile boolean stopStatusDelayThread;
    private static GeneralDBProperties generalDBProperties;
    private static DataImportProperties dataImportProperties;
    private static DataExportProperties dataExportProperties;

    public DBTablesPanel(Connection connection, ArrayList<String> arrayList) {
        AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
        String string = Utils.getIconsDirectory() + Utils.getFileSeparator();
        ImageIcon imageIcon = aResourceBundle.getResourceImage(string + "statusIdleIcon.png");
        ImageIcon imageIcon2 = aResourceBundle.getResourceImage(string + "statusWorkingIcon.png");
        ImageIcon imageIcon3 = aResourceBundle.getResourceImage(string + "addSQLQueryIcon.png");
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(0, 2, 0, 1)));
        statusIndicator.setIcon(imageIcon);
        statusIndicator.setDisabledIcon(imageIcon2);
        statusIndicator.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        Utils.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 20.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(statusIndicator, gridBagConstraints);
        jPanel2.add(statusIndicator);
        statusLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        statusLabel.setPreferredSize(new Dimension(this.getFontMetrics(this.getFont()).stringWidth("1000.00 Seconds"), DBTablesPanel.statusLabel.getPreferredSize().height));
        Utils.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 80.0, 100.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(statusLabel, gridBagConstraints);
        jPanel2.add(statusLabel);
        Utils.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 6.0, 100.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.sqlQueryBucketButton = new JButton(imageIcon3);
        this.sqlQueryBucketButton.setMargin(new Insets(0, 0, 0, 0));
        this.sqlQueryBucketButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), this.sqlQueryBucketButton.getBorder()));
        this.sqlQueryBucketButton.setFocusPainted(false);
        this.sqlQueryBucketButton.addActionListener(this);
        Utils.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 1.0, 100.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.sqlQueryBucketButton, gridBagConstraints);
        jPanel.add(this.sqlQueryBucketButton);
        tableSelectionComboBox.setBorder(BorderFactory.createRaisedBevelBorder());
        tableSelectionComboBox.addActionListener(this);
        tableSelectionComboBox.setEnabled(false);
        if (!arrayList.isEmpty()) {
            Iterator<String> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                tableSelectionComboBox.addItem(iterator.next());
            }
            String string2 = (String)tableSelectionComboBox.getItemAt(0);
            DBTablesPanel.loadTable(string2, connection);
            tableSelectionComboBox.setEnabled(true);
        }
        Utils.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 93.0, 100.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(tableSelectionComboBox, gridBagConstraints);
        jPanel.add(tableSelectionComboBox);
        this.add((Component)jPanel, "North");
        this.add((Component)tablesPanel, "Center");
        disableActions = false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = actionEvent.getSource();
        if (object2 instanceof JButton && !disableActions && object2 == this.sqlQueryBucketButton && (object = DBTablesPanel.getSelectedTableTabPanel()) != null) {
            Main_Frame.getSQLBucket().addSQLStatement(((TableTabPanel)object).getTableSQLStatement());
        }
        if (object2 instanceof JComboBox && !disableActions && object2 == tableSelectionComboBox) {
            object = (String)tableSelectionComboBox.getSelectedItem();
            if (tableCards.contains(object)) {
                tablesCardLayout.show(tablesPanel, (String)object);
            } else {
                Thread thread = new Thread((Runnable)new LoadTableThread(), "DBTablesPanel actionPerformed() loadTableThread");
                thread.start();
            }
        }
    }

    private static synchronized void loadTable(String string, Connection connection) {
        String string2 = ConnectionManager.getDataSourceType();
        TableTabPanel tableTabPanel = string2.equals("mysql") ? new TableTabPanel_MySQL(string, connection, false) : (string2.equals("mariadb") ? new TableTabPanel_MySQL(string, connection, false) : (string2.equals("postgresql") ? new TableTabPanel_PostgreSQL(string, connection, false) : (string2.indexOf("hsql") != -1 ? new TableTabPanel_HSQL(string, connection, false) : (string2.equals("oracle") ? new TableTabPanel_Oracle(string, connection, false) : (string2.equals("sqlite") ? new TableTabPanel_SQLite(string, connection, false) : (string2.equals("odbc") ? new TableTabPanel_MSAccess(string, connection, false) : (string2.equals("sqlserver") ? new TableTabPanel_MSSQL(string, connection, false) : (string2.equals("derby") ? new TableTabPanel_Derby(string, connection, false) : new TableTabPanel_Generic(string, connection, false)))))))));
        if (tableTabPanel.getTableFields() != null) {
            tableTabPanel.addMouseListener(Ajqvue.getPopupMenuListener());
            tablesPanel.add(string, tableTabPanel);
            tableTabHashMap.put(string, tableTabPanel);
            tableCards.addFirst(string);
            if (tableCards.size() > 10) {
                String string3 = tableCards.removeLast();
                TableTabPanel tableTabPanel2 = tableTabHashMap.get(string3);
                if (tableTabPanel2 != null) {
                    tablesPanel.remove(tableTabPanel2);
                    tablesPanel.validate();
                }
                tableTabHashMap.remove(string3);
            }
        }
    }

    public static void reloadPanel(Connection connection, ArrayList<String> arrayList) {
        tableSelectionComboBox.setEnabled(false);
        disableActions = true;
        statusLabel.setEnabled(true);
        tableSelectionComboBox.removeAllItems();
        tableTabHashMap.clear();
        tableCards.clear();
        tablesPanel.removeAll();
        tablesPanel.setLayout(tablesCardLayout);
        if (!arrayList.isEmpty()) {
            Iterator<String> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                tableSelectionComboBox.addItem(iterator.next());
            }
            tableSelectionComboBox.setEnabled(true);
            String string = (String)tableSelectionComboBox.getItemAt(0);
            DBTablesPanel.loadTable(string, connection);
        }
        disableActions = false;
    }

    public static void startStatusTimer() {
        Date date = new Date();
        statusTimer = date.getTime();
        stopStatusDelayThread = true;
        statusIndicator.setEnabled(false);
        statusLabel.setText("Working");
    }

    public static void stopStatusTimer() {
        Date date = new Date();
        statusTimer = date.getTime() - statusTimer;
        String string = Utils.nDigitChop((double)statusTimer * 0.001, 2) + " Seconds";
        if (string.length() > 13) {
            string = string.substring(0, 12);
        }
        statusIndicator.setEnabled(true);
        statusLabel.setText(string);
        Thread thread = new Thread(new Runnable(){
            long timeSlice;
            long totalElaspedTime;
            long totalDelay;

            @Override
            public void run() {
                this.timeSlice = 500L;
                this.totalDelay = 2500L;
                this.totalElaspedTime = 0L;
                stopStatusDelayThread = false;
                try {
                    while (this.totalElaspedTime <= this.totalDelay) {
                        if (!stopStatusDelayThread) {
                            Thread.sleep(this.timeSlice);
                            this.totalElaspedTime += this.timeSlice;
                            continue;
                        }
                        return;
                    }
                    statusLabel.setText("Idle");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, "DBTablesPanel.statusDelayThread");
        thread.start();
    }

    public static DataImportProperties getDataImportProperties() {
        return dataImportProperties;
    }

    public static DataExportProperties getDataExportProperties() {
        return dataExportProperties;
    }

    public static GeneralDBProperties getGeneralDBProperties() {
        return generalDBProperties;
    }

    public static TableTabPanel getSelectedTableTabPanel() {
        TableTabPanel tableTabPanel = tableTabHashMap.get(tableSelectionComboBox.getSelectedItem());
        if (tableSelectionComboBox.getItemCount() != 0 && tableTabPanel != null) {
            return tableTabPanel;
        }
        return null;
    }

    public static int getTableCount() {
        if (tableSelectionComboBox.getItemCount() == 0) {
            return 0;
        }
        return tableSelectionComboBox.getItemCount();
    }

    public static synchronized TableTabPanel getTableTabPanel(String string) {
        if (tableTabHashMap.get(string) == null) {
            Connection connection = ConnectionManager.getConnection("DBTablesPanel getTableTabPanel()");
            DBTablesPanel.loadTable(string, connection);
            ConnectionManager.closeConnection(connection, "DBTablesPanel getTableTabPanel()");
        }
        if (tableTabHashMap.get(string) == null) {
            return null;
        }
        return tableTabHashMap.get(string);
    }

    public static void setDataImportProperties(DataImportProperties dataImportProperties) {
        DBTablesPanel.dataImportProperties = dataImportProperties;
    }

    public static void setDataExportProperties(DataExportProperties dataExportProperties) {
        DBTablesPanel.dataExportProperties = dataExportProperties;
    }

    public static void setGeneralDBProperties(GeneralDBProperties generalDBProperties) {
        DBTablesPanel.generalDBProperties = generalDBProperties;
        TableTabPanel tableTabPanel = DBTablesPanel.getSelectedTableTabPanel();
        tableTabPanel.refreshButton.doClick();
    }

    public static synchronized void setSelectedTableTabPanel(String string) {
        boolean bl = false;
        for (int i = 0; i < tableSelectionComboBox.getItemCount(); ++i) {
            if (!tableSelectionComboBox.getItemAt(i).equals(string)) continue;
            bl = true;
        }
        if (bl) {
            if (tableTabHashMap.get(string) == null) {
                String string2 = "DBTablesPanel setSelectedTableTabPanel()";
                Connection connection = ConnectionManager.getConnection(string2);
                DBTablesPanel.loadTable(string, connection);
                ConnectionManager.closeConnection(connection, string2);
            }
            if (tableTabHashMap.get(string) == null) {
                return;
            }
            tableSelectionComboBox.setSelectedItem(string);
            tableSelectionComboBox.repaint();
        }
    }

    static {
        generalDBProperties = new GeneralDBProperties();
        dataImportProperties = new DataImportProperties();
        dataExportProperties = new DataExportProperties();
    }

    private static class LoadTableThread
    implements Runnable {
        private LoadTableThread() {
        }

        @Override
        public void run() {
            Connection connection = ConnectionManager.getConnection("DBTablesPanel actionPerformed()");
            if (connection == null) {
                return;
            }
            DBTablesPanel.startStatusTimer();
            String string = (String)tableSelectionComboBox.getSelectedItem();
            DBTablesPanel.loadTable(string, connection);
            tablesCardLayout.show(tablesPanel, string);
            ConnectionManager.closeConnection(connection, "DBTablesPanel actionPerformed()");
            DBTablesPanel.stopStatusTimer();
        }
    }
}

