/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import javax.swing.JPanel;

public class CreditsPanel
extends JPanel
implements Runnable {
    private static final long serialVersionUID = 70355272186430290L;
    private String[] version = Ajqvue.getVersion();
    private String webSiteString = Ajqvue.getWebSite();
    private volatile boolean runThread;
    private transient Image offScreenGraphicsImage;
    private transient Image backgroundImage;
    private int backgroundImageWidth;
    private int backgroundImageHeight;
    private int yOffset;
    private static final int scrollPadding = 75;
    private static final long scrollSpeed = 40L;
    private static String[] developersNames = new String[]{"Dana M. Proctor", "sqlite.org", "hsqldb.org", "h2database.com", "itextpdf.com", "gnu.org/software/freefont/"};
    private static String[] developersTitles = new String[]{"Project Manager", "Sqlite", "HyperSQL", "H2 Database", "iText Library", "FreeFont"};

    public CreditsPanel() {
        AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
        String string = Utils.getFileSeparator();
        String string2 = ConnectionManager.getDataSourceType();
        this.runThread = true;
        this.backgroundImage = string2.equals("mysql") ? aResourceBundle.getResourceImage("images" + string + "dolphin.jpg").getImage() : (string2.equals("mariadb") ? aResourceBundle.getResourceImage("images" + string + "seal.jpg").getImage() : (string2.equals("postgresql") ? aResourceBundle.getResourceImage("images" + string + "elephant.jpg").getImage() : (string2.indexOf("hsql") != -1 ? aResourceBundle.getResourceImage("images" + string + "spiral.jpg").getImage() : (string2.equals("oracle") ? aResourceBundle.getResourceImage("images" + string + "letterO.jpg").getImage() : (string2.equals("sqlite") ? aResourceBundle.getResourceImage("images" + string + "feather.jpg").getImage() : (string2.equals("odbc") ? aResourceBundle.getResourceImage("images" + string + "key.jpg").getImage() : (string2.equals("sqlserver") ? aResourceBundle.getResourceImage("images" + string + "framework.jpg").getImage() : (string2.equals("derby") ? aResourceBundle.getResourceImage("images" + string + "derby.jpg").getImage() : (string2.equals("h2") ? aResourceBundle.getResourceImage("images" + string + "h2.jpg").getImage() : aResourceBundle.getResourceImage("images" + string + "battleship.jpg").getImage())))))))));
        this.backgroundImageWidth = this.backgroundImage.getWidth(null);
        this.backgroundImageHeight = this.backgroundImage.getHeight(null);
    }

    @Override
    public void run() {
        while (this.runThread) {
            this.render();
            --this.yOffset;
            this.timeStep();
        }
    }

    private void render() {
        Dimension dimension;
        if (this.getGraphics() != null && this.checkImage(dimension = this.getSize())) {
            this.drawPanel(this.offScreenGraphicsImage.getGraphics());
            this.getGraphics().drawImage(this.offScreenGraphicsImage, 0, 0, null);
        }
    }

    private boolean checkImage(Dimension dimension) {
        if (dimension.width == 0 || dimension.height == 0) {
            return false;
        }
        if (this.offScreenGraphicsImage == null || this.offScreenGraphicsImage.getWidth(null) != dimension.width || this.offScreenGraphicsImage.getHeight(null) != dimension.height) {
            this.offScreenGraphicsImage = this.createImage(dimension.width, dimension.height);
        }
        return true;
    }

    private void timeStep() {
        try {
            Thread.sleep(40L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Process Interrupted.");
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.drawPanel(graphics);
    }

    private void drawPanel(Graphics graphics) {
        Font font;
        Font font2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.getFont() != null) {
            String string = this.getFont().getFontName();
            int n = this.getFont().getSize();
            font2 = this.getFont();
            font = new Font(string, 1, n);
        } else {
            font2 = new Font("Serif", 0, 12);
            font = new Font("Serif", 1, 12);
        }
        BasicStroke basicStroke = new BasicStroke(2.0f, 0, 1);
        BasicStroke basicStroke2 = new BasicStroke(3.0f, 0, 1);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, n4, n5);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.22f));
        if (n4 != this.backgroundImageWidth || n5 != this.backgroundImageHeight) {
            Image image = this.createImage(n4, n5);
            Graphics2D graphics2D2 = (Graphics2D)image.getGraphics();
            AffineTransform affineTransform = AffineTransform.getScaleInstance((double)n4 / (double)this.backgroundImageWidth, (double)n5 / (double)this.backgroundImageHeight);
            graphics2D2.setTransform(affineTransform);
            graphics2D2.drawImage(this.backgroundImage, 0, 0, null);
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D2.dispose();
        } else {
            graphics2D.drawImage(this.backgroundImage, 0, 0, null);
        }
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.setStroke(basicStroke);
        graphics2D.setPaint(Color.LIGHT_GRAY);
        Line2D.Double double_ = new Line2D.Double(0.0, n5, n4, n5);
        Line2D.Double double_2 = new Line2D.Double(n4, 0.0, n4, n5);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
        graphics2D.setStroke(basicStroke2);
        graphics2D.setPaint(Color.DARK_GRAY);
        Line2D.Double double_3 = new Line2D.Double(0.0, 0.0, n4, 0.0);
        Line2D.Double double_4 = new Line2D.Double(0.0, 0.0, 0.0, n5);
        graphics2D.draw(double_3);
        graphics2D.draw(double_4);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        n3 = fontMetrics.stringWidth(this.version[0]);
        n = (n4 - n3) / 2;
        graphics2D.drawString(this.version[0], n, (n2 += fontMetrics.getHeight() + 1) + this.yOffset + n5);
        graphics2D.setFont(font2);
        n3 = fontMetrics.stringWidth(this.version[1]);
        n = (n4 - n3) / 2;
        graphics2D.drawString(this.version[1], n, (n2 += fontMetrics.getHeight() + 1) + this.yOffset + n5);
        n3 = fontMetrics.stringWidth(this.version[2]);
        n = (n4 - n3) / 2;
        graphics2D.drawString(this.version[2], n, (n2 += fontMetrics.getHeight() + 1) + this.yOffset + n5);
        n2 += 15;
        for (int i = 0; i < developersNames.length; ++i) {
            graphics2D.setFont(font);
            fontMetrics = graphics2D.getFontMetrics();
            n3 = fontMetrics.stringWidth(developersTitles[i]);
            n = (n4 - n3) / 2;
            graphics2D.drawString(developersTitles[i], n, (n2 += fontMetrics.getHeight() + 1) + this.yOffset + n5);
            graphics2D.setFont(font2);
            fontMetrics = graphics2D.getFontMetrics();
            n3 = fontMetrics.stringWidth(developersNames[i]);
            n = (n4 - n3) / 2;
            graphics2D.drawString(developersNames[i], n, (n2 += fontMetrics.getHeight() + 1) + this.yOffset + n5);
            if (i == developersNames.length - 1 && Math.abs(this.yOffset) >= n2 + n5 + 75) {
                this.yOffset = 0;
            }
            n2 += 15;
        }
        graphics2D.setFont(font);
        fontMetrics = graphics2D.getFontMetrics();
        n3 = fontMetrics.stringWidth("WebSite");
        n = (n4 - n3) / 2;
        graphics2D.drawString("WebSite", n, (n2 += fontMetrics.getHeight() + 1) + this.yOffset + n5);
        graphics2D.setFont(font2);
        fontMetrics = graphics2D.getFontMetrics();
        n3 = fontMetrics.stringWidth(this.webSiteString);
        n = (n4 - n3) / 2;
        graphics2D.drawString(this.webSiteString, n, (n2 += fontMetrics.getHeight() + 1) + this.yOffset + n5);
    }

    public synchronized void suspendPanel(boolean bl) {
        this.runThread = !bl;
    }
}

