/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;

public class AppGeneralPreferencesPanel
extends JPanel {
    private static final long serialVersionUID = 5287224058215428943L;
    private JComboBox<Object> localizationComboBox;
    private JSpinner fontSizeSpinner;

    public AppGeneralPreferencesPanel() {
        int n;
        Serializable serializable;
        AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
        String string = Utils.getFileSeparator();
        String string2 = Utils.getIconsDirectory() + string;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridLayout(2, 1, 2, 2));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0), BorderFactory.createLoweredBevelBorder()));
        Object object = UIManager.get("Label.font");
        if (object != null && object instanceof Font) {
            serializable = (Font)object;
            n = serializable.getSize();
        } else {
            n = 12;
        }
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createEtchedBorder()));
        ImageIcon imageIcon = aResourceBundle.getResourceImage(string2 + "localeIcon.gif");
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 5));
        Utils.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 34.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        String string3 = aResourceBundle.getResourceString("AppGeneralPreferencesPanel.label.Language", "Language");
        String string4 = aResourceBundle.getResourceString("AppGeneralPreferencesPanel.label.RestartRequired", "Restart Required");
        JLabel jLabel2 = new JLabel(string3 + " ( " + string4 + " ) ");
        jLabel2.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        Utils.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        this.localizationComboBox = new JComboBox<Object>(this.getLocaleList().toArray());
        this.localizationComboBox.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 4));
        this.localizationComboBox.setSelectedItem(Ajqvue.getLocaleString());
        Utils.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 33.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.localizationComboBox, gridBagConstraints);
        jPanel.add(this.localizationComboBox);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createEtchedBorder()));
        ImageIcon imageIcon2 = aResourceBundle.getResourceImage(string2 + "fontSizeIcon.gif");
        JLabel jLabel3 = new JLabel(imageIcon2);
        jLabel3.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 5));
        Utils.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 20.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel2.add(jLabel3);
        JPanel jPanel3 = new JPanel();
        string4 = aResourceBundle.getResourceString("AppGeneralPreferencesPanel.label.FontSize", "Font Size");
        JLabel jLabel4 = new JLabel(string4);
        jLabel4.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        jPanel3.add(jLabel4);
        serializable = new SpinnerNumberModel(n, 8, 24, 1);
        this.fontSizeSpinner = new JSpinner((SpinnerModel)((Object)serializable));
        jPanel3.add(this.fontSizeSpinner);
        Utils.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 80.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel2.add(jPanel3);
        this.add(jPanel2);
    }

    private ArrayList<String> getLocaleList() {
        ArrayList<String> arrayList;
        block4: {
            File file = new File(Utils.getAjqvueDirectory() + Utils.getFileSeparator() + "locale" + Utils.getFileSeparator());
            arrayList = new ArrayList<String>();
            try {
                String[] stringArray;
                if (file.exists() && file.isDirectory() && (stringArray = file.list()) != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        int n = stringArray[i].lastIndexOf(".");
                        if (n <= 0 || !stringArray[i].substring(n + 1).equals("properties")) continue;
                        arrayList.add(stringArray[i].substring(n - 5, n));
                    }
                }
            }
            catch (SecurityException securityException) {
                if (!Ajqvue.getDebug()) break block4;
                System.out.println("AppGeneralPreferencesPanel getLocaleList() " + securityException);
            }
        }
        return arrayList;
    }

    public String getLocalization() {
        return (String)this.localizationComboBox.getSelectedItem();
    }

    public int getFontSize() {
        return Integer.parseInt(this.fontSizeSpinner.getValue().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLocalization(String string) throws IOException {
        String string2 = Utils.getFileSeparator();
        String string3 = "ajqvue_locale.txt";
        String string4 = Utils.getAjqvueConfDirectory() + string2 + string3;
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            File file = new File(string4);
            fileWriter = new FileWriter(file);
            bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string);
            bufferedWriter.flush();
            fileWriter.flush();
            return;
        }
        catch (IOException iOException) {
            if (!Ajqvue.getDebug()) return;
            System.out.println("AppGeneralPreferencesPanel setLocalization() " + iOException);
            return;
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                if (Ajqvue.getDebug()) {
                    System.out.println("AppGeneralPreferencesPanel setLocalization() " + iOException);
                }
            }
            finally {
                block40: {
                    try {
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!Ajqvue.getDebug()) break block40;
                        System.out.println("AppGeneralPreferencesPanel setLocalization() " + iOException);
                    }
                }
            }
        }
    }
}

