/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.gui.Main_JMenuBarActions;
import com.dandymadeproductions.ajqvue.io.WriteDataFile;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.InputDialog;
import com.dandymadeproductions.ajqvue.utilities.SQLQueryBucketListCellRenderer;
import com.dandymadeproductions.ajqvue.utilities.SQLQueryBucketListObject;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.regex.Matcher;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.TransferHandler;

public class SQLQueryBucketFrame
extends JFrame
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 3713630920251154493L;
    private JList<Object> sqlQueryList;
    private JPopupMenu sqlListPopupMenu;
    private JButton viewButton;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private JTextArea dialog_sqlTextArea;
    private JButton dialog_colorButton;
    private AResourceBundle resourceBundle;
    private String databaseName;
    private String fileSeparator = Utils.getFileSeparator();
    private String iconsDirectory;
    private String lastOpenSaveDirectory = "";
    private String savedFileName = "";
    private String resourceFile;
    private String resourceOpen;
    private String resourceSave;
    private String fileName;
    private StringBuffer stringBuffer;
    private String resourceAlert;
    private SQLQueryBucketListObject processingBucketListObject;
    private JColorChooser panelColorChooser;
    private boolean processItem = false;
    private boolean colorAction = false;
    private String lastActionCommand = "";
    private int selectedListIndex = -1;
    private static final String FILE_OPEN = "FO";
    private static final String FILE_SAVE = "FS";
    private static final String FILE_SAVE_AS = "FSA";
    private static final String EXIT = "FE";
    private static final String VIEW = "View";
    private static final String ADD = "Add";
    private static final String EDIT = "Edit";
    private static final String DELETE = "Delete";
    private static final String DIALOG_SQLSTATEMENT_OPEN = "DialogSQLStatementOpen";
    private static final String DIALOG_SQLSTATEMENT_SAVE = "DialogSQLStatementSave";
    private static final String DIALOG_SQLSTATEMENT_COLOR = "DialogColor";
    private static final String parameterDelimiter = "%;%";
    private static final String SQL_QUERY_BUCKET_DIRECTORY = "SQLQueryBucket";

    protected SQLQueryBucketFrame() {
        this.resourceBundle = Ajqvue.getResourceBundle();
        this.iconsDirectory = Utils.getIconsDirectory() + this.fileSeparator;
        String string = this.resourceBundle.getResourceString("SQLQueryBucketFrame.message.Title", "Query Bucket Frame");
        this.setTitle("Ajqvue " + string);
        this.setIconImage(Utils.getFrameIcon());
        this.resourceAlert = this.resourceBundle.getResourceString("SQLQueryBucketFrame.dialogtitle.Alert", "Alert");
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SQLQueryBucketFrame.this.setVisible(false);
                Main_JMenuBarActions.setSQLQueryBucketFrameNotVisisble();
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }
        };
        this.addWindowListener(windowAdapter);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBorder(BorderFactory.createEtchedBorder());
        this.createMenuBar(jMenuBar);
        this.setJMenuBar(jMenuBar);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.panelColorChooser = Utils.createColorChooser(this);
        ListHoldingPanel listHoldingPanel = new ListHoldingPanel();
        listHoldingPanel.setLayout(new BorderLayout());
        DefaultListModel defaultListModel = new DefaultListModel();
        this.sqlQueryList = new JList(defaultListModel);
        this.sqlQueryList.setOpaque(false);
        this.sqlQueryList.setDragEnabled(true);
        this.sqlQueryList.setCellRenderer(new SQLQueryBucketListCellRenderer());
        this.sqlQueryList.setSelectionMode(2);
        this.sqlListPopupMenu = this.createPopupMenu();
        this.sqlQueryList.add(this.sqlListPopupMenu);
        this.sqlQueryList.setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 2558730071314905153L;
            private boolean isThisDropping;

            @Override
            public boolean canImport(TransferHandler.TransferSupport transferSupport) {
                this.isThisDropping = false;
                if (transferSupport.getComponent().equals(SQLQueryBucketFrame.this.sqlQueryList) && transferSupport.getDropLocation() instanceof JList.DropLocation) {
                    JList.DropLocation dropLocation = (JList.DropLocation)transferSupport.getDropLocation();
                    if (dropLocation.getIndex() == -1) {
                        return false;
                    }
                    this.isThisDropping = true;
                    return true;
                }
                return false;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport transferSupport) {
                if (!(transferSupport.isDrop() && this.isThisDropping && transferSupport.getDropLocation() instanceof JList.DropLocation)) {
                    return false;
                }
                JList.DropLocation dropLocation = (JList.DropLocation)transferSupport.getDropLocation();
                DefaultListModel defaultListModel = (DefaultListModel)SQLQueryBucketFrame.this.sqlQueryList.getModel();
                int n = dropLocation.getIndex();
                boolean bl = dropLocation.isInsert();
                SQLQueryBucketListObject sQLQueryBucketListObject = (SQLQueryBucketListObject)defaultListModel.getElementAt(SQLQueryBucketFrame.this.selectedListIndex);
                if (bl) {
                    int n2 = SQLQueryBucketFrame.this.sqlQueryList.getModel().getSize();
                    if (n == 0) {
                        defaultListModel.add(n, defaultListModel.getElementAt(SQLQueryBucketFrame.this.selectedListIndex));
                        defaultListModel.remove(SQLQueryBucketFrame.this.selectedListIndex + 1);
                    } else if (n >= n2) {
                        defaultListModel.addElement(sQLQueryBucketListObject);
                        defaultListModel.remove(SQLQueryBucketFrame.this.selectedListIndex);
                    } else {
                        defaultListModel.add(n, defaultListModel.getElementAt(SQLQueryBucketFrame.this.selectedListIndex));
                        if (n < SQLQueryBucketFrame.this.selectedListIndex) {
                            defaultListModel.remove(SQLQueryBucketFrame.this.selectedListIndex + 1);
                        } else {
                            defaultListModel.remove(SQLQueryBucketFrame.this.selectedListIndex);
                        }
                    }
                }
                SQLQueryBucketFrame.this.selectedListIndex = -1;
                this.isThisDropping = false;
                return true;
            }

            @Override
            public int getSourceActions(JComponent jComponent) {
                return 1;
            }

            @Override
            protected Transferable createTransferable(JComponent jComponent) {
                if (jComponent instanceof JList) {
                    JList jList = (JList)jComponent;
                    return new StringSelection(((SQLQueryBucketListObject)jList.getSelectedValue()).getSQLStatementString().toString());
                }
                return new StringSelection("");
            }
        });
        this.sqlQueryList.setDropMode(DropMode.INSERT);
        this.sqlQueryList.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.sqlQueryList);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.add(this.sqlListPopupMenu);
        listHoldingPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)listHoldingPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        string = this.resourceBundle.getResourceString("SQLQueryBucketFrame.button.View", VIEW);
        this.viewButton = new JButton(string);
        this.viewButton.setMnemonic(86);
        this.viewButton.addActionListener(this);
        jPanel2.add(this.viewButton);
        string = this.resourceBundle.getResourceString("SQLQueryBucketFrame.button.Add", ADD);
        this.addButton = new JButton(string);
        this.addButton.setMnemonic(65);
        this.addButton.addActionListener(this);
        jPanel2.add(this.addButton);
        string = this.resourceBundle.getResourceString("SQLQueryBucketFrame.button.Edit", EDIT);
        this.editButton = new JButton(string);
        this.editButton.setMnemonic(69);
        this.editButton.addActionListener(this);
        jPanel2.add(this.editButton);
        string = this.resourceBundle.getResourceString("SQLQueryBucketFrame.button.Delete", DELETE);
        this.deleteButton = new JButton(string);
        this.deleteButton.setMnemonic(68);
        this.deleteButton.addActionListener(this);
        jPanel2.add(this.deleteButton);
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JMenuItem || object instanceof JButton) {
            String string = object instanceof JMenuItem ? ((JMenuItem)object).getActionCommand() : ((JButton)object).getActionCommand();
            if (string.equals(FILE_OPEN)) {
                this.openAction(this);
            } else if ((string.equals(FILE_SAVE) || string.equals(FILE_SAVE_AS)) && ((DefaultListModel)this.sqlQueryList.getModel()).getSize() != 0) {
                this.saveAction(this, string);
            } else if (string.equals(EXIT)) {
                this.setVisible(false);
                Main_JMenuBarActions.setSQLQueryBucketFrameNotVisisble();
            } else if (string.equals(VIEW) || string.equals(EDIT)) {
                if (this.sqlQueryList.getSelectedIndex() != -1) {
                    this.processingBucketListObject = (SQLQueryBucketListObject)this.sqlQueryList.getSelectedValue();
                    this.createSQLObjectDialog(string);
                    if (this.processItem) {
                        DefaultListModel defaultListModel = (DefaultListModel)this.sqlQueryList.getModel();
                        defaultListModel.set(this.sqlQueryList.getSelectedIndex(), this.processingBucketListObject);
                        this.processItem = false;
                    }
                }
            } else if (string.equals(ADD)) {
                this.addSQLStatement(new StringBuffer());
            } else if (string.equals(DELETE)) {
                if (this.sqlQueryList.getSelectedIndex() != -1) {
                    Iterator<Object> iterator = this.sqlQueryList.getSelectedValuesList().iterator();
                    while (iterator.hasNext()) {
                        ((DefaultListModel)this.sqlQueryList.getModel()).removeElement(iterator.next());
                    }
                }
            } else if (string.equals(DIALOG_SQLSTATEMENT_OPEN)) {
                if (this.lastActionCommand.equals(EDIT) || this.lastActionCommand.equals(ADD)) {
                    this.openSQLStatementFile();
                }
            } else if (string.equals(DIALOG_SQLSTATEMENT_SAVE)) {
                this.saveSQLStatementFile();
            } else {
                if (string.equals(DIALOG_SQLSTATEMENT_COLOR)) {
                    String string2 = this.resourceBundle.getResourceString("SQLQueryBucketFrame.title.ItemListColor", "Item List Color");
                    if (string2.equals("")) {
                        string2 = "Item List Color";
                    }
                    this.panelColorChooser.setBorder(BorderFactory.createTitledBorder(string2));
                    this.panelColorChooser.setColor(this.processingBucketListObject.getBackground());
                    this.colorAction = true;
                    JDialog jDialog = JColorChooser.createDialog(this, "Color Selector", true, this.panelColorChooser, this, null);
                    jDialog.setVisible(true);
                    jDialog.dispose();
                    return;
                }
                if (string.equals("OK") && this.colorAction) {
                    this.dialog_colorButton.setBackground(this.panelColorChooser.getColor());
                    this.colorAction = false;
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.sqlListPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        } else if (mouseEvent.getComponent().equals(this.sqlQueryList)) {
            this.selectedListIndex = this.sqlQueryList.getSelectedIndex();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.sqlListPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    private void createMenuBar(JMenuBar jMenuBar) {
        this.resourceFile = this.resourceBundle.getResourceString("SQLQueryBucketFrame.menu.File", "File");
        JMenu jMenu = new JMenu(this.resourceFile);
        jMenu.setFont(jMenu.getFont().deriveFont(1));
        jMenu.addSeparator();
        this.resourceOpen = this.resourceBundle.getResourceString("SQLQueryBucketFrame.menu.Open", "Open");
        jMenu.add(this.menuItem(this.resourceOpen, FILE_OPEN));
        jMenu.addSeparator();
        this.resourceSave = this.resourceBundle.getResourceString("SQLQueryBucketFrame.menu.Save", "Save");
        jMenu.add(this.menuItem(this.resourceSave, FILE_SAVE));
        String string = this.resourceBundle.getResourceString("SQLQueryBucketFrame.menu.SaveAs", "Save As...");
        jMenu.add(this.menuItem(string, FILE_SAVE_AS));
        jMenu.addSeparator();
        string = this.resourceBundle.getResourceString("SQLQueryBucketFrame.menu.Exit", "Exit");
        jMenu.add(this.menuItem(string, EXIT));
        jMenuBar.add(jMenu);
        jMenu.addSeparator();
        jMenuBar.add(Box.createHorizontalGlue());
        ImageIcon imageIcon = this.resourceBundle.getResourceImage(this.iconsDirectory + "ajqvueIcon.gif");
        JButton jButton = new JButton(imageIcon);
        jButton.setDisabledIcon(imageIcon);
        jButton.setFocusPainted(false);
        jButton.setBorder(BorderFactory.createLoweredBevelBorder());
        jMenuBar.add(jButton);
    }

    private JPopupMenu createPopupMenu() {
        JMenuItem jMenuItem = null;
        this.sqlListPopupMenu = new JPopupMenu();
        String string = this.resourceBundle.getResourceString("SQLQueryBucketFrame.button.View", VIEW);
        jMenuItem = this.menuItem(string, VIEW);
        this.sqlListPopupMenu.add(jMenuItem);
        string = this.resourceBundle.getResourceString("SQLQueryBucketFrame.button.Add", ADD);
        jMenuItem = this.menuItem(string, ADD);
        this.sqlListPopupMenu.add(jMenuItem);
        string = this.resourceBundle.getResourceString("SQLQueryBucketFrame.button.Edit", EDIT);
        jMenuItem = this.menuItem(string, EDIT);
        this.sqlListPopupMenu.add(jMenuItem);
        string = this.resourceBundle.getResourceString("SQLQueryBucketFrame.button.Delete", DELETE);
        jMenuItem = this.menuItem(string, DELETE);
        this.sqlListPopupMenu.add(jMenuItem);
        return this.sqlListPopupMenu;
    }

    private JMenuItem menuItem(String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(string2);
        return jMenuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openAction(JFrame jFrame) {
        JFileChooser jFileChooser = this.lastOpenSaveDirectory.equals("") ? new JFileChooser() : new JFileChooser(new File(this.lastOpenSaveDirectory));
        int n = jFileChooser.showOpenDialog(jFrame);
        if (n != 0) return;
        this.lastOpenSaveDirectory = jFileChooser.getCurrentDirectory().toString();
        String string = jFileChooser.getSelectedFile().getName();
        string = jFileChooser.getCurrentDirectory() + this.fileSeparator + string;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        if (string.equals("")) {
            this.createFileNotFoundDialog();
            return;
        }
        try {
            String string2;
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
            int n2 = 1;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (n2 >= 25) return;
                String[] stringArray = string2.split(parameterDelimiter, 0);
                if (stringArray.length == 4) {
                    try {
                        SQLQueryBucketListObject sQLQueryBucketListObject = new SQLQueryBucketListObject();
                        sQLQueryBucketListObject.setText(stringArray[0]);
                        sQLQueryBucketListObject.setSQLStatementString(stringArray[1]);
                        if (stringArray[2].equals("true")) {
                            sQLQueryBucketListObject.setLimited(true);
                        } else {
                            sQLQueryBucketListObject.setLimited(false);
                        }
                        sQLQueryBucketListObject.setBackground(new Color(Integer.parseInt(stringArray[3])));
                        ((DefaultListModel)this.sqlQueryList.getModel()).addElement(sQLQueryBucketListObject);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.createUnableToReadFileDialog();
                    }
                }
                ++n2;
            }
            return;
        }
        catch (IOException iOException) {
            this.createUnableToReadFileDialog();
            return;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                if (Ajqvue.getDebug()) {
                    System.out.println("SQLQueryBucketFrame openAction() Failed to Close BufferedReader. " + iOException);
                }
            }
            finally {
                block47: {
                    try {
                        if (fileReader != null) {
                            fileReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!Ajqvue.getDebug()) break block47;
                        System.out.println("SQLQueryBucketFrame openAction() Failed to Close FileReader. " + iOException);
                    }
                }
            }
        }
    }

    private void saveAction(JFrame jFrame, String string) {
        JFileChooser jFileChooser = this.lastOpenSaveDirectory.equals("") ? new JFileChooser() : new JFileChooser(new File(this.lastOpenSaveDirectory));
        this.fileName = string.equals(FILE_SAVE) && !this.savedFileName.equals("") ? this.savedFileName : (!this.savedFileName.equals("") ? this.savedFileName : ".txt");
        jFileChooser.setSelectedFile(new File(this.fileName));
        int n = string.equals(FILE_SAVE) && !this.savedFileName.equals("") ? 0 : Utils.processFileChooserSelection(jFrame, jFileChooser);
        if (n == 0) {
            this.lastOpenSaveDirectory = jFileChooser.getCurrentDirectory().toString();
            this.savedFileName = this.fileName = jFileChooser.getSelectedFile().getName();
            this.fileName = jFileChooser.getCurrentDirectory() + this.fileSeparator + this.fileName;
            if (!this.fileName.equals("")) {
                DefaultListModel defaultListModel = (DefaultListModel)this.sqlQueryList.getModel();
                int n2 = defaultListModel.getSize();
                this.stringBuffer = new StringBuffer();
                for (int i = 0; i < n2; ++i) {
                    SQLQueryBucketListObject sQLQueryBucketListObject = (SQLQueryBucketListObject)defaultListModel.getElementAt(i);
                    this.stringBuffer.append(sQLQueryBucketListObject.getText() + parameterDelimiter);
                    this.stringBuffer.append(sQLQueryBucketListObject.getSQLStatementString() + parameterDelimiter);
                    this.stringBuffer.append(sQLQueryBucketListObject.isLimited() + parameterDelimiter);
                    this.stringBuffer.append(sQLQueryBucketListObject.getBackground().getRGB() + "\n");
                }
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        WriteDataFile.mainWriteDataString(SQLQueryBucketFrame.this.fileName, SQLQueryBucketFrame.this.stringBuffer.toString().getBytes(), false);
                    }
                }, "SQLQueryBucketFrame.saveActionThread");
                thread.start();
            } else {
                this.createFileNotFoundDialog();
            }
        }
    }

    private void createSQLObjectDialog(String string) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBorder(BorderFactory.createEtchedBorder());
        JMenu jMenu = new JMenu(this.resourceFile);
        jMenu.setFont(jMenu.getFont().deriveFont(1));
        jMenu.addSeparator();
        jMenu.add(this.menuItem(this.resourceOpen, DIALOG_SQLSTATEMENT_OPEN));
        jMenu.addSeparator();
        jMenu.add(this.menuItem(this.resourceSave, DIALOG_SQLSTATEMENT_SAVE));
        jMenuBar.add(jMenu);
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.lastActionCommand = string;
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(2, 0, 2, 0)));
        JTextField jTextField = new JTextField(40);
        jTextField.setMargin(new Insets(1, 0, 0, 0));
        if (string.equals(VIEW) || string.equals(EDIT)) {
            jTextField.setText(this.processingBucketListObject.getText());
        }
        if (string.equals(VIEW)) {
            jTextField.setEditable(false);
        }
        jPanel2.add(jTextField);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100.0, 5.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(gridBagLayout);
        jPanel3.getInsets(new Insets(1, 1, 1, 1));
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(4, 1, 4, 1)));
        String string2 = this.resourceBundle.getResourceString("SQLQueryBucketFrame.label.SQLStatementString", "SQL Statement String");
        JLabel jLabel = new JLabel(string2);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        this.buildConstraints(gridBagConstraints, 0, 0, 2, 1, 100.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel3.add(jLabel);
        this.dialog_sqlTextArea = new JTextArea(5, 40);
        this.dialog_sqlTextArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.dialog_sqlTextArea.setLineWrap(true);
        if (string.equals(VIEW)) {
            this.dialog_sqlTextArea.setEditable(false);
        } else {
            this.dialog_sqlTextArea.setDragEnabled(true);
        }
        this.dialog_sqlTextArea.addMouseListener(Ajqvue.getPopupMenuListener());
        this.dialog_sqlTextArea.setText(this.processingBucketListObject.getSQLStatementString().toString());
        JScrollPane jScrollPane = new JScrollPane(this.dialog_sqlTextArea);
        this.buildConstraints(gridBagConstraints, 0, 1, 2, 1, 100.0, 85.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel3.add(jScrollPane);
        JPanel jPanel4 = new JPanel();
        JCheckBox jCheckBox = new JCheckBox(this.resourceBundle.getResourceImage(this.iconsDirectory + "limitUpIcon.png"));
        jCheckBox.setSelectedIcon(this.resourceBundle.getResourceImage(this.iconsDirectory + "limitDownIcon.png"));
        jCheckBox.setPreferredSize(new Dimension(22, 22));
        jCheckBox.setMargin(new Insets(4, 1, 4, 1));
        jCheckBox.setBorder(BorderFactory.createRaisedBevelBorder());
        jCheckBox.setSelected(this.processingBucketListObject.isLimited());
        if (string.equals(VIEW)) {
            jCheckBox.setEnabled(false);
        }
        jPanel4.add(jCheckBox);
        string2 = this.resourceBundle.getResourceString("SQLQueryBucketFrame.label.LIMIT", "Limit");
        JLabel jLabel2 = new JLabel(string2, 10);
        jPanel4.add(jLabel2);
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 100.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        this.dialog_colorButton = new JButton(this.resourceBundle.getResourceImage(this.iconsDirectory + "transparentUpIcon.png"));
        this.dialog_colorButton.setBackground(this.processingBucketListObject.getBackground());
        this.dialog_colorButton.setFocusable(false);
        this.dialog_colorButton.setMargin(new Insets(0, 0, 0, 0));
        this.dialog_colorButton.setActionCommand(DIALOG_SQLSTATEMENT_COLOR);
        if (string.equals(VIEW)) {
            this.dialog_colorButton.setEnabled(false);
        } else {
            this.dialog_colorButton.addActionListener(this);
        }
        jPanel5.add(this.dialog_colorButton);
        string2 = this.resourceBundle.getResourceString("SQLQueryBucketFrame.label.Color", "Color");
        JLabel jLabel3 = new JLabel(string2, 10);
        jPanel5.add(jLabel3);
        this.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 100.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel3.add(jPanel5);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100.0, 95.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        Object[] objectArray = new Object[]{jPanel};
        string2 = this.resourceBundle.getResourceString("SQLQueryBucketFrame.title.SQLStatementObject", "SQL Statement Object");
        String string3 = this.resourceBundle.getResourceString("SQLQueryBucketFrame.button.OK", "OK");
        String string4 = this.resourceBundle.getResourceString("SQLQueryBucketFrame.button.Cancel", "Cancel");
        InputDialog inputDialog = new InputDialog(null, string2, string3, string4, objectArray, null);
        inputDialog.setJMenuBar(jMenuBar);
        inputDialog.setMinimumSize(new Dimension(600, 400));
        inputDialog.pack();
        inputDialog.center();
        inputDialog.setVisible(true);
        if (inputDialog.isActionResult() && !string.equals(VIEW)) {
            if (jTextField.getText().equals("")) {
                this.processingBucketListObject.setText(" ");
            } else {
                this.processingBucketListObject.setText(jTextField.getText());
            }
            String string5 = this.dialog_sqlTextArea.getText();
            string5 = string5.replaceAll("\r\n", " ");
            string5 = string5.replaceAll("\r", " ");
            string5 = string5.replaceAll("\n", " ");
            this.processingBucketListObject.setSQLStatementString(string5);
            this.processingBucketListObject.setLimited(jCheckBox.isSelected());
            this.processingBucketListObject.setBackground(this.dialog_colorButton.getBackground());
            this.processItem = true;
        }
        inputDialog.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveSQLStatementFile() {
        String string = Utils.getFileSeparator();
        byte[] byArray = this.dialog_sqlTextArea.getText().getBytes();
        JFileChooser jFileChooser = new JFileChooser();
        int n = Utils.processFileChooserSelection(null, jFileChooser);
        if (n != 0) return;
        String string2 = jFileChooser.getSelectedFile().getName();
        string2 = jFileChooser.getCurrentDirectory() + string + string2;
        if (string2.equals("")) {
            this.createUnableToReadFileDialog();
            return;
        }
        FileOutputStream fileOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string2);
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            for (int i = 0; i < byArray.length; ++i) {
                ((BufferedOutputStream)filterOutputStream).write(byArray[i]);
            }
            ((BufferedOutputStream)filterOutputStream).flush();
            return;
        }
        catch (IOException iOException) {
            String string3 = this.resourceBundle.getResourceString("SQLQueryBucketFrame.dialogmessage.ErrorWritingDataFile", "Error Writing Data File");
            JOptionPane.showMessageDialog(null, string3 + " " + string2, this.resourceAlert, 0);
            return;
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {
                if (Ajqvue.getDebug()) {
                    System.out.println("SQLQueryBucketFrame saveSQLStatementFile() Failed to Close BufferedOutputStream. " + iOException);
                }
            }
            finally {
                block42: {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!Ajqvue.getDebug()) break block42;
                        System.out.println("SQLQueryBucketFrame saveSQLStatementFile() Failed to Close FileOutputStream. " + iOException);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openSQLStatementFile() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(null);
        if (n != 0) return;
        String string = jFileChooser.getSelectedFile().getName();
        string = jFileChooser.getCurrentDirectory() + "/" + string;
        if (string.equals("")) return;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
            }
            this.dialog_sqlTextArea.setText(stringBuffer.toString());
            return;
        }
        catch (IOException iOException) {
            String string3 = this.resourceBundle.getResourceString("SQLQueryBucketFrame.dialogmessage.ErrorReading", "Error Reading Data File");
            JOptionPane.showMessageDialog(null, string3 + ": " + string, this.resourceAlert, 0);
            return;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                if (Ajqvue.getDebug()) {
                    System.out.println("SQLQueryBucketFrame openSQLStatementFile() Failed to Close BufferedReader. " + iOException);
                }
            }
            finally {
                block41: {
                    try {
                        if (fileReader != null) {
                            fileReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!Ajqvue.getDebug()) break block41;
                        System.out.println("SQLQueryBucketFrame openSQLStatementFile() Failed to Close FileReader. " + iOException);
                    }
                }
            }
        }
    }

    private void createUnableToReadFileDialog() {
        String string = this.resourceBundle.getResourceString("SQLQueryBucketFrame.dialogmessage.InputFile", "Unable to Read Input File");
        JOptionPane.showMessageDialog(null, "SQLQueryBucketFrame: " + string, this.resourceAlert, 0);
    }

    private void createFileNotFoundDialog() {
        String string = this.resourceBundle.getResourceString("SQLQueryBucketFrame.dialogmessage.FileNOTFound", "File NOT Found");
        JOptionPane.showMessageDialog(null, "SQLQueryBucketFrame: " + string, this.resourceAlert, 0);
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    public void addSQLStatement(StringBuffer stringBuffer) {
        this.setVisible(true);
        this.processingBucketListObject = new SQLQueryBucketListObject();
        this.processingBucketListObject.setText("");
        this.processingBucketListObject.setSQLStatementString(stringBuffer.toString());
        this.processingBucketListObject.setLimited(true);
        this.processingBucketListObject.setBackground(this.getBackground());
        this.createSQLObjectDialog(ADD);
        if (this.processItem) {
            ((DefaultListModel)this.sqlQueryList.getModel()).addElement(this.processingBucketListObject);
        }
        this.processItem = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void openLastUsedList(String string) {
        if (string.startsWith(":")) {
            string = string.substring(1, string.length());
        }
        this.databaseName = string.replaceAll("/", "_");
        String string2 = "\\";
        this.databaseName = this.databaseName.replaceAll(Matcher.quoteReplacement(string2), "_");
        if (this.databaseName.indexOf(";") != -1) {
            this.databaseName = this.databaseName.substring(0, this.databaseName.indexOf(";"));
        }
        String string3 = Utils.getFileSeparator();
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string4;
            String string5;
            File file;
            String string6 = Utils.getAjqvueConfDirectory() + string3 + SQL_QUERY_BUCKET_DIRECTORY + string3 + ConnectionManager.getDataSourceType();
            File file2 = new File(string6);
            if (!file2.isDirectory()) {
                try {
                    if (!file2.mkdirs()) {
                        throw new SecurityException();
                    }
                }
                catch (SecurityException securityException) {
                    if (Ajqvue.getDebug()) {
                        System.out.println("Failed to Make SQL Query Bucket Directory.\n" + securityException.toString());
                    }
                    try {
                        if (bufferedReader == null) return;
                        bufferedReader.close();
                        return;
                    }
                    catch (IOException iOException) {
                        if (!Ajqvue.getDebug()) return;
                        System.out.println("SQLQueryBucketFrame openLastUsedList() Failed to Close BufferedReader. " + iOException);
                        return;
                    }
                    finally {
                        block66: {
                            try {
                                if (inputStreamReader != null) {
                                    inputStreamReader.close();
                                }
                            }
                            catch (IOException iOException) {
                                if (!Ajqvue.getDebug()) break block66;
                                System.out.println("SQLQueryBucketFrame openLastUsedList() Failed to Close FileReader. " + iOException);
                            }
                        }
                    }
                }
            }
            if ((file = new File(string5 = string6 + string3 + this.databaseName + ".txt")).createNewFile() && Ajqvue.getDebug()) {
                System.out.println("SQLQueryBucketFrame openLastUsedList() Creating File");
            }
            inputStreamReader = new FileReader(file);
            bufferedReader = new BufferedReader(inputStreamReader);
            int n = 1;
            while ((string4 = bufferedReader.readLine()) != null) {
                if (n >= 25) return;
                String[] stringArray = string4.split(parameterDelimiter, 0);
                if (stringArray.length == 4) {
                    try {
                        SQLQueryBucketListObject sQLQueryBucketListObject = new SQLQueryBucketListObject();
                        sQLQueryBucketListObject.setText(stringArray[0]);
                        sQLQueryBucketListObject.setSQLStatementString(stringArray[1]);
                        if (stringArray[2].equals("true")) {
                            sQLQueryBucketListObject.setLimited(true);
                        } else {
                            sQLQueryBucketListObject.setLimited(false);
                        }
                        sQLQueryBucketListObject.setBackground(new Color(Integer.parseInt(stringArray[3])));
                        ((DefaultListModel)this.sqlQueryList.getModel()).addElement(sQLQueryBucketListObject);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ++n;
            }
            return;
        }
        catch (IOException iOException) {
            this.createUnableToReadFileDialog();
            return;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                if (Ajqvue.getDebug()) {
                    System.out.println("SQLQueryBucketFrame openLastUsedList() Failed to Close BufferedReader. " + iOException);
                }
            }
            finally {
                block68: {
                    try {
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!Ajqvue.getDebug()) break block68;
                        System.out.println("SQLQueryBucketFrame openLastUsedList() Failed to Close FileReader. " + iOException);
                    }
                }
            }
        }
    }

    protected void saveLastUsedList() {
        DefaultListModel defaultListModel = (DefaultListModel)this.sqlQueryList.getModel();
        int n = defaultListModel.getSize();
        this.stringBuffer = new StringBuffer();
        String string = Utils.getFileSeparator();
        String string2 = Utils.getAjqvueConfDirectory() + string + SQL_QUERY_BUCKET_DIRECTORY + string + ConnectionManager.getDataSourceType();
        File file = new File(string2);
        if (!file.isDirectory()) {
            try {
                if (!file.mkdirs()) {
                    throw new SecurityException();
                }
            }
            catch (SecurityException securityException) {
                if (Ajqvue.getDebug()) {
                    System.out.println("Failed to Make SQL Query Bucket Directory.\n" + securityException.toString());
                }
                return;
            }
        }
        String string3 = this.databaseName.startsWith(":") ? string2 + string + this.databaseName.substring(1, this.databaseName.length()) + ".txt" : string2 + string + this.databaseName + ".txt";
        for (int i = 0; i < n; ++i) {
            SQLQueryBucketListObject sQLQueryBucketListObject = (SQLQueryBucketListObject)defaultListModel.getElementAt(i);
            this.stringBuffer.append(sQLQueryBucketListObject.getText() + parameterDelimiter);
            this.stringBuffer.append(sQLQueryBucketListObject.getSQLStatementString() + parameterDelimiter);
            this.stringBuffer.append(sQLQueryBucketListObject.isLimited() + parameterDelimiter);
            this.stringBuffer.append(sQLQueryBucketListObject.getBackground().getRGB() + "\n");
        }
        if (this.stringBuffer.length() != 0) {
            WriteDataFile.mainWriteDataString(string3, this.stringBuffer.toString().getBytes(), false);
        }
    }

    protected void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n, n2);
    }

    private static class ListHoldingPanel
    extends JPanel {
        private static final long serialVersionUID = -393463236488405775L;
        static final float alpha = 0.9f;

        private ListHoldingPanel() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n = 65;
            Color[] colorArray = new Color[2];
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.9f));
            BasicStroke basicStroke = new BasicStroke(1.0f, 0, 1);
            graphics2D.setStroke(basicStroke);
            graphics2D.setPaint(this.getParent().getBackground());
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            graphics2D.fillRect(0, 0, n2, n3);
            for (int i = 0; i < n; ++i) {
                double d = (double)n2 * Math.random();
                int n4 = (int)Math.rint(d) - 50;
                d = (double)n3 * Math.random();
                int n5 = (int)Math.rint(d) - 50;
                d = 10.0 + 200.0 * Math.random();
                int n6 = (int)Math.rint(d);
                d = 10.0 + 200.0 * Math.random();
                int n7 = (int)Math.rint(d);
                for (int j = 0; j < colorArray.length; ++j) {
                    colorArray[j] = new Color((int)Math.rint(15.0 + 240.0 * Math.random()), (int)Math.rint(15.0 + 240.0 * Math.random()), (int)Math.rint(15.0 + 240.0 * Math.random()));
                }
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, colorArray[0], 0.0f, (float)n7 / 2.0f, colorArray[1], true);
                graphics2D.setPaint(gradientPaint);
                d = 2.0 * Math.random();
                if ((int)Math.rint(d) == 0) {
                    graphics2D.fillOval(n4, n5, n6, n7);
                    continue;
                }
                if ((int)Math.rint(d) == 1) {
                    graphics2D.fillRect(n4, n5, n6, n7);
                    continue;
                }
                graphics2D.setPaint(colorArray[1]);
                graphics2D.fill3DRect(n4, n5, n6, n7, true);
            }
        }
    }
}

