/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.gui.HelpFrame;
import com.dandymadeproductions.ajqvue.gui.Main_JMenuBarActions;
import com.dandymadeproductions.ajqvue.gui.panels.CSVExportPreferencesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.CSVImportPreferencesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.GeneralPreferencesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.GraphicsCanvasPanel;
import com.dandymadeproductions.ajqvue.gui.panels.PDFExportPreferencesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.PreferencesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.PreferencesPanelEarlySpring;
import com.dandymadeproductions.ajqvue.gui.panels.PreferencesPanelFall;
import com.dandymadeproductions.ajqvue.gui.panels.PreferencesPanelSpring;
import com.dandymadeproductions.ajqvue.gui.panels.PreferencesPanelSummer;
import com.dandymadeproductions.ajqvue.gui.panels.PreferencesPanelWinter;
import com.dandymadeproductions.ajqvue.gui.panels.SQLExportPreferencesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.SQLImportPreferencesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.TableFieldSelectionPreferencesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.TableRowSelectionPreferencesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

class PreferencesFrame
extends JFrame
implements ActionListener,
TreeSelectionListener {
    private static final long serialVersionUID = -9040801409709223939L;
    private JTree preferencesTree;
    private JPanel mainPanel;
    private JPanel optionsPanel;
    private JPanel tableFieldsPanel;
    private JPanel tableRowsPanel;
    private CardLayout centerCardLayout;
    private CardLayout tableFieldCardLayout;
    private CardLayout tableRowCardLayout;
    private PreferencesPanel preferencesTopPanel;
    private GeneralPreferencesPanel generalPreferencesPanel;
    private TableFieldSelectionPreferencesPanel tableFieldPreferences;
    private TableRowSelectionPreferencesPanel tableRowPreferences;
    private CSVImportPreferencesPanel csvImportPanel;
    private CSVExportPreferencesPanel csvExportPanel;
    private PDFExportPreferencesPanel pdfExportPanel;
    private SQLImportPreferencesPanel sqlImportPanel;
    private SQLExportPreferencesPanel sqlExportPanel;
    private AResourceBundle resourceBundle;
    private String resourcePreferences;
    private String resourceGeneral;
    private String resourceGeneralOptions;
    private String resourceTableSummaryView;
    private String resourceTableFields;
    private String resourceTableRows;
    private String resourceDataImport;
    private String resourceImport;
    private String resourceDataExport;
    private String resourceExport;
    private String tableName;
    private String iconsDirectory;
    private boolean helpShowing;
    private JLabel currentPreferencesSelectionLabel;
    private JComboBox<Object> tableSelectionFieldsComboBox;
    private JComboBox<Object> tableSelectionRowsComboBox;
    private ArrayList<String> tableFieldCards;
    private ArrayList<String> tableRowCards;
    private HashMap<String, TableFieldSelectionPreferencesPanel> tableFieldPanelsHashMap;
    private HashMap<String, TableRowSelectionPreferencesPanel> tableRowPanelsHashMap;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private JButton helpCloseButton;
    private transient WindowListener preferencesFrameListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            Main_JMenuBarActions.setPreferencesNotVisisble();
            PreferencesFrame.this.preferencesTopPanel.suspendPanel(true);
            ((PreferencesFrame)PreferencesFrame.this).generalPreferencesPanel.generalOptionsPanelFiller.suspendPanel(true);
            ((PreferencesFrame)PreferencesFrame.this).csvImportPanel.csvImportPanelFiller.suspendPanel(true);
            PreferencesFrame.this.dispose();
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)PreferencesFrame.this.preferencesTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            String string = defaultMutableTreeNode.getUserObject().toString();
            if (string.equals(PreferencesFrame.this.resourcePreferences)) {
                PreferencesFrame.this.preferencesTopPanel.setThreadAction(false);
            }
            if (string.equals(PreferencesFrame.this.resourceGeneralOptions)) {
                ((PreferencesFrame)PreferencesFrame.this).generalPreferencesPanel.generalOptionsPanelFiller.setThreadAction(false);
            }
            if (string.equals("CSV") && defaultMutableTreeNode.getParent().toString().equals(PreferencesFrame.this.resourceDataImport)) {
                ((PreferencesFrame)PreferencesFrame.this).csvImportPanel.csvImportPanelFiller.setThreadAction(false);
            }
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)PreferencesFrame.this.preferencesTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            String string = defaultMutableTreeNode.getUserObject().toString();
            if (string.equals(PreferencesFrame.this.resourcePreferences)) {
                PreferencesFrame.this.preferencesTopPanel.setThreadAction(true);
            }
            if (string.equals(PreferencesFrame.this.resourceGeneralOptions)) {
                ((PreferencesFrame)PreferencesFrame.this).generalPreferencesPanel.generalOptionsPanelFiller.setThreadAction(true);
            }
            if (string.equals("CSV") && defaultMutableTreeNode.getParent().toString().equals(PreferencesFrame.this.resourceDataImport)) {
                ((PreferencesFrame)PreferencesFrame.this).csvImportPanel.csvImportPanelFiller.setThreadAction(true);
            }
        }
    };

    protected PreferencesFrame() {
        Font font;
        JComponent jComponent;
        this.resourceBundle = Ajqvue.getResourceBundle();
        this.createNodeResourceNames();
        this.iconsDirectory = Utils.getIconsDirectory() + Utils.getFileSeparator();
        String string = this.resourceBundle.getResourceString("PreferencesFrame.message.Title", "Preferences");
        this.setTitle(string);
        this.setIconImage(Utils.getFrameIcon());
        this.mainPanel = new JPanel(new BorderLayout());
        this.tableFieldCards = new ArrayList();
        this.tableRowCards = new ArrayList();
        this.tableFieldPanelsHashMap = new HashMap();
        this.tableRowPanelsHashMap = new HashMap();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.resourcePreferences);
        this.createTreeNodes(defaultMutableTreeNode);
        this.preferencesTree = new JTree(defaultMutableTreeNode);
        this.preferencesTree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.preferencesTree.setEditable(false);
        this.preferencesTree.getSelectionModel().setSelectionMode(1);
        ImageIcon imageIcon = this.resourceBundle.getResourceImage(this.iconsDirectory + "preferencesLeafIcon.png");
        if (imageIcon != null) {
            jComponent = new DefaultTreeCellRenderer();
            ((DefaultTreeCellRenderer)jComponent).setLeafIcon(imageIcon);
            this.preferencesTree.setCellRenderer((TreeCellRenderer)((Object)jComponent));
        }
        this.preferencesTree.addTreeSelectionListener(this);
        jComponent = new JScrollPane(this.preferencesTree);
        jComponent.setPreferredSize(new Dimension(250, 315));
        jComponent.setAutoscrolls(true);
        jPanel.add(jComponent);
        this.mainPanel.add((Component)jPanel, "West");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        if (this.getFont() != null) {
            String string2 = this.getFont().getFontName();
            int n = this.getFont().getSize();
            font = new Font(string2, 1, n);
        } else {
            font = new Font("Serif", 1, 12);
        }
        this.currentPreferencesSelectionLabel = new JLabel(this.resourcePreferences);
        this.currentPreferencesSelectionLabel.setFont(font);
        this.currentPreferencesSelectionLabel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        jPanel2.add((Component)this.currentPreferencesSelectionLabel, "North");
        this.centerCardLayout = new CardLayout();
        this.optionsPanel = new JPanel(this.centerCardLayout);
        this.optionsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createLoweredBevelBorder()));
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(2);
        this.preferencesTopPanel = n == 11 || n == 1 || n == 0 ? new PreferencesPanelWinter() : (n >= 2 && n <= 3 ? new PreferencesPanelEarlySpring() : (n >= 4 && n <= 5 ? new PreferencesPanelSpring() : (n >= 6 && n <= 8 ? new PreferencesPanelSummer() : new PreferencesPanelFall())));
        Thread thread = new Thread((Runnable)this.preferencesTopPanel, "PreferencesTopPanel");
        thread.start();
        this.optionsPanel.add(this.resourcePreferences, this.preferencesTopPanel);
        GraphicsCanvasPanel graphicsCanvasPanel = new GraphicsCanvasPanel("GeneralPreferencesPanel.jpg");
        graphicsCanvasPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.optionsPanel.add(this.resourceGeneral, graphicsCanvasPanel);
        this.generalPreferencesPanel = new GeneralPreferencesPanel(this.resourceBundle);
        this.generalPreferencesPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        Thread thread2 = new Thread((Runnable)this.generalPreferencesPanel.generalOptionsPanelFiller, "GeneralOptionsPreferencesPanelFiller");
        thread2.start();
        this.optionsPanel.add(this.resourceGeneralOptions, this.generalPreferencesPanel);
        GraphicsCanvasPanel graphicsCanvasPanel2 = new GraphicsCanvasPanel("SummaryPreferencesPanel.jpg");
        graphicsCanvasPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        this.optionsPanel.add(this.resourceTableSummaryView, graphicsCanvasPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.createTableFieldsOptionPanel(jPanel3);
        this.tableSelectionFieldsComboBox.addActionListener(this);
        this.optionsPanel.add(this.resourceTableFields, jPanel3);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.createTableRowsOptionPanel(jPanel4);
        this.tableSelectionRowsComboBox.addActionListener(this);
        this.optionsPanel.add(this.resourceTableRows, jPanel4);
        GraphicsCanvasPanel graphicsCanvasPanel3 = new GraphicsCanvasPanel("DataImportPreferencesPanel.jpg");
        graphicsCanvasPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
        this.optionsPanel.add(this.resourceDataImport, graphicsCanvasPanel3);
        this.csvImportPanel = new CSVImportPreferencesPanel(this.resourceBundle);
        Thread thread3 = new Thread((Runnable)this.csvImportPanel.csvImportPanelFiller, "CSVImportPreferencesPanelFiller");
        thread3.start();
        this.csvImportPanel.csvImportPanelFiller.setThreadAction(true);
        this.optionsPanel.add("CSV " + this.resourceImport, this.csvImportPanel);
        if (ConnectionManager.getDataSourceType().equals("sqlserver")) {
            this.sqlImportPanel = new SQLImportPreferencesPanel(this.resourceBundle);
            this.optionsPanel.add("SQL " + this.resourceImport, this.sqlImportPanel);
        }
        GraphicsCanvasPanel graphicsCanvasPanel4 = new GraphicsCanvasPanel("DataExportPreferencesPanel.jpg");
        graphicsCanvasPanel4.setBorder(BorderFactory.createLoweredBevelBorder());
        this.optionsPanel.add(this.resourceDataExport, graphicsCanvasPanel4);
        this.csvExportPanel = new CSVExportPreferencesPanel(this.resourceBundle);
        this.optionsPanel.add("CSV " + this.resourceExport, this.csvExportPanel);
        this.pdfExportPanel = new PDFExportPreferencesPanel(this.resourceBundle);
        this.optionsPanel.add("PDF " + this.resourceExport, this.pdfExportPanel);
        this.sqlExportPanel = new SQLExportPreferencesPanel(this.resourceBundle);
        this.optionsPanel.add("SQL " + this.resourceExport, this.sqlExportPanel);
        jPanel2.add((Component)this.optionsPanel, "Center");
        this.mainPanel.add((Component)jPanel2, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createEtchedBorder());
        string = this.resourceBundle.getResourceString("PreferencesFrame.button.OK", "OK");
        this.okButton = new JButton(string);
        this.okButton.setFocusPainted(false);
        this.okButton.addActionListener(this);
        jPanel5.add(this.okButton);
        string = this.resourceBundle.getResourceString("PreferencesFrame.button.Cancel", "Cancel");
        this.cancelButton = new JButton(string);
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(this);
        jPanel5.add(this.cancelButton);
        string = this.resourceBundle.getResourceString("PreferencesFrame.button.Help", "Help");
        this.helpButton = new JButton(string);
        this.helpButton.setFocusPainted(false);
        this.helpButton.addActionListener(this);
        jPanel5.add(this.helpButton);
        this.mainPanel.add((Component)jPanel5, "South");
        this.getContentPane().add(this.mainPanel);
        this.addWindowListener(this.preferencesFrameListener);
        this.helpCloseButton = new JButton();
        this.helpCloseButton.addActionListener(this);
        this.helpShowing = false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (object == this.okButton) {
                DBTablesPanel.startStatusTimer();
                Iterator<String> iterator = this.tableFieldCards.iterator();
                while (iterator.hasNext()) {
                    this.tableFieldPanelsHashMap.get(iterator.next()).updatePreferences();
                }
                iterator = this.tableRowCards.iterator();
                while (iterator.hasNext()) {
                    this.tableRowPanelsHashMap.get(iterator.next()).updatePreferences();
                }
                Ajqvue.setGeneralProperties(this.generalPreferencesPanel.getGeneralOptions());
                DBTablesPanel.setGeneralDBProperties(this.generalPreferencesPanel.getGeneralDBOptions());
                DBTablesPanel.setDataImportProperties(this.csvImportPanel.getCSVImportOptions());
                if (this.sqlImportPanel != null) {
                    DBTablesPanel.setDataImportProperties(this.sqlImportPanel.getSQLImportOptions());
                }
                DBTablesPanel.setDataExportProperties(this.csvExportPanel.getCSVExportOptions());
                DBTablesPanel.setDataExportProperties(this.pdfExportPanel.getPDFExportOptions());
                DBTablesPanel.setDataExportProperties(this.sqlExportPanel.getSQLExportOptions());
                DBTablesPanel.stopStatusTimer();
                DBTablesPanel.setSelectedTableTabPanel((String)this.tableSelectionFieldsComboBox.getSelectedItem());
                Main_JMenuBarActions.setPreferencesNotVisisble();
                this.preferencesTopPanel.suspendPanel(true);
                this.generalPreferencesPanel.generalOptionsPanelFiller.suspendPanel(true);
                this.csvImportPanel.csvImportPanelFiller.suspendPanel(true);
                this.dispose();
            } else if (object == this.cancelButton) {
                Main_JMenuBarActions.setPreferencesNotVisisble();
                this.preferencesTopPanel.suspendPanel(true);
                this.generalPreferencesPanel.generalOptionsPanelFiller.suspendPanel(true);
                this.csvImportPanel.csvImportPanelFiller.suspendPanel(true);
                this.dispose();
            } else if (object == this.helpButton) {
                if (!this.helpShowing) {
                    HelpFrame helpFrame = new HelpFrame("Ajqvue Manual", "/docs/Manual/Ajqvue_Manual.html", this.helpCloseButton);
                    helpFrame.setSize(640, 400);
                    helpFrame.setVisible(true);
                    this.helpShowing = true;
                }
            } else if (object == this.helpCloseButton) {
                this.helpShowing = false;
            }
        } else if (object instanceof JComboBox) {
            if (object == this.tableSelectionFieldsComboBox) {
                String string = (String)this.tableSelectionFieldsComboBox.getSelectedItem();
                if (this.tableFieldCards.contains(string)) {
                    this.tableFieldCardLayout.show(this.tableFieldsPanel, string);
                } else {
                    TableTabPanel tableTabPanel = DBTablesPanel.getTableTabPanel(string);
                    if (tableTabPanel != null) {
                        string = tableTabPanel.getTableName();
                        this.tableFieldCards.add(string);
                        TableFieldSelectionPreferencesPanel tableFieldSelectionPreferencesPanel = new TableFieldSelectionPreferencesPanel(tableTabPanel, this.resourceBundle);
                        this.tableFieldsPanel.add(string, tableFieldSelectionPreferencesPanel);
                        this.tableFieldPanelsHashMap.put(string, tableFieldSelectionPreferencesPanel);
                        this.tableFieldCardLayout.show(this.tableFieldsPanel, string);
                    }
                }
                DBTablesPanel.setSelectedTableTabPanel(string);
            } else {
                String string = (String)this.tableSelectionRowsComboBox.getSelectedItem();
                if (this.tableRowCards.contains(string)) {
                    this.tableRowCardLayout.show(this.tableRowsPanel, string);
                } else {
                    TableTabPanel tableTabPanel = DBTablesPanel.getTableTabPanel(string);
                    if (tableTabPanel != null) {
                        string = tableTabPanel.getTableName();
                        this.tableRowCards.add(string);
                        TableRowSelectionPreferencesPanel tableRowSelectionPreferencesPanel = new TableRowSelectionPreferencesPanel(string, this.resourceBundle);
                        this.tableRowsPanel.add(string, tableRowSelectionPreferencesPanel);
                        this.tableRowPanelsHashMap.put(string, tableRowSelectionPreferencesPanel);
                        this.tableRowCardLayout.show(this.tableRowsPanel, string);
                    }
                }
                DBTablesPanel.setSelectedTableTabPanel(string);
            }
        } else {
            return;
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.preferencesTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        String string = defaultMutableTreeNode.getUserObject().toString();
        string = defaultMutableTreeNode.isRoot() ? defaultMutableTreeNode.getUserObject().toString() : (defaultMutableTreeNode.isLeaf() ? (defaultMutableTreeNode.getParent().toString().equals(this.resourceDataImport) ? defaultMutableTreeNode.getUserObject().toString() + " " + this.resourceImport : (defaultMutableTreeNode.getParent().toString().equals(this.resourceDataExport) ? defaultMutableTreeNode.getUserObject().toString() + " " + this.resourceExport : defaultMutableTreeNode.getUserObject().toString())) : defaultMutableTreeNode.getUserObject().toString());
        this.currentPreferencesSelectionLabel.setText(string);
        this.centerCardLayout.show(this.optionsPanel, string);
        if (string.equals(this.resourcePreferences)) {
            this.preferencesTopPanel.setThreadAction(false);
        } else {
            this.preferencesTopPanel.setThreadAction(true);
        }
        if (string.equals(this.resourceGeneralOptions)) {
            this.generalPreferencesPanel.generalOptionsPanelFiller.setThreadAction(false);
        } else {
            this.generalPreferencesPanel.generalOptionsPanelFiller.setThreadAction(true);
        }
        if (string.equals("CSV " + this.resourceImport)) {
            this.csvImportPanel.csvImportPanelFiller.setThreadAction(false);
        } else {
            this.csvImportPanel.csvImportPanelFiller.setThreadAction(true);
        }
    }

    private void createNodeResourceNames() {
        String string;
        this.resourcePreferences = string = this.resourceBundle.getResourceString("PreferencesFrame.node.Preferences", "Preferences");
        this.resourceGeneral = string = this.resourceBundle.getResourceString("PreferencesFrame.node.General", "General");
        this.resourceGeneralOptions = string = this.resourceBundle.getResourceString("PreferencesFrame.node.GeneralOptions", "Options");
        this.resourceTableSummaryView = string = this.resourceBundle.getResourceString("PreferencesFrame.node.TableSummaryView", "Table Summary View");
        this.resourceTableFields = string = this.resourceBundle.getResourceString("PreferencesFrame.node.TableFields", "Table Fields");
        this.resourceTableRows = string = this.resourceBundle.getResourceString("PreferencesFrame.node.TableRows", "Table Rows");
        this.resourceDataImport = string = this.resourceBundle.getResourceString("PreferencesFrame.node.DataImport", "Data Import");
        this.resourceImport = string = this.resourceBundle.getResourceString("PreferencesFrame.node.Import", "Import");
        this.resourceDataExport = string = this.resourceBundle.getResourceString("PreferencesFrame.node.DataExport", "Data Export");
        this.resourceExport = string = this.resourceBundle.getResourceString("PreferencesFrame.node.Export", "Export");
    }

    private void createTreeNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.resourceGeneral);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(this.resourceGeneralOptions);
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        DefaultMutableTreeNode defaultMutableTreeNode4 = null;
        defaultMutableTreeNode4 = new DefaultMutableTreeNode(this.resourceTableSummaryView);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(this.resourceTableFields);
        defaultMutableTreeNode4.add(defaultMutableTreeNode5);
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(this.resourceTableRows);
        defaultMutableTreeNode4.add(defaultMutableTreeNode6);
        DefaultMutableTreeNode defaultMutableTreeNode7 = null;
        defaultMutableTreeNode7 = new DefaultMutableTreeNode(this.resourceDataImport);
        defaultMutableTreeNode.add(defaultMutableTreeNode7);
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode("CSV");
        defaultMutableTreeNode7.add(defaultMutableTreeNode8);
        if (ConnectionManager.getDataSourceType().equals("sqlserver")) {
            DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode("SQL");
            defaultMutableTreeNode7.add(defaultMutableTreeNode9);
        }
        DefaultMutableTreeNode defaultMutableTreeNode10 = null;
        defaultMutableTreeNode10 = new DefaultMutableTreeNode(this.resourceDataExport);
        defaultMutableTreeNode.add(defaultMutableTreeNode10);
        DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode("CSV");
        defaultMutableTreeNode10.add(defaultMutableTreeNode11);
        DefaultMutableTreeNode defaultMutableTreeNode12 = new DefaultMutableTreeNode("PDF");
        defaultMutableTreeNode10.add(defaultMutableTreeNode12);
        DefaultMutableTreeNode defaultMutableTreeNode13 = new DefaultMutableTreeNode("SQL");
        defaultMutableTreeNode10.add(defaultMutableTreeNode13);
    }

    private void createTableFieldsOptionPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 0, 0));
        String string = this.resourceBundle.getResourceString("PreferencesFrame.label.TableSelection", "Table Selection");
        JLabel jLabel = new JLabel(string, 0);
        jPanel2.add(jLabel);
        this.tableSelectionFieldsComboBox = new JComboBox<Object>(ConnectionManager.getTableNames().toArray());
        jPanel2.add(this.tableSelectionFieldsComboBox);
        jPanel.add((Component)jPanel2, "North");
        this.tableFieldCardLayout = new CardLayout();
        this.tableFieldsPanel = new JPanel(this.tableFieldCardLayout);
        TableTabPanel tableTabPanel = DBTablesPanel.getSelectedTableTabPanel();
        if (tableTabPanel == null) {
            return;
        }
        this.tableName = tableTabPanel.getTableName();
        this.tableFieldCards.add(this.tableName);
        this.tableSelectionFieldsComboBox.setSelectedItem(this.tableName);
        this.tableFieldPreferences = new TableFieldSelectionPreferencesPanel(tableTabPanel, this.resourceBundle);
        this.tableFieldsPanel.add(this.tableName, this.tableFieldPreferences);
        this.tableFieldPanelsHashMap.put(this.tableName, this.tableFieldPreferences);
        jPanel.add((Component)this.tableFieldsPanel, "Center");
    }

    private void createTableRowsOptionPanel(JPanel jPanel) {
        String string;
        String string2 = string = this.resourceBundle.getResourceString("PreferencesFrame.message.Warning", "WARNING");
        string = this.resourceBundle.getResourceString("PreferencesFrame.message.RowSizeWarning", "A large row size may adversely effect this application and the database server performance. It is recommended that a reasonable row size be selected based on special needs such as CSV/SQL exports. A basic paging mechanism is in place for each table summary view that already allows access to all table data.");
        String string3 = "<html><body><p><span style='color: rgb(255, 0, 0);'>" + string2 + " </span>" + string + "</p></body></html>";
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 0, 0));
        string = this.resourceBundle.getResourceString("PreferencesFrame.label.TableSelection", "Table Selection");
        JLabel jLabel = new JLabel(string, 0);
        jPanel2.add(jLabel);
        this.tableSelectionRowsComboBox = new JComboBox<Object>(ConnectionManager.getTableNames().toArray());
        jPanel2.add(this.tableSelectionRowsComboBox);
        jPanel.add((Component)jPanel2, "North");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel3 = new JPanel(gridBagLayout);
        JEditorPane jEditorPane = new JEditorPane("text/html", string3);
        jEditorPane.setMargin(new Insets(10, 15, 10, 10));
        jEditorPane.setBackground(jPanel3.getBackground());
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jEditorPane, gridBagConstraints);
        jPanel3.add(jEditorPane);
        this.tableRowCardLayout = new CardLayout();
        this.tableRowsPanel = new JPanel(this.tableRowCardLayout);
        if (this.tableName == null) {
            return;
        }
        this.tableRowCards.add(this.tableName);
        this.tableSelectionRowsComboBox.setSelectedItem(this.tableName);
        this.tableRowPreferences = new TableRowSelectionPreferencesPanel(this.tableName, this.resourceBundle);
        this.tableRowsPanel.add(this.tableName, this.tableRowPreferences);
        this.tableRowPanelsHashMap.put(this.tableName, this.tableRowPreferences);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.tableRowsPanel, gridBagConstraints);
        this.mainPanel.add(this.tableRowsPanel);
        jPanel3.add(this.tableRowsPanel);
        jPanel.add((Component)jPanel3, "Center");
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    protected void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n, n2);
    }
}

