/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.gui.Main_Frame;
import com.dandymadeproductions.ajqvue.gui.Main_JMenuBarActions;
import com.dandymadeproductions.ajqvue.gui.panels.PluginFrameFillerPanel;
import com.dandymadeproductions.ajqvue.gui.panels.PluginRepositoryPanel;
import com.dandymadeproductions.ajqvue.io.ReadDataFile;
import com.dandymadeproductions.ajqvue.io.WriteDataFile;
import com.dandymadeproductions.ajqvue.plugin.FILE_PluginRepository;
import com.dandymadeproductions.ajqvue.plugin.FTP_PluginRepository;
import com.dandymadeproductions.ajqvue.plugin.HTTP_PluginRepository;
import com.dandymadeproductions.ajqvue.plugin.PluginLoader;
import com.dandymadeproductions.ajqvue.plugin.PluginRepository;
import com.dandymadeproductions.ajqvue.plugin.Plugin_Module;
import com.dandymadeproductions.ajqvue.structures.GeneralProperties;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.GzFileFilter;
import com.dandymadeproductions.ajqvue.utilities.InputDialog;
import com.dandymadeproductions.ajqvue.utilities.JarFileFilter;
import com.dandymadeproductions.ajqvue.utilities.TableModel;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.text.html.HTMLEditorKit;

public class PluginFrame
extends JFrame
implements ActionListener,
ChangeListener,
ListSelectionListener,
MouseListener {
    private static final long serialVersionUID = 4445791721456804647L;
    private Main_Frame parentFrame;
    private transient GeneralProperties generalProperties;
    private JPanel mainPanel;
    private PluginFrameFillerPanel northFillerPanel;
    private JSplitPane splitPane;
    private JTabbedPane centralTabsPane;
    private CardLayout infoViewCardLayout;
    private JPanel infoViewPanel;
    private JTable loadedPluginsTable;
    private JTable loadingPluginTable;
    private TableModel loadedPluginsTableModel;
    private TableModel loadingPluginsTableModel;
    private Object[][] loadedPluginTableData;
    private Object[][] loadingPluginTableData;
    private Vector<String> loadingPluginsList;
    private Hashtable<String, String> repositoryHashtable;
    private JTextPane pluginInformationTextPane;
    private JTextField repositoryURLTextField;
    private JButton openRepositoryButton;
    private JButton installButton;
    private JButton closeButton;
    private JButton proxyButton;
    private JButton refreshButton;
    private AResourceBundle resourceBundle;
    private String fileSeparator;
    private String iconsDirectory;
    private String resourceAlert;
    private String resourceOK;
    private String resourceCancel;
    private ImageIcon statusWorkingIcon;
    private ImageIcon addRepositoryIcon;
    private ImageIcon deleteRepositoryIcon;
    private ImageIcon defaultModuleIcon;
    private ImageIcon removeIcon;
    private String tabType;
    private int currentTabIndex;
    private int removeTabIndex;
    private int addTabIndex;
    private StringBuffer lastPluginDirectory;
    private GridBagLayout gridbag;
    private GridBagConstraints constraints;
    private static final String MANAGE = "manage";
    private static final String REPOSITORY = "repository";
    private static final String INFO_VIEW_LOADING_STATUS = "Loading Status";
    private static final String INFO_VIEW_PLUGIN_INFORMATION = "Plugin Information";
    private static final int TABICON_COLUMN = 0;
    private static final int NAME_COLUMN = 1;
    private static final int VERSION_COLUMN = 2;
    private static final int REMOVE_COLUMN = 3;
    private static final int AUTHOR_COLUMN = 4;
    private static final int PATH_COLUMN = 5;
    private static final int DESCRIPTION_COLUMN = 6;
    private static boolean LOAD_DEFAULT_REPOSITORY = false;
    private static final String REPOSITORY_NAME = "Ajqvue";
    private static final String REPOSITORY_HTTP = "http://plugins.ajqvue.com/";
    private static final String PLUGIN_CONFIGURATION_FILE = "ajqvue_plugin.conf";
    private transient WindowListener pluginFrameListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            Main_JMenuBarActions.setPluginFrameNotVisisble();
            PluginFrame.this.dispose();
        }
    };

    protected PluginFrame(Main_Frame main_Frame) {
        this.parentFrame = main_Frame;
        this.setIconImage(Utils.getFrameIcon());
        this.resourceBundle = Ajqvue.getResourceBundle();
        this.fileSeparator = Utils.getFileSeparator();
        this.iconsDirectory = Utils.getIconsDirectory() + this.fileSeparator;
        this.resourceAlert = this.resourceBundle.getResourceString("PluginFrame.dialogtitle.Alert", "Alert");
        this.resourceOK = this.resourceBundle.getResourceString("PluginFrame.dialogbutton.OK", "OK");
        this.resourceCancel = this.resourceBundle.getResourceString("PluginFrame.dialogbutton.Cancel", "Cancel");
        this.statusWorkingIcon = this.resourceBundle.getResourceImage(this.iconsDirectory + "statusWorkingIcon.png");
        this.removeIcon = this.resourceBundle.getResourceImage(this.iconsDirectory + "removeIcon.png");
        this.addRepositoryIcon = this.resourceBundle.getResourceImage(this.iconsDirectory + "addRepositoryIcon.gif");
        this.deleteRepositoryIcon = this.resourceBundle.getResourceImage(this.iconsDirectory + "deleteDataIcon.gif");
        this.defaultModuleIcon = this.resourceBundle.getResourceImage(this.iconsDirectory + "newsiteLeafIcon.png");
        this.generalProperties = Ajqvue.getGeneralProperties();
        this.repositoryHashtable = new Hashtable();
        this.loadingPluginsList = new Vector();
        this.lastPluginDirectory = new StringBuffer();
        String string = this.resourceBundle.getResourceString("PluginFrame.title.PluginManagement", "Plugin Management");
        this.setTitle(string);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.gridbag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.addWindowListener(this.pluginFrameListener);
        this.northFillerPanel = new PluginFrameFillerPanel();
        this.mainPanel.add((Component)this.northFillerPanel, "North");
        this.centralTabsPane = new JTabbedPane();
        this.centralTabsPane.setTabPlacement(1);
        this.centralTabsPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.centralTabsPane.setTabLayoutPolicy(1);
        this.splitPane = new JSplitPane(0, false);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setResizeWeight(0.65);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PluginFrame.this.splitPane.setDividerLocation(0.65);
            }
        });
        JPanel jPanel = this.createInstalledPluginsViewPanel(Main_Frame.getPlugins());
        string = this.resourceBundle.getResourceString("PluginFrame.tab.Manage", "Manage");
        this.centralTabsPane.addTab(string, null, jPanel, string);
        ImageIcon imageIcon = this.resourceBundle.getResourceImage(this.iconsDirectory + "minusIcon.png");
        string = this.resourceBundle.getResourceString("PluginFrame.tab.RemoveRepository", "Remove Repository");
        this.centralTabsPane.addTab(null, imageIcon, new JPanel(), string);
        this.removeTabIndex = this.centralTabsPane.getTabCount() - 1;
        ImageIcon imageIcon2 = this.resourceBundle.getResourceImage(this.iconsDirectory + "plusIcon.png");
        string = this.resourceBundle.getResourceString("PluginFrame.tab.AddRepository", "Add Repository");
        this.centralTabsPane.addTab(null, imageIcon2, new JPanel(), string);
        this.addTabIndex = this.centralTabsPane.getTabCount() - 1;
        if (LOAD_DEFAULT_REPOSITORY) {
            this.createRepository(REPOSITORY_NAME, REPOSITORY_HTTP);
        }
        this.loadCachedRepositories();
        this.tabType = MANAGE;
        this.currentTabIndex = 0;
        this.centralTabsPane.setSelectedIndex(0);
        this.splitPane.setTopComponent(this.centralTabsPane);
        this.infoViewCardLayout = new CardLayout();
        this.infoViewPanel = new JPanel(this.infoViewCardLayout);
        this.infoViewPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createLoweredBevelBorder()));
        JPanel jPanel2 = this.createLoadingPluginsViewPanel();
        this.infoViewPanel.add(INFO_VIEW_LOADING_STATUS, jPanel2);
        this.pluginInformationTextPane = new JTextPane();
        this.pluginInformationTextPane.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.pluginInformationTextPane.setEditorKit(new HTMLEditorKit());
        this.pluginInformationTextPane.setEditable(false);
        this.pluginInformationTextPane.addMouseListener(Ajqvue.getPopupMenuListener());
        JScrollPane jScrollPane = new JScrollPane(this.pluginInformationTextPane);
        this.infoViewPanel.add(INFO_VIEW_PLUGIN_INFORMATION, jScrollPane);
        this.splitPane.setBottomComponent(this.infoViewPanel);
        this.mainPanel.add((Component)this.splitPane, "Center");
        JPanel jPanel3 = new JPanel(this.gridbag);
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEmptyBorder());
        string = this.resourceBundle.getResourceString("PluginFrame.button.Install", "Install");
        this.installButton = new JButton(string);
        this.installButton.setFocusPainted(false);
        this.installButton.addActionListener(this);
        jPanel4.add(this.installButton);
        string = this.resourceBundle.getResourceString("PluginFrame.button.Close", "Close");
        this.closeButton = new JButton(string);
        this.closeButton.setFocusPainted(false);
        this.closeButton.addActionListener(this);
        jPanel4.add(this.closeButton);
        Utils.buildConstraints(this.constraints, 0, 0, 1, 1, 90.0, 100.0);
        this.constraints.fill = 1;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jPanel4, this.constraints);
        jPanel3.add(jPanel4);
        string = this.resourceBundle.getResourceString("PluginFrame.button.RefreshRepository", "Refresh Repository");
        ImageIcon imageIcon3 = this.resourceBundle.getResourceImage(this.iconsDirectory + "refreshIcon.png");
        this.refreshButton = new JButton(imageIcon3);
        this.refreshButton.setToolTipText(string);
        this.refreshButton.setMargin(new Insets(0, 0, 0, 0));
        this.refreshButton.addActionListener(this);
        Utils.buildConstraints(this.constraints, 1, 0, 1, 1, 5.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.gridbag.setConstraints(this.refreshButton, this.constraints);
        jPanel3.add(this.refreshButton);
        string = this.resourceBundle.getResourceString("PluginFrame.button.Proxy", "Proxy");
        ImageIcon imageIcon4 = this.resourceBundle.getResourceImage(this.iconsDirectory + "connectionProxyIcon.png");
        this.proxyButton = new JButton(imageIcon4);
        this.proxyButton.setEnabled(true);
        this.proxyButton.setToolTipText(string);
        this.proxyButton.setMargin(new Insets(0, 0, 0, 0));
        this.proxyButton.addActionListener(this);
        Utils.buildConstraints(this.constraints, 2, 0, 1, 1, 5.0, 100.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(this.proxyButton, this.constraints);
        jPanel3.add(this.proxyButton);
        this.mainPanel.add((Component)jPanel3, "South");
        this.centralTabsPane.addChangeListener(this);
        this.getContentPane().add(this.mainPanel);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (object == this.installButton) {
                this.infoViewCardLayout.show(this.infoViewPanel, INFO_VIEW_LOADING_STATUS);
                if (this.tabType.equals(MANAGE)) {
                    String string = this.optainFile(this, true).toString();
                    if (!string.isEmpty()) {
                        this.loadPlugin(string, "", "file", null);
                    }
                } else {
                    Component component = this.centralTabsPane.getSelectedComponent();
                    if (component != null && component instanceof PluginRepositoryPanel) {
                        PluginRepositoryPanel pluginRepositoryPanel = (PluginRepositoryPanel)component;
                        String string = pluginRepositoryPanel.getRepositoryName();
                        String string2 = pluginRepositoryPanel.getRepositoryType();
                        String string3 = pluginRepositoryPanel.getSelectedPluginPath();
                        if (Ajqvue.getDebug()) {
                            System.out.println("PluginFrame actionPerformed() repositoryType: " + string2 + " selectedPluginPath: " + string3);
                        }
                        if (string3 == null || string3.isEmpty()) {
                            String string4 = this.resourceBundle.getResourceString("PluginFrame.dialogmessage.SelectedPathEmpty", "Selected Path Empty");
                            JOptionPane.showMessageDialog(null, string4, this.resourceAlert, 0);
                            return;
                        }
                        if (string2.equals("file") || string2.equals("ftp") || string2.equals("ftps") || string2.equals("http") || string2.equals("https")) {
                            this.loadPlugin(string3, string, string2, pluginRepositoryPanel.getRepositoryOptions());
                        } else {
                            System.out.println("Unknown Repository Install");
                        }
                    }
                }
            } else if (object == Main_Frame.pluginFrameListenButton) {
                Main_Frame.pluginFrameListenButton.removeActionListener(this);
                this.generateLoadedPluginsList(Main_Frame.getPlugins());
                this.loadedPluginsTableModel.setValues(this.loadedPluginTableData);
                this.displayLoadingPluginsData();
            } else if (object == this.proxyButton) {
                this.setProxy();
            } else if (object == this.refreshButton) {
                Component component;
                if (!this.tabType.equals(MANAGE) && (component = this.centralTabsPane.getSelectedComponent()) != null && component instanceof PluginRepositoryPanel) {
                    PluginRepositoryPanel pluginRepositoryPanel = (PluginRepositoryPanel)component;
                    pluginRepositoryPanel.refreshRepository();
                    this.pluginInformationTextPane.setText("");
                }
            } else if (object == this.openRepositoryButton) {
                String string = this.optainFile(this, false).toString();
                if (!string.isEmpty()) {
                    this.repositoryURLTextField.setText(string);
                }
            } else {
                Main_JMenuBarActions.setPluginFrameNotVisisble();
                this.dispose();
            }
        } else {
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object != null && (JTabbedPane)object == this.centralTabsPane) {
            int n = ((JTabbedPane)object).getSelectedIndex();
            this.centralTabsPane.removeChangeListener(this);
            if (n > this.centralTabsPane.getTabCount()) {
                return;
            }
            if (n == 0) {
                this.tabType = MANAGE;
                this.currentTabIndex = 0;
            } else if (n > 0 && n < this.removeTabIndex) {
                this.tabType = REPOSITORY;
                this.currentTabIndex = n;
            } else if (n == this.removeTabIndex) {
                if (this.centralTabsPane.getTabCount() > 3 && this.currentTabIndex != 0) {
                    this.removeRepository();
                }
                this.tabType = MANAGE;
                this.centralTabsPane.setSelectedIndex(0);
                this.currentTabIndex = 0;
            } else if (n == this.addTabIndex) {
                this.addRepository();
            } else {
                if (Ajqvue.getDebug()) {
                    System.out.println("PluginFrame stateChanged() Tab Tracking Error.");
                }
                return;
            }
            if (this.tabType.equals(MANAGE)) {
                this.loadedPluginsTable.clearSelection();
                this.pluginInformationTextPane.setText("");
                this.infoViewCardLayout.show(this.infoViewPanel, INFO_VIEW_LOADING_STATUS);
            } else if (this.tabType.equals(REPOSITORY)) {
                this.pluginInformationTextPane.setText("");
                Component component = this.centralTabsPane.getSelectedComponent();
                if (component != null && component instanceof PluginRepositoryPanel) {
                    PluginRepositoryPanel pluginRepositoryPanel = (PluginRepositoryPanel)component;
                    this.displayPluginInfo(pluginRepositoryPanel.getSelectedPluginInfo());
                }
                this.infoViewCardLayout.show(this.infoViewPanel, INFO_VIEW_PLUGIN_INFORMATION);
            }
            this.centralTabsPane.addChangeListener(this);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.tabType.equals(MANAGE)) {
            int n = this.loadedPluginsTable.getSelectedRow();
            if (n >= this.loadedPluginsTable.getRowCount() || n < 0) {
                return;
            }
            Object[] objectArray = new Object[]{this.loadedPluginTableData[n][1], this.loadedPluginTableData[n][4], this.loadedPluginTableData[n][2], this.loadedPluginTableData[n][5], this.loadedPluginTableData[n][6]};
            this.displayPluginInfo(objectArray);
        } else {
            Component component = this.centralTabsPane.getSelectedComponent();
            if (component != null && component instanceof PluginRepositoryPanel) {
                PluginRepositoryPanel pluginRepositoryPanel = (PluginRepositoryPanel)component;
                this.displayPluginInfo(pluginRepositoryPanel.getSelectedPluginInfo());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.loadedPluginsTable.rowAtPoint(point);
        int n2 = this.loadedPluginsTable.columnAtPoint(point);
        if (n >= this.loadedPluginsTable.getRowCount() || n < 0) {
            return;
        }
        if (n2 == 3) {
            final Plugin_Module plugin_Module = Main_Frame.getPlugins().get(n);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    PluginFrame.removePluginConfigurationModule(plugin_Module.getPath_FileName());
                }
            }, "PluginFrame.removePluginConfigurationModuleThread");
            thread.start();
            plugin_Module.shutdown();
            Main_Frame.removeTab(n);
            this.generateLoadedPluginsList(Main_Frame.getPlugins());
            this.loadedPluginsTableModel.setValues(this.loadedPluginTableData);
            this.pluginInformationTextPane.setText("");
        }
    }

    private void setProxy() {
        JPanel jPanel = new JPanel(this.gridbag);
        String string = this.resourceBundle.getResourceString("PluginFrame.message.CreateProxy", "Create Proxy");
        String string2 = this.resourceBundle.getResourceString("PluginFrame.label.Address", "Address");
        JLabel jLabel = new JLabel(string2);
        Utils.buildConstraints(this.constraints, 0, 0, 1, 1, 100.0, 20.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jLabel, this.constraints);
        jPanel.add(jLabel);
        JTextField jTextField = this.generalProperties.getProxyAddress() != null && !this.generalProperties.getProxyAddress().isEmpty() ? new JTextField(this.generalProperties.getProxyAddress()) : new JTextField("127.0.0.1");
        jTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createLoweredBevelBorder()));
        jTextField.addMouseListener(Ajqvue.getPopupMenuListener());
        Utils.buildConstraints(this.constraints, 0, 1, 1, 1, 100.0, 20.0);
        this.constraints.fill = 2;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jTextField, this.constraints);
        jPanel.add(jTextField);
        string2 = this.resourceBundle.getResourceString("PluginFrame.label.Port", "Port");
        JLabel jLabel2 = new JLabel(string2);
        Utils.buildConstraints(this.constraints, 0, 2, 2, 1, 100.0, 20.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jLabel2, this.constraints);
        jPanel.add(jLabel2);
        JTextField jTextField2 = this.generalProperties.getProxyPort() != 0 ? new JTextField(this.generalProperties.getProxyPort() + "") : new JTextField("80");
        jTextField2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createLoweredBevelBorder()));
        jTextField2.addMouseListener(Ajqvue.getPopupMenuListener());
        Utils.buildConstraints(this.constraints, 0, 3, 1, 1, 100.0, 20.0);
        this.constraints.fill = 2;
        this.constraints.anchor = 21;
        this.gridbag.setConstraints(jTextField2, this.constraints);
        jPanel.add(jTextField2);
        string2 = this.resourceBundle.getResourceString("PluginFrame.label.EnableProxy", "Enable Proxy");
        JCheckBox jCheckBox = new JCheckBox(string2, this.generalProperties.getEnableProxy());
        Utils.buildConstraints(this.constraints, 0, 4, 1, 1, 100.0, 20.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jCheckBox, this.constraints);
        jPanel.add(jCheckBox);
        Object[] objectArray = new Object[]{jPanel};
        InputDialog inputDialog = new InputDialog(null, string, this.resourceOK, this.resourceCancel, objectArray, null);
        inputDialog.pack();
        inputDialog.setSize(new Dimension(400, 200));
        inputDialog.setResizable(true);
        inputDialog.center();
        inputDialog.setVisible(true);
        if (inputDialog.isActionResult()) {
            if (jCheckBox.isSelected()) {
                boolean bl = false;
                String string3 = jTextField.getText().trim();
                int n = 0;
                try {
                    InetSocketAddress inetSocketAddress;
                    if (string3.isEmpty()) {
                        throw new IllegalArgumentException("Empty String");
                    }
                    n = Integer.parseInt(jTextField2.getText().trim());
                    if (n < 0) {
                        n = 0;
                    }
                    if ((inetSocketAddress = new InetSocketAddress(string3, n)).isUnresolved()) {
                        throw new IllegalArgumentException("Unresolved");
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    JOptionPane.showMessageDialog(null, illegalArgumentException.toString(), this.resourceAlert, 0);
                    bl = true;
                }
                this.generalProperties.setEnableProxy(!bl);
                if (!bl) {
                    this.generalProperties.setProxyAddress(string3);
                    this.generalProperties.setProxyPort(n);
                }
            } else {
                this.generalProperties.setEnableProxy(false);
            }
        }
        inputDialog.dispose();
    }

    private StringBuffer optainFile(JFrame jFrame, boolean bl) {
        String string = bl ? this.lastPluginDirectory.toString() : "";
        JFileChooser jFileChooser = string.isEmpty() ? new JFileChooser() : new JFileChooser(new File(string));
        if (bl) {
            jFileChooser.setFileFilter(new JarFileFilter());
        } else {
            jFileChooser.setFileFilter(new GzFileFilter());
        }
        int n = jFileChooser.showOpenDialog(jFrame);
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 0) {
            stringBuffer.append(jFileChooser.getSelectedFile().getName());
            if (bl) {
                this.lastPluginDirectory.delete(0, this.lastPluginDirectory.length());
                this.lastPluginDirectory.append(jFileChooser.getCurrentDirectory());
            }
            if (!stringBuffer.toString().isEmpty()) {
                if (bl) {
                    stringBuffer.insert(0, "file:" + this.lastPluginDirectory + this.fileSeparator);
                } else {
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append("file:" + jFileChooser.getCurrentDirectory() + this.fileSeparator);
                }
            } else {
                String string2 = this.resourceBundle.getResourceString("PluginFrame.dialogmessage.FileNOTFound", "File NOT Found");
                JOptionPane.showMessageDialog(null, string2, this.resourceAlert, 0);
                stringBuffer.delete(0, stringBuffer.length());
            }
        }
        return stringBuffer;
    }

    private void loadPlugin(String string, String string2, String string3, String[] stringArray) {
        Main_Frame.pluginFrameListenButton.addActionListener(this);
        try {
            if (string3.equals("ftps")) {
                new PluginLoader(this.parentFrame, new URL("ftp" + string.substring(4)), string2, string3, stringArray);
            } else {
                new PluginLoader(this.parentFrame, new URL(string), string2, string3, stringArray);
            }
            this.loadingPluginsList.add(string);
            this.displayLoadingPluginsData();
        }
        catch (MalformedURLException malformedURLException) {
            String string4 = this.resourceBundle.getResourceString("PluginFrame.dialogmessage.FailedToCreateURL", "Failed to Create URL");
            JOptionPane.showMessageDialog(null, string4 + "\n" + malformedURLException.toString(), this.resourceAlert, 0);
        }
    }

    private void generateLoadedPluginsList(ArrayList<Plugin_Module> arrayList) {
        this.loadedPluginTableData = new Object[arrayList.size()][7];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.loadedPluginTableData[i][0] = arrayList.get(i).getTabIcon() == null || arrayList.get(i).getTabIcon().getIconWidth() <= 0 ? this.defaultModuleIcon : arrayList.get(i).getControlledTabIcon();
            this.loadedPluginTableData[i][1] = arrayList.get(i).getControlledName();
            this.loadedPluginTableData[i][4] = arrayList.get(i).getControlledAuthor();
            this.loadedPluginTableData[i][2] = arrayList.get(i).getControlledVersion();
            this.loadedPluginTableData[i][5] = arrayList.get(i).getPath_FileName();
            this.loadedPluginTableData[i][6] = arrayList.get(i).getDescription();
            this.loadedPluginTableData[i][3] = this.removeIcon;
            String string = arrayList.get(i).getPath_FileName().substring(0, arrayList.get(i).getPath_FileName().indexOf("<$$$>"));
            for (int j = 0; j < this.loadingPluginsList.size(); ++j) {
                String string2 = this.loadingPluginsList.get(j);
                if (string2.indexOf(this.fileSeparator) != -1) {
                    string2 = string2.substring(string2.lastIndexOf(this.fileSeparator) + 1, string2.length());
                }
                if (string.indexOf(string2) == -1) continue;
                this.loadingPluginsList.remove(j++);
            }
        }
    }

    private void displayPluginInfo(Object[] objectArray) {
        if (objectArray == null || objectArray.length != 5) {
            return;
        }
        String string = "";
        if (objectArray[0] != null) {
            string = string + "<b>Name: </b>" + objectArray[0] + "<br>";
        }
        if (objectArray[1] != null) {
            string = string + "<b>Author: </b>" + objectArray[1] + "<br>";
        }
        if (objectArray[2] != null) {
            string = string + "<b>Version: </b>" + objectArray[2] + "<br><br>";
        }
        if (objectArray[3] != null) {
            String string2 = objectArray[3].toString();
            if (string2.indexOf("<$$$>") != -1) {
                string2 = string2.substring(0, string2.indexOf("<$$$>"));
            }
            string = string + "<b>Path: </b>" + string2 + "<br><br>";
        }
        string = string + "<b>Description: </b><br>";
        if (objectArray[4] != null) {
            string = string + objectArray[4];
        }
        string = string.replace("\n", "<br>");
        string = "<html>" + string + "</html>";
        this.pluginInformationTextPane.setText(string);
        this.pluginInformationTextPane.setCaretPosition(0);
        this.infoViewCardLayout.show(this.infoViewPanel, INFO_VIEW_PLUGIN_INFORMATION);
    }

    private void displayLoadingPluginsData() {
        this.loadingPluginTableData = new Object[this.loadingPluginsList.size()][2];
        for (int i = 0; i < this.loadingPluginsList.size(); ++i) {
            this.loadingPluginTableData[i][0] = this.statusWorkingIcon;
            this.loadingPluginTableData[i][1] = this.loadingPluginsList.get(i);
        }
        if (this.loadingPluginsTableModel != null) {
            this.loadingPluginsTableModel.setValues(this.loadingPluginTableData);
        }
    }

    private void removeRepository() {
        String string = this.resourceBundle.getResourceString("PluginFrame.message.DeleteRepository", "Delete Repository?");
        JLabel jLabel = new JLabel(string, 0);
        jLabel.setFont(new Font("DIALOG", 1, 14));
        jLabel.setForeground(Color.RED);
        Object[] objectArray = new Object[]{jLabel};
        InputDialog inputDialog = new InputDialog(null, this.resourceAlert, this.resourceOK, this.resourceCancel, objectArray, this.deleteRepositoryIcon);
        inputDialog.pack();
        inputDialog.center();
        inputDialog.setResizable(false);
        inputDialog.setVisible(true);
        if (inputDialog.isActionResult()) {
            final String string2 = this.centralTabsPane.getTitleAt(this.currentTabIndex);
            if (!string2.equals(REPOSITORY_NAME) || !LOAD_DEFAULT_REPOSITORY) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        PluginFrame.this.deleteRepositoryCache(Utils.getCacheDirectory() + string2);
                    }
                }, "PluginFrame.deleteRepositoryCacheThread");
                thread.start();
            }
            this.repositoryHashtable.remove(string2);
            this.centralTabsPane.removeTabAt(this.currentTabIndex);
            --this.removeTabIndex;
            --this.addTabIndex;
        }
        inputDialog.dispose();
    }

    private void deleteRepositoryCache(String string) {
        File file = new File(string);
        boolean bl = false;
        if (file.exists() && file.isDirectory()) {
            block6: {
                try {
                    File[] fileArray = file.listFiles();
                    if (fileArray != null) {
                        for (int i = 0; i < fileArray.length; ++i) {
                            boolean bl2;
                            if (!fileArray[i].isFile() || (bl2 = fileArray[i].delete())) continue;
                            bl = true;
                        }
                    }
                    bl = !file.delete();
                }
                catch (SecurityException securityException) {
                    if (!Ajqvue.getDebug()) break block6;
                    System.out.println("PluginFrame deleteRepositoryCache() Failed to Clear Repository Cache: " + securityException.toString());
                }
            }
            if (bl && Ajqvue.getDebug()) {
                System.out.println("PluginFrame deleteRepositoryCache() Failed to Clear Repository Cache.");
            }
        }
    }

    private void addRepository() {
        JPanel jPanel = new JPanel(this.gridbag);
        String string = this.resourceBundle.getResourceString("PluginFrame.message.AddRepository", "Add Repository");
        String string2 = this.resourceBundle.getResourceString("PluginFrame.label.RepositoryName", "Repository Name");
        JLabel jLabel = new JLabel(string2, 0);
        Utils.buildConstraints(this.constraints, 0, 0, 2, 1, 0.0, 25.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jLabel, this.constraints);
        jPanel.add(jLabel);
        JTextField jTextField = new JTextField(REPOSITORY_NAME);
        jTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createLoweredBevelBorder()));
        jTextField.addMouseListener(Ajqvue.getPopupMenuListener());
        Utils.buildConstraints(this.constraints, 0, 1, 2, 1, 0.0, 25.0);
        this.constraints.fill = 2;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jTextField, this.constraints);
        jPanel.add(jTextField);
        string2 = this.resourceBundle.getResourceString("PluginFrame.label.RepositoryURL", "Repository URL");
        JLabel jLabel2 = new JLabel(string2);
        Utils.buildConstraints(this.constraints, 0, 2, 2, 1, 0.0, 25.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jLabel2, this.constraints);
        jPanel.add(jLabel2);
        this.repositoryURLTextField = new JTextField(REPOSITORY_HTTP);
        this.repositoryURLTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createLoweredBevelBorder()));
        this.repositoryURLTextField.addMouseListener(Ajqvue.getPopupMenuListener());
        Utils.buildConstraints(this.constraints, 0, 3, 1, 1, 95.0, 25.0);
        this.constraints.fill = 2;
        this.constraints.anchor = 21;
        this.gridbag.setConstraints(this.repositoryURLTextField, this.constraints);
        jPanel.add(this.repositoryURLTextField);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        string2 = this.resourceBundle.getResourceString("PluginFrame.button.Browse", "Browse");
        ImageIcon imageIcon = this.resourceBundle.getResourceImage(this.iconsDirectory + "openIcon_20x20.png");
        this.openRepositoryButton = new JButton(imageIcon);
        this.openRepositoryButton.setFocusable(false);
        this.openRepositoryButton.setMargin(new Insets(0, 0, 0, 0));
        this.openRepositoryButton.setToolTipText(string2);
        this.openRepositoryButton.addActionListener(this);
        jPanel2.add(this.openRepositoryButton);
        Utils.buildConstraints(this.constraints, 1, 3, 1, 1, 5.0, 0.0);
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.gridbag.setConstraints(jPanel2, this.constraints);
        jPanel.add(jPanel2);
        Object[] objectArray = new Object[]{jPanel};
        InputDialog inputDialog = new InputDialog(null, string, this.resourceOK, this.resourceCancel, objectArray, this.addRepositoryIcon);
        inputDialog.pack();
        inputDialog.setResizable(true);
        inputDialog.center();
        inputDialog.setVisible(true);
        if (inputDialog.isActionResult()) {
            String string3 = jTextField.getText().trim();
            if (string3.indexOf(" ") != -1) {
                string3 = string3.replaceAll(" ", "_");
            }
            if (string3.indexOf("//") != -1) {
                string3 = string3.replaceAll("//", "");
            }
            if (string3.indexOf("/") != -1) {
                string3 = string3.replaceAll("/", "");
            }
            if (!this.repositoryHashtable.containsKey(string3) && !string3.isEmpty()) {
                this.createRepository(string3, this.repositoryURLTextField.getText());
            } else {
                this.centralTabsPane.setSelectedIndex(0);
                string2 = this.resourceBundle.getResourceString("PluginFrame.dialogmessage.RepositoryExists", "Repository Exists");
                JOptionPane.showMessageDialog(null, string2, this.resourceAlert, 0);
            }
        } else {
            this.centralTabsPane.setSelectedIndex(0);
        }
        inputDialog.dispose();
    }

    private void createRepository(String string, String string2) {
        if (string.length() != 0 || string2.length() != 0) {
            PluginRepository pluginRepository;
            if (string.length() > 25) {
                string = string.substring(0, 24);
            }
            int n = this.centralTabsPane.getTabCount() == 3 ? 1 : this.removeTabIndex;
            if (string2.toLowerCase(Locale.ENGLISH).startsWith("http")) {
                pluginRepository = string2.toLowerCase(Locale.ENGLISH).startsWith("https") ? new HTTP_PluginRepository("https") : new HTTP_PluginRepository("http");
            } else if (string2.toLowerCase(Locale.ENGLISH).startsWith("ftp")) {
                pluginRepository = string2.toLowerCase(Locale.ENGLISH).startsWith("ftps") ? new FTP_PluginRepository("ftps") : new FTP_PluginRepository("ftp");
            } else {
                if (!string2.toLowerCase(Locale.ENGLISH).startsWith("file")) {
                    string2 = "file:" + string2;
                }
                pluginRepository = new FILE_PluginRepository();
            }
            pluginRepository.setName(string);
            if (pluginRepository.setRepository(string2)) {
                PluginRepositoryPanel pluginRepositoryPanel = new PluginRepositoryPanel(pluginRepository, this);
                pluginRepositoryPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createLoweredBevelBorder()));
                this.centralTabsPane.insertTab(pluginRepository.getName(), null, pluginRepositoryPanel, pluginRepository.getPath(), n);
                this.repositoryHashtable.put(string, string2);
                this.tabType = REPOSITORY;
                this.currentTabIndex = n;
                this.centralTabsPane.setSelectedIndex(n);
                ++this.removeTabIndex;
                ++this.addTabIndex;
            } else {
                this.centralTabsPane.setSelectedIndex(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void removePluginConfigurationModule(String string) {
        AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
        String string2 = aResourceBundle.getResourceString("PluginFrame.dialogtitle.Alert", "Alert");
        String string3 = Utils.getAjqvueConfDirectory() + Utils.getFileSeparator() + PLUGIN_CONFIGURATION_FILE;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string4;
            File file = new File(string3);
            try {
                if (!file.exists()) {
                    return;
                }
            }
            catch (SecurityException securityException) {
                String string5 = aResourceBundle.getResourceString("PluginFrame.dialogmessage.SecurityException", "Security Exception");
                String string6 = string5 + " " + securityException;
                JOptionPane.showMessageDialog(null, string6, string2, 0);
                return;
            }
            inputStreamReader = new FileReader(string3);
            bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer();
            while ((string4 = bufferedReader.readLine()) != null) {
                if ((string4 = string4.trim()).indexOf(string) != -1) continue;
                stringBuffer.append(string4 + "\n");
            }
            if (stringBuffer.length() == 0) {
                bufferedReader.close();
                inputStreamReader.close();
                boolean bl = file.delete();
                if (bl) return;
                throw new IOException("Failed to remove plugin configuration file.");
            }
            WriteDataFile.mainWriteDataString(string3, stringBuffer.toString().getBytes(), false);
            return;
        }
        catch (IOException iOException) {
            String string7 = aResourceBundle.getResourceString("PluginFrame.dialogmessage.FileI/OProblem", "File I/O Problem");
            String string8 = string7 + " " + iOException;
            JOptionPane.showMessageDialog(null, string8, string2, 0);
            return;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                if (Ajqvue.getDebug()) {
                    System.out.println("PluginFrame removePluginConfigurationModule() Failed to Close BufferedReader. " + iOException);
                }
            }
            finally {
                block67: {
                    try {
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!Ajqvue.getDebug()) break block67;
                        System.out.println("PluginFrame removePluginConfigurationModule() Failed to Close FileReader. " + iOException);
                    }
                }
            }
        }
    }

    private JPanel createInstalledPluginsViewPanel(ArrayList<Plugin_Module> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string = this.resourceBundle.getResourceString("PluginFrame.label.TabIcon", "Tab Icon");
        arrayList2.add(string);
        String string2 = this.resourceBundle.getResourceString("PluginFrame.label.Name", "Name");
        arrayList2.add(string2);
        string2 = this.resourceBundle.getResourceString("PluginFrame.label.Version", "Version");
        arrayList2.add(string2);
        String string3 = this.resourceBundle.getResourceString("PluginFrame.label.Remove", "Remove");
        arrayList2.add(string3);
        this.generateLoadedPluginsList(arrayList);
        this.loadedPluginsTableModel = new TableModel(arrayList2, this.loadedPluginTableData);
        this.loadedPluginsTable = new JTable(this.loadedPluginsTableModel);
        Font font = new Font(this.mainPanel.getFont().getName(), 1, this.mainPanel.getFont().getSize());
        this.loadedPluginsTable.getTableHeader().setFont(font);
        this.loadedPluginsTable.setAutoResizeMode(4);
        TableColumn tableColumn = this.loadedPluginsTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(string.length() - 10);
        tableColumn = this.loadedPluginsTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(string.length() - 10);
        this.loadedPluginsTable.getSelectionModel().addListSelectionListener(this);
        this.loadedPluginsTable.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.loadedPluginsTable);
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 0, 0));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createLoweredBevelBorder()));
        jPanel.add(jScrollPane);
        return jPanel;
    }

    private void loadCachedRepositories() {
        block8: {
            File file = new File(Utils.getCacheDirectory());
            if (file.exists() && file.isDirectory()) {
                try {
                    File[] fileArray = file.listFiles();
                    if (fileArray != null) {
                        int n = 0;
                        while (n < fileArray.length) {
                            if (fileArray[n].isDirectory()) {
                                if (fileArray[n].getName().equals(REPOSITORY_NAME) && LOAD_DEFAULT_REPOSITORY) {
                                    ++n;
                                    continue;
                                }
                                File file2 = new File(fileArray[n].getAbsoluteFile() + this.fileSeparator + ".path");
                                if (file2.exists()) {
                                    String string = new String(ReadDataFile.mainReadDataString(file2.getAbsolutePath(), false));
                                    this.createRepository(fileArray[n].getName(), string);
                                }
                            }
                            ++n;
                        }
                    }
                }
                catch (SecurityException securityException) {
                    if (!Ajqvue.getDebug()) break block8;
                    System.out.println("PluginFrame loadCachedRepositories() Failed to Load Repositories: " + securityException.toString());
                }
            }
        }
    }

    private JPanel createLoadingPluginsViewPanel() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.resourceBundle.getResourceString("PluginFrame.label.Status", "Status");
        arrayList.add(string);
        String string2 = this.resourceBundle.getResourceString("PluginFrame.label.Name", "Name");
        arrayList.add(string2);
        this.displayLoadingPluginsData();
        this.loadingPluginsTableModel = new TableModel(arrayList, this.loadingPluginTableData);
        this.loadingPluginTable = new JTable(this.loadingPluginsTableModel);
        Font font = new Font(this.mainPanel.getFont().getName(), 1, this.mainPanel.getFont().getSize());
        this.loadingPluginTable.getTableHeader().setFont(font);
        TableColumn tableColumn = this.loadingPluginTable.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(200);
        JScrollPane jScrollPane = new JScrollPane(this.loadingPluginTable);
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 0, 0));
        jPanel.add(jScrollPane);
        return jPanel;
    }

    protected void startAnimation() {
        Thread thread = new Thread((Runnable)this.northFillerPanel, "PluginFrame Filler Panel");
        thread.start();
    }

    protected void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n, n2);
    }
}

