/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.gui.Main_Frame;
import com.dandymadeproductions.ajqvue.gui.MenuActionCommands;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.Component;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.text.DefaultEditorKit;

public class Main_JMenuBar
extends JMenuBar
implements MenuActionCommands {
    private static final long serialVersionUID = 4955351713253784313L;
    private static JMenu schemasMenu = new JMenu();
    private static Main_Frame mainFrame;
    private AResourceBundle resourceBundle;

    public Main_JMenuBar(Main_Frame main_Frame) {
        Accessible accessible;
        ImageIcon imageIcon;
        mainFrame = main_Frame;
        this.resourceBundle = Ajqvue.getResourceBundle();
        String string = Utils.getIconsDirectory() + Utils.getFileSeparator();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.createFileMenu();
        this.createEditMenu();
        this.createDataMenu();
        this.createToolsMenu();
        ArrayList<String> arrayList = ConnectionManager.getSchemas();
        if (!arrayList.isEmpty() && arrayList.size() > 1) {
            this.createSchemasMenu(arrayList);
        }
        this.createHelpMenu();
        this.add(Box.createHorizontalGlue());
        if ((ConnectionManager.getDataSourceType().equals("mysql") || ConnectionManager.getDataSourceType().equals("mariadb")) && ConnectionManager.getConnectionProperties().getProperty("User").equals("root")) {
            imageIcon = this.resourceBundle.getResourceImage(string + "flushIcon.png");
            accessible = this.resourceBundle.getResourceImage(string + "flushIconPressed.png");
            JButton jButton = new JButton(imageIcon);
            jButton.setPressedIcon((Icon)((Object)accessible));
            jButton.setDisabledIcon(imageIcon);
            jButton.setFocusPainted(false);
            jButton.setBorder(BorderFactory.createLoweredBevelBorder());
            jButton.setActionCommand("FLUSH");
            String string2 = this.resourceBundle.getResourceString("Main_JMenuBar.tooltip.FlushPrivileges", "Flush Privileges");
            jButton.setToolTipText(string2);
            jButton.addActionListener(mainFrame);
            this.add(jButton);
        }
        imageIcon = this.resourceBundle.getResourceImage(string + "ajqvueIcon.gif");
        accessible = new JButton(imageIcon);
        accessible.setDisabledIcon(imageIcon);
        accessible.setFocusPainted(false);
        accessible.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)((Object)accessible));
    }

    private void createFileMenu() {
        String string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.File", "File");
        JMenu jMenu = new JMenu(string);
        jMenu.setFont(jMenu.getFont().deriveFont(1));
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.Open", "Open");
        jMenu.add(this.menuItem(string, "FO"));
        jMenu.addSeparator();
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.Save", "Save");
        jMenu.add(this.menuItem(string, "FS"));
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.SaveAs", "Save As...");
        jMenu.add(this.menuItem(string, "FSA"));
        jMenu.addSeparator();
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.Print", "Print");
        jMenu.add(this.menuItem(string, "FP"));
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.PageFormat", "Page Format");
        jMenu.add(this.menuItem(string, "FPG"));
        jMenu.addSeparator();
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.Exit", "Exit");
        jMenu.add(this.menuItem(string, "FE"));
        this.add(jMenu);
    }

    private void createEditMenu() {
        JMenuItem jMenuItem = null;
        String string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.Edit", "Edit");
        JMenu jMenu = new JMenu(string);
        jMenu.setFont(jMenu.getFont().deriveFont(1));
        jMenuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.Cut", "Cut");
        jMenuItem.setText(string + "          Ctrl+x");
        jMenuItem.setMnemonic(88);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.Copy", "Copy");
        jMenuItem.setText(string + "       Ctrl+c");
        jMenuItem.setMnemonic(67);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.Paste", "Paste");
        jMenuItem.setText(string + "       Ctrl+v");
        jMenuItem.setMnemonic(86);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.ClearHistory", "Clear History");
        jMenu.add(this.menuItem(string, "ECH"));
        jMenu.addSeparator();
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.Preferences", "Preferences");
        jMenu.add(this.menuItem(string, "EP"));
        this.add(jMenu);
    }

    private void createDataMenu() {
        String string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.Data", "Data");
        JMenu jMenu = new JMenu(string);
        jMenu.setFont(jMenu.getFont().deriveFont(1));
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.Import", "Import");
        JMenu jMenu2 = new JMenu(string);
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.ImportSQLDump", "SQL Dump");
        jMenu2.add(this.menuItem(string, "DISQLD"));
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.ImportCSVFile", "CSV File");
        jMenu2.add(this.menuItem(string, "DICSVF"));
        jMenu.add(jMenu2);
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.Export", "Export");
        JMenu jMenu3 = new JMenu(string);
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.ExportCSV", "CSV");
        JMenu jMenu4 = new JMenu(string);
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.ExportCSVTable", "Table");
        jMenu4.add(this.menuItem(string, "DECSVT"));
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.ExportCSVSummaryTable", "Summary Table");
        jMenu4.add(this.menuItem(string, "DECSVST"));
        jMenu3.add(jMenu4);
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.ExportPDF", "PDF");
        JMenu jMenu5 = new JMenu(string);
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.ExportPDFSummaryTable", "Summary Table");
        jMenu5.add(this.menuItem(string, "DEPDFST"));
        jMenu3.add(jMenu5);
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.ExportSQL", "SQL");
        JMenu jMenu6 = new JMenu(string);
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.ExportSQLTable", "Table");
        jMenu6.add(this.menuItem(string, "DESQLT"));
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.ExportSQLSummaryTable", "Summary Table");
        jMenu6.add(this.menuItem(string, "DESQLST"));
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.ExportSQLDatabase", "Database");
        jMenu6.add(this.menuItem(string, "DESQLD"));
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.ExportSQLDatabaseScheme", "Database Scheme");
        jMenu6.add(this.menuItem(string, "DESQLDS"));
        jMenu3.add(jMenu6);
        jMenu.add(jMenu3);
        this.add(jMenu);
    }

    private void createToolsMenu() {
        String string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.Tools", "Tools");
        JMenu jMenu = new JMenu(string);
        jMenu.setFont(jMenu.getFont().deriveFont(1));
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.SQLQueryBucket", "SQL Query Bucket");
        jMenu.add(this.menuItem(string, "TSQB"));
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.QueryFrame", "Query Frame");
        jMenu.add(this.menuItem(string, "TQF"));
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.ReloadDatabase", "Reload Database");
        jMenu.add(this.menuItem(string, "TRD"));
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.SearchDatabase", "Search Database");
        jMenu.add(this.menuItem(string, "TSD"));
        this.add(jMenu);
    }

    private void createSchemasMenu(ArrayList<String> arrayList) {
        JRadioButtonMenuItem jRadioButtonMenuItem;
        String string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.Schemas", "Schemas");
        schemasMenu.setText(string);
        schemasMenu.setFont(schemasMenu.getFont().deriveFont(1));
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        if (arrayList.size() != 1) {
            string = this.resourceBundle.getResourceString("Main_JMenuBar.radioButton.All", "All");
            jRadioButtonMenuItem = new JRadioButtonMenuItem(string, true);
            jRadioButtonMenuItem.setActionCommand("All");
            jRadioButtonMenuItem.addActionListener(mainFrame);
            buttonGroup.add(jRadioButtonMenuItem);
            schemasMenu.add(jRadioButtonMenuItem);
            n = 1;
        }
        for (String string2 : arrayList) {
            jRadioButtonMenuItem = n == 0 ? new JRadioButtonMenuItem(string2, true) : new JRadioButtonMenuItem(string2);
            jRadioButtonMenuItem.setActionCommand(string2);
            jRadioButtonMenuItem.addActionListener(mainFrame);
            buttonGroup.add(jRadioButtonMenuItem);
            schemasMenu.add(jRadioButtonMenuItem);
            ++n;
        }
        this.add(schemasMenu);
    }

    public static void reloadSchemasMenu() {
        if (!schemasMenu.getText().isEmpty()) {
            JRadioButtonMenuItem jRadioButtonMenuItem;
            ArrayList<String> arrayList = ConnectionManager.getSchemas();
            schemasMenu.removeAll();
            ButtonGroup buttonGroup = new ButtonGroup();
            int n = 0;
            if (arrayList.size() != 1) {
                String string = Ajqvue.getResourceBundle().getResourceString("Main_JMenuBar.radioButton.All", "All");
                jRadioButtonMenuItem = new JRadioButtonMenuItem(string, true);
                jRadioButtonMenuItem.setActionCommand("All");
                jRadioButtonMenuItem.addActionListener(mainFrame);
                buttonGroup.add(jRadioButtonMenuItem);
                schemasMenu.add(jRadioButtonMenuItem);
                n = 1;
            }
            for (String string : arrayList) {
                jRadioButtonMenuItem = n == 0 ? new JRadioButtonMenuItem(string, true) : new JRadioButtonMenuItem(string);
                jRadioButtonMenuItem.setActionCommand(string);
                jRadioButtonMenuItem.addActionListener(mainFrame);
                buttonGroup.add(jRadioButtonMenuItem);
                schemasMenu.add(jRadioButtonMenuItem);
                ++n;
            }
        }
    }

    private void createHelpMenu() {
        String string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.Help", "Help");
        JMenu jMenu = new JMenu(string);
        jMenu.setFont(jMenu.getFont().deriveFont(1));
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.Manual", "Manual");
        jMenu.add(this.menuItem(string, "HM"));
        jMenu.addSeparator();
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.Legal", "Legal");
        jMenu.add(this.menuItem(string, "HL"));
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.ReleaseNotes", "Release Notes");
        jMenu.add(this.menuItem(string, "HRN"));
        jMenu.addSeparator();
        string = this.resourceBundle.getResourceString("Main_JMenuBar.menu.About", "About");
        jMenu.add(this.menuItem(string, "HA"));
        this.add(jMenu);
    }

    private JMenuItem menuItem(String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(mainFrame);
        jMenuItem.setActionCommand(string2);
        return jMenuItem;
    }
}

