/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.gui.SiteParameters;
import com.dandymadeproductions.ajqvue.gui.XMLTranslator;
import com.dandymadeproductions.ajqvue.gui.panels.AdvancedParametersPanel;
import com.dandymadeproductions.ajqvue.gui.panels.StandardParametersPanel;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.InputDialog;
import com.dandymadeproductions.ajqvue.utilities.NormalizeString;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class LoginManagerFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 6731894325410122731L;
    private JMenuBar loginManagerMenuBar;
    private String resource;
    private SitesTreePanel treePanel;
    private transient HashMap<String, SiteParameters> sitesClone;
    private transient NormalizeString normString;
    private StandardParametersPanel standardParametersPanel;
    private AdvancedParametersPanel advancedParametersPanel;
    private JCheckBox sshCheckBox;
    private ImageIcon sshUpIcon;
    private ImageIcon sshDownIcon;
    private JButton newSiteButton;
    private JButton updateSiteButton;
    private JButton renameSiteButton;
    private JButton deleteButton;
    private JButton advancedButton;
    private boolean advancedOptionsShowing = false;

    public LoginManagerFrame(AResourceBundle aResourceBundle, HashMap<String, SiteParameters> hashMap, NormalizeString normalizeString, StandardParametersPanel standardParametersPanel, AdvancedParametersPanel advancedParametersPanel, JButton jButton, JButton jButton2) {
        super("Ajqvue Login Manager");
        Object object;
        this.normString = normalizeString;
        this.standardParametersPanel = standardParametersPanel;
        this.advancedParametersPanel = advancedParametersPanel;
        this.setIconImage(Utils.getFrameIcon());
        String string = Utils.getIconsDirectory() + Utils.getFileSeparator();
        Iterator<Map.Entry<String, SiteParameters>> iterator = hashMap.entrySet().iterator();
        this.sitesClone = new HashMap();
        while (iterator.hasNext()) {
            object = iterator.next().getKey();
            this.sitesClone.put((String)object, hashMap.get(object));
        }
        this.loginManagerMenuBar = new JMenuBar();
        this.loginManagerMenuBar.setBorder(BorderFactory.createEtchedBorder());
        this.loginManagerMenuBar.setMargin(new Insets(0, 0, 0, 0));
        this.newSiteButton = new JButton(aResourceBundle.getResourceImage(string + "newsiteIcon.png"));
        this.newSiteButton.setFocusable(false);
        this.newSiteButton.setMargin(new Insets(0, 0, 0, 0));
        this.resource = aResourceBundle.getResourceString("LoginManagerFrame.tooltip.NewSite", "New Site");
        this.newSiteButton.setToolTipText(this.resource);
        this.newSiteButton.addActionListener(this);
        this.loginManagerMenuBar.add(this.newSiteButton);
        this.updateSiteButton = new JButton(aResourceBundle.getResourceImage(string + "updateSiteIcon.png"));
        this.updateSiteButton.setFocusable(false);
        this.updateSiteButton.setMargin(new Insets(0, 0, 0, 0));
        this.resource = aResourceBundle.getResourceString("LoginManagerFrame.tooltip.UpdateSite", "Update Site");
        this.updateSiteButton.setToolTipText(this.resource);
        this.updateSiteButton.addActionListener(this);
        this.loginManagerMenuBar.add(this.updateSiteButton);
        this.renameSiteButton = new JButton(aResourceBundle.getResourceImage(string + "renameSiteIcon.png"));
        this.renameSiteButton.setFocusable(false);
        this.renameSiteButton.setMargin(new Insets(0, 0, 0, 0));
        this.resource = aResourceBundle.getResourceString("LoginManagerFrame.tooltip.RenameSite", "Rename Site");
        this.renameSiteButton.setToolTipText(this.resource);
        this.renameSiteButton.addActionListener(this);
        this.loginManagerMenuBar.add(this.renameSiteButton);
        this.deleteButton = new JButton(aResourceBundle.getResourceImage(string + "removeIcon.png"));
        this.deleteButton.setFocusable(false);
        this.deleteButton.setMargin(new Insets(2, 2, 2, 2));
        this.resource = aResourceBundle.getResourceString("LoginManagerFrame.tooltip.Delete", "Delete");
        this.deleteButton.setToolTipText(this.resource);
        this.deleteButton.addActionListener(this);
        this.loginManagerMenuBar.add(this.deleteButton);
        this.advancedButton = new JButton(aResourceBundle.getResourceImage(string + "advancedConnectionsIcon.png"));
        this.advancedButton.setFocusable(false);
        this.advancedButton.setMargin(new Insets(0, 0, 0, 0));
        this.resource = aResourceBundle.getResourceString("LoginManagerFrame.tooltip.AdvancedParameters", "Advanced Parameters");
        this.advancedButton.setToolTipText(this.resource);
        this.advancedButton.addActionListener(this);
        this.loginManagerMenuBar.add(this.advancedButton);
        this.setJMenuBar(this.loginManagerMenuBar);
        object = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel((LayoutManager)object);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.addMouseListener(Ajqvue.getPopupMenuListener());
        this.treePanel = new SitesTreePanel(this, this.sitesClone, standardParametersPanel, advancedParametersPanel);
        this.treePanel.setLayout(new GridLayout(1, 1, 0, 0));
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 40.0, 80.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        ((GridBagLayout)object).setConstraints(this.treePanel, gridBagConstraints);
        jPanel.add(this.treePanel);
        JPanel jPanel2 = new JPanel((LayoutManager)object);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50.0, 100.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        ((GridBagLayout)object).setConstraints(standardParametersPanel, gridBagConstraints);
        jPanel2.add(standardParametersPanel);
        advancedParametersPanel.setVisible(false);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50.0, 100.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        ((GridBagLayout)object).setConstraints(advancedParametersPanel, gridBagConstraints);
        jPanel2.add(advancedParametersPanel);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 60.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        ((GridBagLayout)object).setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createRaisedBevelBorder());
        this.sshUpIcon = aResourceBundle.getResourceImage(string + "sshUpIcon.png");
        this.sshDownIcon = aResourceBundle.getResourceImage(string + "sshDownIcon.png");
        this.resource = aResourceBundle.getResourceString("LoginManagerFrame.checkbox.SSH", "SSH");
        this.sshCheckBox = new JCheckBox(this.resource, this.sshUpIcon);
        this.sshCheckBox.setSelectedIcon(this.sshDownIcon);
        this.sshCheckBox.setHorizontalTextPosition(10);
        this.sshCheckBox.setFocusPainted(false);
        jPanel3.add(this.sshCheckBox);
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        this.buildConstraints(gridBagConstraints, 0, 1, 3, 1, 0.0, 20.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        ((GridBagLayout)object).setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        this.getContentPane().add(jPanel);
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            JButton jButton = (JButton)object;
            if (jButton == this.newSiteButton) {
                this.treePanel.addSite();
            }
            if (jButton == this.updateSiteButton) {
                this.treePanel.updateSiteNode();
            }
            if (jButton == this.renameSiteButton) {
                this.treePanel.renameSite();
            }
            if (jButton == this.deleteButton) {
                this.treePanel.removeCurrentNode();
            }
            if (jButton == this.advancedButton) {
                if (this.advancedOptionsShowing) {
                    this.advancedParametersPanel.setVisible(false);
                    this.advancedOptionsShowing = false;
                } else {
                    this.advancedParametersPanel.setVisible(true);
                    this.advancedOptionsShowing = true;
                }
                this.pack();
            }
        }
    }

    public HashMap<String, SiteParameters> getSites() {
        return this.sitesClone;
    }

    public String getSsh() {
        if (this.sshCheckBox.isSelected()) {
            return "1";
        }
        return "0";
    }

    public void setSelectedSite(SiteParameters siteParameters) {
        String string = siteParameters.getSiteName();
        if (string != null) {
            this.advancedParametersPanel.setDriver(siteParameters.getDriver());
            this.advancedParametersPanel.setProtocol(siteParameters.getProtocol());
            this.advancedParametersPanel.setSubProtocol(siteParameters.getSubProtocol());
            this.standardParametersPanel.setHostItem(siteParameters.getHost());
            this.advancedParametersPanel.setPort(siteParameters.getPort());
            this.standardParametersPanel.setDatabaseItem(siteParameters.getDatabase());
            this.standardParametersPanel.setUserItem(siteParameters.getUser());
            this.standardParametersPanel.setPassword(XMLTranslator.textConversion(this.normString.execute(String.valueOf(siteParameters.getPassword()), false), true));
            if (siteParameters.getSsh().equals("0")) {
                this.sshCheckBox.setSelected(false);
            } else {
                this.sshCheckBox.setSelected(true);
            }
        }
    }

    public void center(int n, int n2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n3 = (dimension.width - dimension2.width) / 2 + 50;
        int n4 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n3 + n, n4 + n2);
    }

    static class SitesTreePanel
    extends JPanel
    implements TreeModelListener,
    TreeSelectionListener {
        private static final long serialVersionUID = -3291619646627993470L;
        private LoginManagerFrame loginManagerFrame;
        private DefaultMutableTreeNode sitesNode;
        private DefaultTreeModel treeModel;
        private JTree sitesTree;
        private ArrayList<String> siteNameCollection;
        private transient HashMap<String, SiteParameters> sites;
        private StandardParametersPanel standardParametersPanel;
        private AdvancedParametersPanel advancedParametersPanel;
        private AResourceBundle resourceBundle;

        SitesTreePanel(LoginManagerFrame loginManagerFrame, HashMap<String, SiteParameters> hashMap, StandardParametersPanel standardParametersPanel, AdvancedParametersPanel advancedParametersPanel) {
            JComponent jComponent;
            this.loginManagerFrame = loginManagerFrame;
            this.sites = hashMap;
            this.standardParametersPanel = standardParametersPanel;
            this.advancedParametersPanel = advancedParametersPanel;
            String string = Utils.getIconsDirectory() + Utils.getFileSeparator();
            this.resourceBundle = Ajqvue.getResourceBundle();
            this.setBorder(BorderFactory.createBevelBorder(1));
            this.sitesNode = new DefaultMutableTreeNode("Sites");
            this.treeModel = new DefaultTreeModel(this.sitesNode);
            this.treeModel.addTreeModelListener(this);
            this.sitesTree = new JTree(this.treeModel);
            this.sitesTree.setBorder(BorderFactory.createLoweredBevelBorder());
            this.sitesTree.setEditable(false);
            this.sitesTree.getSelectionModel().setSelectionMode(1);
            this.sitesTree.setShowsRootHandles(true);
            ImageIcon imageIcon = this.resourceBundle.getResourceImage(string + "newsiteLeafIcon.png");
            if (imageIcon != null) {
                jComponent = new DefaultTreeCellRenderer();
                ((DefaultTreeCellRenderer)jComponent).setLeafIcon(imageIcon);
                this.sitesTree.setCellRenderer((TreeCellRenderer)((Object)jComponent));
            }
            this.sitesTree.addTreeSelectionListener(this);
            jComponent = new JScrollPane(this.sitesTree);
            jComponent.setPreferredSize(new Dimension(250, 230));
            jComponent.setAutoscrolls(true);
            this.add(jComponent);
            this.createSitesTree();
        }

        private void createSitesTree() {
            String string3;
            this.siteNameCollection = new ArrayList();
            for (String string2 : this.sites.keySet()) {
                if (string2.equals("Last Site") || string2.indexOf(35) == -1 || this.siteNameCollection.contains(string3 = string2.substring(0, string2.indexOf(35)))) continue;
                this.siteNameCollection.add(string3);
            }
            TreeSet<String> treeSet = new TreeSet<String>(this.siteNameCollection);
            HashMap<String, DefaultMutableTreeNode> hashMap = new HashMap<String, DefaultMutableTreeNode>();
            for (String string3 : treeSet) {
                DefaultMutableTreeNode defaultMutableTreeNode = this.addSite(null, string3, false);
                hashMap.put(string3, defaultMutableTreeNode);
            }
            for (String string2 : this.sites.keySet()) {
                if (string2.equals("Last Site") || string2.indexOf(35) == -1) continue;
                string3 = string2.substring(0, string2.indexOf(35));
                String string4 = string2.substring(string2.indexOf(35) + 1);
                this.addSite((DefaultMutableTreeNode)hashMap.get(string3), string4, false);
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.sitesTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            if (defaultMutableTreeNode.isLeaf() && defaultMutableTreeNode.getParent() != this.sitesNode) {
                String string = defaultMutableTreeNode.getParent().toString() + "#" + defaultMutableTreeNode.getUserObject().toString();
                SiteParameters siteParameters = this.sites.get(string);
                this.loginManagerFrame.setSelectedSite(siteParameters);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void addSite() {
            Object object;
            Object object2;
            Object object3;
            String string = "";
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            TreePath treePath = this.sitesTree.getSelectionPath();
            if (treePath == null) {
                defaultMutableTreeNode = this.sitesNode;
            } else {
                defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (defaultMutableTreeNode.isLeaf() && defaultMutableTreeNode.getParent() != this.sitesNode) {
                    return;
                }
            }
            if (defaultMutableTreeNode == this.sitesNode) {
                String string2 = this.resourceBundle.getResourceString("SitesTreePanel.message.EnterNewSiteName", "Enter New Site Name");
                object3 = new JLabel(string2, 0);
                object2 = new JTextField(10);
                ((JComponent)object2).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createLoweredBevelBorder()));
                Object[] objectArray = new Object[]{object3, object2};
                string2 = this.resourceBundle.getResourceString("SitesTreePanel.dialogTitle.SiteDialog", "Site Dialog");
                String string3 = this.resourceBundle.getResourceString("SitesTreePanel.button.OK", "OK");
                String string4 = this.resourceBundle.getResourceString("SitesTreePanel.button.Cancel", "Cancel");
                object = new InputDialog(this.loginManagerFrame, string2, string3, string4, objectArray, null);
                ((Window)object).pack();
                ((InputDialog)object).center();
                ((Dialog)object).setResizable(false);
                ((Dialog)object).setVisible(true);
                if (!((InputDialog)object).isActionResult()) {
                    ((Window)object).dispose();
                    return;
                }
                String string5 = ((JTextComponent)object2).getText();
                if (!this.siteNameCollection.contains(string5) && !string5.equals("")) {
                    ((Window)object).dispose();
                    defaultMutableTreeNode = this.addSite(defaultMutableTreeNode, string5, false);
                } else {
                    ((Window)object).dispose();
                    this.showSiteExistsDialog();
                    return;
                }
            }
            object = new SiteParameters();
            ((SiteParameters)object).setSiteName(defaultMutableTreeNode + "#" + this.standardParametersPanel.getDatabase());
            ((SiteParameters)object).setDriver(this.advancedParametersPanel.getDriver());
            ((SiteParameters)object).setProtocol(this.advancedParametersPanel.getProtocol());
            ((SiteParameters)object).setSubProtocol(this.advancedParametersPanel.getSubProtocol());
            ((SiteParameters)object).setPort(this.advancedParametersPanel.getPort());
            if (defaultMutableTreeNode.getChildCount() == 0) {
                ((SiteParameters)object).setHost(this.standardParametersPanel.getHost());
            } else {
                object3 = defaultMutableTreeNode.getChildAt(0).toString();
                object2 = this.sites.get(defaultMutableTreeNode.toString() + "#" + (String)object3).getHost();
                ((SiteParameters)object).setHost((String)object2);
            }
            ((SiteParameters)object).setDatabase(this.standardParametersPanel.getDatabase());
            ((SiteParameters)object).setUser(this.standardParametersPanel.getUser());
            ((SiteParameters)object).setPassword(this.loginManagerFrame.normString.execute(String.valueOf(XMLTranslator.textConversion(this.standardParametersPanel.getPassword(), false)), true));
            ((SiteParameters)object).setSsh(this.loginManagerFrame.getSsh());
            string = this.standardParametersPanel.getDatabase();
            this.sites.put(defaultMutableTreeNode + "#" + string, (SiteParameters)object);
            this.addSite(defaultMutableTreeNode, string, true);
        }

        DefaultMutableTreeNode addSite(DefaultMutableTreeNode defaultMutableTreeNode, Object object, boolean bl) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = this.sitesNode;
            }
            this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            if (bl) {
                this.sitesTree.scrollPathToVisible(new TreePath(defaultMutableTreeNode2.getPath()));
            }
            return defaultMutableTreeNode2;
        }

        void updateSiteNode() {
            TreePath treePath = this.sitesTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            if (defaultMutableTreeNode.isLeaf() && defaultMutableTreeNode.getParent() != this.sitesNode) {
                SiteParameters siteParameters = new SiteParameters();
                String string = defaultMutableTreeNode2 + "#" + defaultMutableTreeNode;
                siteParameters.setSiteName(string);
                siteParameters.setHost(this.sites.get(string).getHost());
                siteParameters.setDatabase(this.standardParametersPanel.getDatabase());
                siteParameters.setUser(this.standardParametersPanel.getUser());
                siteParameters.setPassword(this.loginManagerFrame.normString.execute(String.valueOf(XMLTranslator.textConversion(this.standardParametersPanel.getPassword(), false)), true));
                siteParameters.setSsh(this.loginManagerFrame.getSsh());
                siteParameters.setDriver(this.advancedParametersPanel.getDriver());
                siteParameters.setProtocol(this.advancedParametersPanel.getProtocol());
                siteParameters.setSubProtocol(this.advancedParametersPanel.getSubProtocol());
                siteParameters.setPort(this.advancedParametersPanel.getPort());
                int n = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
                this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
                this.sites.remove(string);
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(this.standardParametersPanel.getDatabase());
                this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, n);
                this.sitesTree.scrollPathToVisible(new TreePath(defaultMutableTreeNode3.getPath()));
                string = defaultMutableTreeNode2 + "#" + this.standardParametersPanel.getDatabase();
                this.sites.put(string, siteParameters);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void renameSite() {
            String string;
            String string2;
            TreePath treePath = this.sitesTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.sitesNode;
            String string3 = this.resourceBundle.getResourceString("SitesTreePanel.message.EnterNewSiteName", "Enter New Site Name");
            JLabel jLabel = new JLabel(string3, 0);
            JTextField jTextField = new JTextField(10);
            jTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createLoweredBevelBorder()));
            Object[] objectArray = new Object[]{jLabel, jTextField};
            string3 = this.resourceBundle.getResourceString("SitesTreePanel.dialogTitle.SiteDialog", "Site Dialog");
            String string4 = this.resourceBundle.getResourceString("SitesTreePanel.button.OK", "OK");
            String string5 = this.resourceBundle.getResourceString("SitesTreePanel.button.Cancel", "Cancel");
            InputDialog inputDialog = new InputDialog(this.loginManagerFrame, string3, string4, string5, objectArray, null);
            inputDialog.pack();
            inputDialog.center();
            inputDialog.setResizable(false);
            if (!defaultMutableTreeNode.isLeaf() && defaultMutableTreeNode.getParent() == this.sitesNode) {
                inputDialog.setVisible(true);
                if (!inputDialog.isActionResult()) {
                    inputDialog.dispose();
                    return;
                }
                string2 = jTextField.getText();
                string = defaultMutableTreeNode.toString();
                if (this.siteNameCollection.contains(string2) || string2.equals("")) {
                    inputDialog.dispose();
                    this.showSiteExistsDialog();
                    return;
                }
            } else {
                if (!defaultMutableTreeNode.isLeaf()) return;
                if (defaultMutableTreeNode.getParent() != this.sitesNode) return;
                inputDialog.setVisible(true);
                if (!inputDialog.isActionResult()) {
                    inputDialog.dispose();
                    return;
                }
                String string6 = jTextField.getText();
                if (!this.siteNameCollection.contains(string6) && !string6.equals("")) {
                    inputDialog.dispose();
                    this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
                    this.addSite(defaultMutableTreeNode2, string6, false);
                    return;
                }
                inputDialog.dispose();
                this.showSiteExistsDialog();
                return;
            }
            inputDialog.dispose();
            DefaultMutableTreeNode defaultMutableTreeNode3 = this.addSite(defaultMutableTreeNode2, string2, false);
            int n = defaultMutableTreeNode.getChildCount();
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
                    this.sitesTree.scrollPathToVisible(new TreePath(defaultMutableTreeNode3.getPath()));
                    return;
                }
                SiteParameters siteParameters = new SiteParameters();
                String string7 = string + "#" + defaultMutableTreeNode.getChildAt(n2).toString();
                SiteParameters siteParameters2 = this.sites.get(string7);
                String string8 = string2 + "#" + siteParameters2.getDatabase();
                siteParameters.setSiteName(string8);
                if (siteParameters2.getHost().equals(this.standardParametersPanel.getHost())) {
                    siteParameters.setHost(siteParameters2.getHost());
                } else {
                    siteParameters.setHost(this.standardParametersPanel.getHost());
                }
                String string9 = siteParameters2.getDatabase();
                siteParameters.setDatabase(string9);
                siteParameters.setUser(siteParameters2.getUser());
                siteParameters.setPassword(siteParameters2.getPassword());
                siteParameters.setSsh(siteParameters2.getSsh());
                siteParameters.setDriver(siteParameters2.getDriver());
                siteParameters.setProtocol(siteParameters2.getProtocol());
                siteParameters.setSubProtocol(siteParameters2.getSubProtocol());
                siteParameters.setPort(siteParameters2.getPort());
                this.sites.put(string8, siteParameters);
                this.sites.remove(string7);
                DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(string9);
                this.treeModel.insertNodeInto(defaultMutableTreeNode4, defaultMutableTreeNode3, n2);
                ++n2;
            }
        }

        private void showSiteExistsDialog() {
            String string = this.resourceBundle.getResourceString("SitesTreePanel.dialogTitle.Alert", "Alert");
            String string2 = this.resourceBundle.getResourceString("SitesTreePanel.dialogMessage.SiteAlreadyExist", "Site Already Exists or Empty String!");
            JOptionPane.showMessageDialog(null, string2, string, 0);
        }

        void removeCurrentNode() {
            DefaultMutableTreeNode defaultMutableTreeNode;
            MutableTreeNode mutableTreeNode;
            TreePath treePath = this.sitesTree.getSelectionPath();
            if (treePath != null && (mutableTreeNode = (MutableTreeNode)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getParent()) != null) {
                if (defaultMutableTreeNode.isLeaf()) {
                    String string = defaultMutableTreeNode.getParent().toString() + "#" + defaultMutableTreeNode.getUserObject().toString();
                    if (this.sites.containsKey(string)) {
                        this.sites.remove(string);
                    }
                } else {
                    for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                        String string = defaultMutableTreeNode.getUserObject().toString() + "#" + defaultMutableTreeNode.getChildAt(i).toString();
                        if (!this.sites.containsKey(string)) continue;
                        this.sites.remove(string);
                    }
                }
                this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
                return;
            }
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

