/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui;

import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpFrame
extends JFrame {
    private static final long serialVersionUID = -4143035957786665080L;
    private JEditorPane helpHTMLPane;
    private JScrollPane helpHTMLScrollPane;
    private JButton closeButton;
    protected boolean failedToLoadContents;
    private transient WindowListener helpFrameListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (HelpFrame.this.closeButton != null) {
                HelpFrame.this.closeButton.doClick();
            }
            HelpFrame.this.dispose();
        }
    };

    public HelpFrame(String string, String string2, JButton jButton) {
        super(string);
        this.setIconImage(Utils.getFrameIcon());
        this.closeButton = jButton;
        this.failedToLoadContents = false;
        this.helpHTMLPane = new JEditorPane();
        this.helpHTMLPane.setEditable(false);
        URL uRL = HelpFrame.class.getResource(string2);
        if (uRL != null) {
            try {
                this.helpHTMLPane.setPage(uRL);
            }
            catch (IOException iOException) {
                String string3 = "Unable to to SetPage - " + uRL + "\nIOException: " + iOException.toString();
                JOptionPane.showMessageDialog(null, string3, "Alert", 0);
                this.failedToLoadContents = true;
            }
        } else {
            String string4 = "Unable to read URL - " + string2;
            JOptionPane.showMessageDialog(null, string4, "Alert", 0);
            this.failedToLoadContents = true;
        }
        this.helpHTMLPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                try {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        HelpFrame.this.helpHTMLPane.setPage(hyperlinkEvent.getURL());
                    }
                }
                catch (IOException iOException) {
                    String string = "Unable to Load HyperLink";
                    JOptionPane.showMessageDialog(null, string, "Alert", 0);
                }
            }
        });
        if (!this.failedToLoadContents) {
            this.helpHTMLScrollPane = new JScrollPane(this.helpHTMLPane);
            this.helpHTMLScrollPane.setVerticalScrollBarPolicy(20);
            this.helpHTMLScrollPane.setHorizontalScrollBarPolicy(30);
            this.getContentPane().add((Component)this.helpHTMLScrollPane, "Center");
        }
        this.addWindowListener(this.helpFrameListener);
    }

    public void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n, n2);
    }
}

