/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.datasource;

import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.datasource.TypeID;
import java.lang.reflect.Field;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;

public class TypesInfoCache {
    private String dataSourceType;
    private String dataSinkType;
    private Map<String, Integer> nameToType;
    private static final int TYPE_NAME = 0;
    private static final int H2_TYPE = 1;
    private static final int HSQL_TYPE = 2;
    private static final int DERBY_TYPE = 3;
    private static final int SQLITE_TYPE = 4;
    private static final String DEFAULT_DATASINK_TYPE = "hsql2";
    private static final int[][] H2_TYPES = new int[][]{{-254, -254, -212, -122, 60}, {-252, -252, -210, -144, 66}, {-250, -250, -208, -140, 66}, {-248, -248, -208, -140, 66}, {-246, -246, -200, -136, 68}, {-244, -244, -196, -136, 68}, {-242, -242, -204, -130, 66}, {-240, -240, -196, -136, 72}, {-238, -238, -202, -136, 72}, {-236, -236, -176, -128, 64}, {-234, -234, -194, -126, 60}, {-232, -232, -192, -126, 60}, {-230, -230, -190, -124, 60}, {-228, -228, -188, -122, 60}, {-226, -226, -182, -118, 62}, {-224, -224, -184, -116, 62}, {-222, -222, -178, -114, 64}, {-220, -220, -170, -112, 66}, {-218, -218, -168, -110, 66}, {-216, -216, -162, -108, 66}, {-214, -214, -206, -134, 66}};
    private static final int[][] HSQL_TYPES = new int[][]{{-212, -254, -212, -122, 60}, {-210, -252, -210, -144, 66}, {-208, -250, -208, -140, 66}, {-206, -247, -206, -134, 66}, {-204, -242, -204, -130, 66}, {-202, -246, -202, -136, 68}, {-200, -244, -200, -136, 68}, {-198, -244, -198, -136, 68}, {-196, -244, -196, -136, 68}, {-194, -234, -194, -126, 60}, {-192, -232, -192, -126, 60}, {-190, -230, -190, -124, 60}, {-188, -228, -188, -122, 60}, {-186, -226, -186, -118, 62}, {-184, -224, -184, -116, 62}, {-182, -226, -182, -118, 62}, {-180, -222, -180, -114, 64}, {-178, -222, -178, -114, 64}, {-176, -236, -176, -128, 64}, {-174, -250, -174, -140, 66}, {-172, -250, -172, -140, 66}, {-170, -220, -170, -112, 66}, {-168, -218, -168, -110, 66}, {-166, -218, -166, -110, 66}, {-164, -216, -164, -108, 66}, {-162, -216, -162, -108, 66}, {-160, -216, -160, -108, 66}, {-158, -250, -158, -140, 72}, {-156, -250, -156, -140, 72}, {-154, -250, -154, -140, 72}, {-152, -250, -152, -140, 72}, {-150, -250, -150, -140, 72}, {-148, -250, -148, -140, 72}};
    private static final int[][] DERBY_TYPES = new int[][]{{-146, -254, -212, -122, 60}, {-144, -252, -210, -144, 66}, {-142, -246, -202, -142, 68}, {-140, -250, -208, -140, 66}, {-138, -246, -200, -138, 68}, {-136, -244, -196, -136, 68}, {-134, -247, -206, -134, 66}, {-132, -246, -198, -132, 68}, {-130, -242, -204, -130, 66}, {-128, -236, -176, -128, 64}, {-126, -232, -192, -126, 60}, {-124, -230, -190, -124, 60}, {-122, -228, -188, -122, 60}, {-120, -224, -186, -120, 62}, {-118, -226, -182, -118, 62}, {-116, -224, -184, -116, 62}, {-114, -222, -180, -114, 64}, {-112, -220, -170, -112, 66}, {-110, -218, -168, -110, 66}, {-108, -216, -162, -108, 66}};
    private static final int[][] POSTGRESQL_TYPES = new int[][]{{-106, -230, -190, -124, 60}, {-104, -228, -188, -122, 60}, {-102, -232, -192, -126, 60}, {-100, -230, -190, -124, 60}, {-98, -228, -188, -122, 72}, {-96, -228, -188, -122, 60}, {-94, -224, -184, -116, 62}, {-92, -222, -178, -114, 64}, {-90, -226, -186, -118, 62}, {-88, -224, -184, -116, 62}, {-86, -252, -210, -144, 66}, {-84, -252, -210, -144, 66}, {-82, -250, -208, -140, 66}, {-80, -242, -204, -130, 66}, {-76, -250, -208, -140, 66}, {-74, -244, -196, -136, 68}, {-72, -236, -176, -128, 64}, {-70, -250, -174, -140, 66}, {-68, -250, -172, -140, 66}, {-66, -220, -170, -112, 66}, {-64, -218, -168, -110, 66}, {-62, -218, -166, -110, 66}, {-60, -216, -162, -108, 66}, {-58, -216, -160, -108, 66}, {-56, -250, -208, -140, 66}, {-54, -247, -206, -134, 66}, {-52, -247, -206, -134, 66}, {-50, -247, -206, -134, 66}, {-48, -247, -206, -134, 66}, {-46, -247, -206, -134, 66}, {-44, -247, -206, -134, 66}, {-42, -247, -206, -134, 66}, {-40, -247, -206, -134, 66}, {-38, -247, -206, -134, 66}, {-36, -214, -206, -134, 66}};
    private static final int[][] MYSQL_TYPES = new int[][]{{-34, -252, -210, -144, 66}, {-32, -250, -208, -140, 66}, {-30, -244, -200, -138, 68}, {-28, -244, -196, -136, 68}, {-26, -244, -196, -136, 68}, {-24, -244, -196, -136, 68}, {-22, -234, -194, -126, 60}, {-14, -234, -194, -126, 60}, {-18, -252, -174, -144, 66}, {-16, -232, -192, -126, 60}, {-14, -232, -192, -126, 60}, {-12, -230, -190, -124, 60}, {-10, -230, -190, -124, 60}, {-9, -230, -190, -124, 60}, {-8, -230, -190, -124, 60}, {-7, -230, -190, -124, 60}, {-6, -230, -190, -124, 60}, {-4, -228, -188, -122, 60}, {-2, -228, -188, -122, 60}, {2, -226, -186, -118, 62}, {4, -226, -186, -118, 62}, {6, -224, -184, -116, 62}, {8, -224, -184, -116, 62}, {10, -222, -180, -114, 64}, {12, -220, -170, -112, 66}, {14, -218, -168, -110, 66}, {16, -216, -164, -108, 66}, {18, -216, -162, -108, 66}, {20, -220, -170, -112, 66}};
    private static final int[][] ORACLE_TYPES = new int[][]{{22, -252, -210, -144, 66}, {23, -252, -210, -144, 66}, {24, -250, -208, -140, 66}, {25, -250, -208, -140, 66}, {26, -247, -206, -134, 66}, {28, -244, -200, -138, 68}, {29, -244, -196, -136, 68}, {30, -244, -196, -136, 68}, {32, -242, -204, -130, 66}, {33, -242, -204, -130, 66}, {34, -240, -196, -136, 72}, {35, -238, -206, -134, 72}, {36, -222, -178, -114, 64}, {39, -226, -186, -118, 62}, {38, -226, -186, -118, 62}, {40, -224, -184, -116, 62}, {41, -224, -184, -116, 62}, {42, -220, -170, -112, 66}, {44, -216, -162, -108, 66}, {46, -216, -160, -108, 66}, {47, -216, -160, -108, 66}, {48, -216, -160, -108, 66}, {49, -216, -160, -108, 66}, {50, -250, -156, -140, 66}, {51, -250, -208, -140, 66}};
    private static final int[][] SQLITE_TYPES = new int[][]{{60, -230, -190, -124, 60}, {62, -226, -182, -118, 62}, {64, -222, -178, -114, 64}, {66, -250, -206, -130, 66}, {68, -244, -196, -136, 68}, {70, -244, -196, -136, 70}, {72, -244, -196, -136, 72}, {74, -220, -170, -112, 74}, {76, -218, -168, -110, 76}, {78, -216, -162, -108, 78}};
    private static final int[][] MSACCESS_TYPES = new int[][]{{80, -254, -212, -122, 60}, {82, -246, -202, -136, 68}, {84, -244, -200, -132, 68}, {86, -250, -208, -140, 66}, {88, -247, -206, -134, 66}, {90, -236, -176, -128, 60}, {92, -234, -194, -126, 60}, {94, -232, -192, -126, 60}, {96, -230, -190, -124, 60}, {98, -226, -182, -118, 62}, {90, -224, -184, -116, 62}, {92, -222, -178, -114, 62}, {94, -240, -196, -136, 68}, {96, -216, -162, -108, 66}};
    private static final int[][] MSSQL_TYPES = new int[][]{{100, -252, -210, -144, 66}, {102, -252, -210, -144, 66}, {104, -250, -208, -140, 66}, {106, -250, -208, -140, 66}, {108, -246, -202, -136, 68}, {110, -244, -200, -136, 68}, {112, -244, -202, -136, 68}, {114, -242, -204, -130, 66}, {116, -242, -204, -130, 66}, {118, -252, -210, -144, 66}, {120, -247, -206, -134, 66}, {122, -236, -174, -128, 60}, {124, -234, -194, -126, 60}, {126, -232, -192, -126, 60}, {128, -230, -190, -124, 60}, {130, -228, -188, -122, 60}, {132, -224, -184, -116, 62}, {134, -226, -182, -118, 62}, {136, -222, -180, -114, 62}, {138, -222, -178, -114, 62}, {140, -222, -180, -114, 62}, {142, -222, -180, -114, 62}, {144, -220, -170, -112, 66}, {146, -218, -168, -110, 66}, {148, -216, -164, -108, 66}, {150, -216, -164, -108, 66}, {152, -216, -164, -108, 66}, {154, -252, -210, -144, 66}, {156, -216, -162, -108, 66}};

    public TypesInfoCache() {
        this(ConnectionManager.getDataSourceType());
    }

    public TypesInfoCache(String string) {
        this(string, DEFAULT_DATASINK_TYPE);
    }

    public TypesInfoCache(String string, String string2) {
        this.dataSourceType = string;
        this.dataSinkType = string2;
        this.nameToType = new HashMap<String, Integer>();
        if (string.equals("h2")) {
            this.addSourceSinkType(H2_TYPES);
        } else if (string.indexOf("hsql") != -1) {
            this.addSourceSinkType(HSQL_TYPES);
        } else if (string.indexOf("derby") != -1) {
            this.addSourceSinkType(DERBY_TYPES);
        } else if (string.equals("postgresql")) {
            this.addSourceSinkType(POSTGRESQL_TYPES);
        } else if (string.equals("mysql")) {
            this.addSourceSinkType(MYSQL_TYPES);
        } else if (string.equals("mariadb")) {
            this.addSourceSinkType(MYSQL_TYPES);
        } else if (string.equals("oracle")) {
            this.addSourceSinkType(ORACLE_TYPES);
        } else if (string.equals("sqlite")) {
            this.addSourceSinkType(SQLITE_TYPES);
        } else if (string.equals("odbc")) {
            this.addSourceSinkType(MSACCESS_TYPES);
        } else if (string.equals("sqlserver")) {
            this.addSourceSinkType(MSSQL_TYPES);
        }
    }

    private void addSourceSinkType(int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            String string = TypeID.toString(nArray[i][0]);
            Integer n = this.dataSinkType.equals("h2") ? Integer.valueOf(nArray[i][1]) : (this.dataSinkType.equals("derby") ? Integer.valueOf(nArray[i][3]) : (this.dataSinkType.equals("sqlite") ? Integer.valueOf(nArray[i][4]) : Integer.valueOf(nArray[i][2])));
            this.nameToType.put(string, n);
        }
    }

    public String getType(int n, String string) {
        if (this.dataSourceType.equals("postgresql") && string.startsWith("_")) {
            string = TypeID.toString(-36);
        }
        if (this.nameToType.containsKey(string)) {
            return TypeID.toString(this.nameToType.get(string));
        }
        if (this.dataSinkType.equals("sqlite")) {
            return TypeID.toString(64);
        }
        Field[] fieldArray = Types.class.getFields();
        String string2 = "";
        try {
            for (int i = 0; i < fieldArray.length; ++i) {
                if (fieldArray[i].getInt(null) != n) continue;
                string2 = fieldArray[i].getName();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (string2.isEmpty()) {
            return TypeID.toString(0);
        }
        return string2;
    }

    public static String testTypesArraySizes() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Invalid Sink DB Type Representation:");
        for (n = 0; n < H2_TYPES.length; ++n) {
            if (H2_TYPES[n].length == 5) continue;
            stringBuilder.append("H2_TYPES Row:  " + n);
        }
        for (n = 0; n < HSQL_TYPES.length; ++n) {
            if (HSQL_TYPES[n].length == 5) continue;
            stringBuilder.append("HSQL_TYPES Row: " + n);
        }
        for (n = 0; n < DERBY_TYPES.length; ++n) {
            if (DERBY_TYPES[n].length == 5) continue;
            stringBuilder.append("DERBY_TYPES Row: " + n);
        }
        for (n = 0; n < POSTGRESQL_TYPES.length; ++n) {
            if (POSTGRESQL_TYPES[n].length == 5) continue;
            stringBuilder.append("POSTGRESQL_TYPES Row:  " + n);
        }
        for (n = 0; n < MYSQL_TYPES.length; ++n) {
            if (MYSQL_TYPES[n].length == 5) continue;
            stringBuilder.append("MYSQL_TYPES Row: " + n);
        }
        for (n = 0; n < ORACLE_TYPES.length; ++n) {
            if (ORACLE_TYPES[n].length == 5) continue;
            stringBuilder.append("ORACLE_TYPES Row:  " + n);
        }
        for (n = 0; n < SQLITE_TYPES.length; ++n) {
            if (SQLITE_TYPES[n].length == 5) continue;
            stringBuilder.append("SQLITE_TYPES Row: " + n);
        }
        for (n = 0; n < MSACCESS_TYPES.length; ++n) {
            if (MSACCESS_TYPES[n].length == 5) continue;
            stringBuilder.append("MSACCESS_TYPES Row: " + n);
        }
        for (n = 0; n < MSSQL_TYPES.length; ++n) {
            if (MSSQL_TYPES[n].length == 5) continue;
            stringBuilder.append("MSSQL_TYPES Row: " + n);
        }
        return stringBuilder.toString();
    }
}

