/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.datasource;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.datasource.ConnectionProperties;
import com.dandymadeproductions.ajqvue.datasource.DatabaseProperties;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import com.sun.rowset.CachedRowSetImpl;
import com.sun.rowset.FilteredRowSetImpl;
import com.sun.rowset.WebRowSetImpl;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.sql.RowSet;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.FilteredRowSet;
import javax.sql.rowset.WebRowSet;
import javax.swing.JOptionPane;

public class ConnectionInstance {
    private Connection memoryConnection;
    private ConnectionProperties connectionProperties;
    private DatabaseProperties databaseProperties;
    private boolean connectionInitialized;
    private boolean debug;
    public static final String MYSQL = "mysql";
    public static final String MARIADB = "mariadb";
    public static final String POSTGRESQL = "postgresql";
    public static final String HSQL = "hsql";
    public static final String HSQL2 = "hsql2";
    public static final String ORACLE = "oracle";
    public static final String SQLITE = "sqlite";
    public static final String MSACCESS = "odbc";
    public static final String MSSQL = "sqlserver";
    public static final String DERBY = "derby";
    public static final String H2 = "h2";
    public static final String OTHERDB = "other";
    public static final String DERBY_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String DERBY_SUBPROTOCOL = "derby";
    public static final String DERBY_PORT = "1527";
    public static final String DERBY_MEMORY_DB = "memory:dbname0";
    public static final String H2_DRIVER = "org.h2.Driver";
    public static final String H2_SUBPROTOCOL = "h2";
    public static final String H2_PORT = "9092";
    public static final String H2_MEMORY_DB = "mem:dbname1";
    public static final String SQLITE_DRIVER = "org.sqlite.JDBC";
    public static final String SQLITE_SUBPROTOCOL = "sqlite";
    public static final String SQLITE_PORT = "0000";
    public static final String SQLITE_MEMORY_DB = ":memory:";
    public static final String HSQL2_DRIVER = "org.hsqldb.jdbcDriver";
    public static final String HSQL2_SUBPROTOCOL = "hsqldb:hsql";
    public static final String HSQL2_PORT = "9001";
    public static final String HSQL2_MEMORY_DB = "mem:dbname2";
    public static final String PROTOCOL = "jdbc";
    public static final String LOCALHOST = "localhost";
    private static final String USER = "sa";
    private static final String PASSWORD = " ";
    private static final String SSH = "false";

    public ConnectionInstance() {
        this(HSQL2, Ajqvue.getDebug(), true);
    }

    public ConnectionInstance(String string) {
        this(string, Ajqvue.getDebug(), true);
    }

    public ConnectionInstance(String string, boolean bl) {
        this(string, Ajqvue.getDebug(), bl);
    }

    public ConnectionInstance(String string, boolean bl, boolean bl2) {
        this.debug = bl;
        this.createDefaultMemoryConnectionProperties(string);
        this.databaseProperties = new DatabaseProperties(this.connectionProperties, bl2);
        this.connectionInitialized = this.initConnection(bl2);
    }

    public ConnectionInstance(ConnectionProperties connectionProperties, boolean bl, boolean bl2) {
        this.debug = bl;
        this.connectionProperties = connectionProperties;
        if (connectionProperties.getConnectionURLString() == null) {
            connectionProperties.setConnectionURLString(ConnectionManager.createConnectionURLString(connectionProperties));
        }
        this.databaseProperties = new DatabaseProperties(connectionProperties, bl2);
        this.connectionInitialized = this.initConnection(bl2);
    }

    private void createDefaultMemoryConnectionProperties(String string) {
        String string2;
        String string3;
        String string4;
        String string5;
        this.connectionProperties = new ConnectionProperties();
        Properties properties = new Properties();
        if (string.equals("derby")) {
            string5 = DERBY_DRIVER;
            string4 = "derby";
            string3 = DERBY_PORT;
            string2 = DERBY_MEMORY_DB;
        } else if (string.equals("h2")) {
            string5 = H2_DRIVER;
            string4 = "h2";
            string3 = H2_PORT;
            string2 = H2_MEMORY_DB;
        } else if (string.equals("sqlite")) {
            string5 = SQLITE_DRIVER;
            string4 = "sqlite";
            string3 = SQLITE_PORT;
            string2 = SQLITE_MEMORY_DB;
        } else {
            string5 = HSQL2_DRIVER;
            string4 = HSQL2_SUBPROTOCOL;
            string3 = HSQL2_PORT;
            string2 = HSQL2_MEMORY_DB;
            properties.setProperty("shutdown", "true");
        }
        properties.setProperty("user", USER);
        properties.setProperty("password", PASSWORD);
        this.connectionProperties.setProperties(properties);
        this.connectionProperties.setProperty("Driver", string5);
        this.connectionProperties.setProperty("Protocol", PROTOCOL);
        this.connectionProperties.setProperty("SubProtocol", string4);
        this.connectionProperties.setProperty("Host", LOCALHOST);
        this.connectionProperties.setProperty("Port", string3);
        this.connectionProperties.setProperty("DB", string2);
        this.connectionProperties.setProperty("User", USER);
        this.connectionProperties.setProperty("Password", PASSWORD);
        this.connectionProperties.setProperty("SSH", SSH);
        this.connectionProperties.setConnectionURLString(ConnectionManager.createConnectionURLString(this.connectionProperties));
    }

    private boolean initConnection(boolean bl) {
        try {
            Class.forName(this.connectionProperties.getProperty("Driver"));
            if (this.debug) {
                System.out.println("ConnectionInstance initConnection() Driver Loaded");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string;
            String string2 = classNotFoundException.getMessage();
            if (string2 != null && string2.length() > 200) {
                string2 = string2.substring(0, 200);
            }
            if ((string = System.getProperty("java.ext.dirs")) == null || string.equals("")) {
                string = "Java JRE/lib/ext";
            }
            String string3 = "Unable to Find or Load JDBC Driver\nInsure the Appropriate JDBC Driver is Located in the \n" + string + Utils.getFileSeparator() + " directory.\nExeception: " + string2;
            JOptionPane.showMessageDialog(null, string3, "Alert", 0);
            return false;
        }
        try {
            String string = this.connectionProperties.getConnectionURLString();
            Properties properties = this.connectionProperties.getConnectionProperties();
            if (this.debug) {
                System.out.println("ConnectionInstance initConnection() " + string);
            }
            Connection connection = DriverManager.getConnection(string, properties);
            this.databaseProperties.init(connection);
            this.databaseProperties.loadDBTables(connection);
            String string4 = this.connectionProperties.getProperty("SubProtocol");
            String string5 = this.connectionProperties.getProperty("DB");
            if (string4.equals("sqlite") && string5.toLowerCase(Locale.ENGLISH).indexOf(SQLITE_MEMORY_DB) != -1 || string4.indexOf(HSQL) != -1 && string5.toLowerCase(Locale.ENGLISH).indexOf("mem:") != -1 || string4.equals("derby") && string5.toLowerCase(Locale.ENGLISH).indexOf("memory:") != -1 || string4.equals("h2") && string5.toLowerCase(Locale.ENGLISH).indexOf("mem:") != -1) {
                this.setMemoryConnection(DriverManager.getConnection(string, properties));
            }
            connection.close();
        }
        catch (SQLException sQLException) {
            ConnectionInstance.displaySQLErrors(sQLException, "ConnectionInstance initConnection()", this.debug);
        }
        return true;
    }

    public Connection getConnection(String string) {
        if (!this.connectionInitialized) {
            return null;
        }
        String string2 = this.connectionProperties.getConnectionURLString();
        String string3 = this.connectionProperties.getProperty("DB");
        String string4 = this.connectionProperties.getProperty("SubProtocol");
        Properties properties = this.connectionProperties.getConnectionProperties();
        try {
            if (this.debug) {
                System.out.println(string + " (CI) Connection Created");
            }
            if (this.memoryConnection != null && string4.equals("sqlite") && string3.toLowerCase(Locale.ENGLISH).indexOf(SQLITE_MEMORY_DB) != -1 || string4.indexOf(HSQL) != -1 && string3.toLowerCase(Locale.ENGLISH).indexOf("mem:") != -1 || string4.equals("derby") && string3.toLowerCase(Locale.ENGLISH).indexOf("memory:") != -1 || string4.equals("h2") && string3.toLowerCase(Locale.ENGLISH).indexOf("mem:") != -1) {
                return this.memoryConnection;
            }
            return DriverManager.getConnection(string2, properties);
        }
        catch (SQLException sQLException) {
            ConnectionInstance.displaySQLErrors(sQLException, "ConnectionInstance getConnection()", this.debug);
            return null;
        }
    }

    public void closeConnection(Connection connection, String string) {
        String string2 = this.connectionProperties.getProperty("DB");
        String string3 = this.connectionProperties.getProperty("SubProtocol");
        try {
            if (this.debug) {
                System.out.println(string + " (CI) Connection Closed");
            }
            if (this.memoryConnection != null && string3.equals("sqlite") && string2.toLowerCase(Locale.ENGLISH).indexOf(SQLITE_MEMORY_DB) != -1 || string3.indexOf(HSQL) != -1 && string2.toLowerCase(Locale.ENGLISH).indexOf("mem:") != -1 || string3.equals("derby") && string2.toLowerCase(Locale.ENGLISH).indexOf("memory:") != -1 || string3.equals("h2") && string2.toLowerCase(Locale.ENGLISH).indexOf("mem:") != -1) {
                return;
            }
            connection.close();
        }
        catch (SQLException sQLException) {
            ConnectionInstance.displaySQLErrors(sQLException, "ConnectionInstance closeConnection()", this.debug);
        }
    }

    public void shutdown(String string) {
        this.closeMemoryConnection(string);
        this.shutdownDatabase(string);
    }

    private void closeMemoryConnection(String string) {
        try {
            if (this.memoryConnection != null) {
                if (this.debug) {
                    System.out.println(string + " (CI) Memory Connection Closed");
                }
                this.memoryConnection.close();
            }
        }
        catch (SQLException sQLException) {
            ConnectionInstance.displaySQLErrors(sQLException, "ConnectionInstance closeMemoryConnection()", this.debug);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownDatabase(String string) {
        String string2 = this.connectionProperties.getConnectionURLString();
        String string3 = this.connectionProperties.getProperty("Driver");
        String string4 = this.connectionProperties.getProperty("SubProtocol");
        String string5 = string2.indexOf(";") != -1 ? string2.substring(0, string2.indexOf(";")) : string2;
        Connection connection = null;
        try {
            if (string4.equals("derby")) {
                if (string3.indexOf("EmbeddedDriver") != -1) {
                    if (string5.toLowerCase(Locale.ENGLISH).indexOf("memory:") != -1) {
                        if (this.debug) {
                            System.out.println(string + " (CI) Dropping Derby Memory Database");
                        }
                        connection = DriverManager.getConnection(string5 + ";drop=true");
                        connection.close();
                    } else {
                        if (this.debug) {
                            System.out.println(string + " (CI) Shutting Down Derby Embedded Database");
                        }
                        connection = DriverManager.getConnection("jdbc:derby:;shutdown=true");
                        connection.close();
                    }
                }
                return;
            }
            if (string4.indexOf(HSQL) != -1) {
                if (string5.toLowerCase(Locale.ENGLISH).indexOf("file:") != -1) {
                    if (this.debug) {
                        System.out.println(string + " (CI) Shutting Down HSQL File Database");
                    }
                    connection = DriverManager.getConnection(string5 + ";shutdown=true");
                    connection.close();
                }
                return;
            }
        }
        catch (SQLException sQLException) {
            if (string4.equals("derby") && sQLException.getSQLState() != null && (sQLException.getSQLState().equals("08006") || sQLException.getSQLState().equals("XJ015"))) {
                if (this.debug) {
                    System.out.println("SQLException: " + sQLException.getMessage());
                    System.out.println("SQLState: " + sQLException.getSQLState());
                }
            } else if (this.debug) {
                ConnectionInstance.displaySQLErrors(sQLException, "ConnectionInstance shutdownDatabase()", this.debug);
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                ConnectionInstance.displaySQLErrors(sQLException, "finally{} ConnectionInstance shutdownDatabase()", this.debug);
            }
        }
    }

    public static void displaySQLErrors(SQLException sQLException, String string, boolean bl) {
        String string2;
        Object object;
        if (bl) {
            System.out.println(string);
            for (object = sQLException; object != null; object = ((SQLException)object).getNextException()) {
                System.out.println("SQLException: " + ((Throwable)object).getMessage());
                System.out.println("SQLState: " + ((SQLException)object).getSQLState());
                System.out.println("VendorError: " + ((SQLException)object).getErrorCode());
                for (Throwable throwable = ((Throwable)object).getCause(); throwable != null; throwable = throwable.getCause()) {
                    System.out.println("Cause: " + throwable);
                }
            }
        }
        if ((string2 = sQLException.getMessage()).length() > 200) {
            string2 = sQLException.getMessage().substring(0, 200);
        }
        object = string + "\nSQLException: " + string2 + "\nSQLState: " + sQLException.getSQLState() + ",  VendorError: " + sQLException.getErrorCode();
        JOptionPane.showMessageDialog(null, object, "Alert", 0);
    }

    public void loadDBTables(Connection connection) throws SQLException {
        this.databaseProperties.loadDBTables(connection);
    }

    public String getCatalogSeparator() {
        return this.databaseProperties.getCatalogSeparator();
    }

    public ConnectionProperties getConnectionProperties() {
        return this.connectionProperties;
    }

    public String getDataSourceType() {
        return this.databaseProperties.getDataSourceType();
    }

    public String getDBProductName_And_Version() {
        return this.databaseProperties.getDBProductName_And_Version();
    }

    public String getIdentifierQuoteString() {
        return this.databaseProperties.getIdentifierQuoteString();
    }

    public int getMaxColumnNameLength() {
        return this.databaseProperties.getMaxColumnNameLength();
    }

    public ArrayList<String> getSchemas() {
        return this.databaseProperties.getSchemas();
    }

    public String getAllSchemasPattern() {
        return this.databaseProperties.getAllSchemasPattern();
    }

    public ArrayList<String> getTableNames() {
        return this.databaseProperties.getTableNames();
    }

    public CachedRowSet getCachedRowSet() throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = new CachedRowSetImpl();
        this.setRowSet(cachedRowSetImpl);
        return cachedRowSetImpl;
    }

    public FilteredRowSet getFilteredRowSet() throws SQLException {
        FilteredRowSetImpl filteredRowSetImpl = new FilteredRowSetImpl();
        this.setRowSet(filteredRowSetImpl);
        return filteredRowSetImpl;
    }

    public WebRowSet getWebRowSet() throws SQLException {
        WebRowSetImpl webRowSetImpl = new WebRowSetImpl();
        this.setRowSet(webRowSetImpl);
        return webRowSetImpl;
    }

    private void setRowSet(RowSet rowSet) throws SQLException {
        rowSet.setUrl(this.connectionProperties.getConnectionURLString());
        rowSet.setUsername(this.connectionProperties.getProperty("User"));
        rowSet.setPassword(this.connectionProperties.getPassword());
    }

    public void setConnectionProperties(ConnectionProperties connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public void setDatabaseProperties(DatabaseProperties databaseProperties) {
        this.databaseProperties = databaseProperties;
    }

    private void setMemoryConnection(Connection connection) {
        this.memoryConnection = connection;
    }

    public void setSchemaPattern(String string) {
        this.databaseProperties.setSchemaPattern(string);
    }
}

