/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.tablerecordcount;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class TableRecordCountPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 2500935698652883672L;
    private ImageIcon tabIcon;
    private JComboBox<Object> tableSelectionComboBox;
    private JLabel recordCountLabel;
    private boolean disableActions;
    private static final String VERSION = "Version 1.2";

    TableRecordCountPanel(String string, ArrayList<String> arrayList) {
        String string2 = string + "/TableRecordCount.jar";
        String string3 = "lib/plugins/TableRecordCount/locale/";
        String string4 = "lib/plugins/TableRecordCount/images/icons/";
        AResourceBundle aResourceBundle = new AResourceBundle(string2, true, true);
        aResourceBundle.setLocaleResource(string3, "TableRecordCount", Ajqvue.getLocaleString());
        this.tabIcon = aResourceBundle.getResourceImage(string4 + "tabIcon.png");
        this.tableSelectionComboBox = new JComboBox();
        this.tableSelectionComboBox.setEnabled(false);
        if (!arrayList.isEmpty()) {
            Iterator<String> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.tableSelectionComboBox.addItem(iterator.next());
            }
            this.tableSelectionComboBox.setEnabled(true);
        }
        this.tableSelectionComboBox.addActionListener(this);
        this.add(this.tableSelectionComboBox);
        String string5 = aResourceBundle.getResourceString("TableRecordCountPanel.label.RecordCount", "Record Count");
        JLabel jLabel = new JLabel(string5 + ": ");
        this.add(jLabel);
        this.recordCountLabel = new JLabel("0");
        this.add(this.recordCountLabel);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JComboBox && !this.disableActions) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    TableRecordCountPanel.this.executeRecordCount();
                }
            }, "TableRecordCountPanel.actionThread");
            thread.start();
        }
    }

    private void executeRecordCount() {
        int n = 0;
        this.tableSelectionComboBox.setEnabled(false);
        this.disableActions = true;
        Connection connection = ConnectionManager.getConnection((String)"TableRecordCountPanel executeRecordCount()");
        try {
            Statement statement = connection.createStatement();
            String string = (String)this.tableSelectionComboBox.getSelectedItem();
            TableTabPanel tableTabPanel = DBTablesPanel.getTableTabPanel((String)string);
            if (tableTabPanel == null) {
                return;
            }
            string = tableTabPanel.getTableName();
            String string2 = Utils.getSchemaTableName((String)string);
            String string3 = "SELECT COUNT(*) FROM " + string2;
            ResultSet resultSet = statement.executeQuery(string3);
            resultSet.next();
            n = resultSet.getInt(1);
            this.recordCountLabel.setText(Integer.toString(n));
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors((SQLException)sQLException, (String)"TableRecordCountPanel executeRecordCount()");
            this.recordCountLabel.setText("0");
            this.tableSelectionComboBox.setEnabled(true);
            this.disableActions = false;
        }
        ConnectionManager.closeConnection((Connection)connection, (String)"TableRecordCountPanel executeRecordCount()");
        this.tableSelectionComboBox.setEnabled(true);
        this.disableActions = false;
    }

    protected void reloadPanel(ArrayList<String> arrayList) {
        this.tableSelectionComboBox.setEnabled(false);
        this.disableActions = true;
        this.tableSelectionComboBox.removeAllItems();
        this.recordCountLabel.setText("0");
        if (!arrayList.isEmpty()) {
            Iterator<String> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.tableSelectionComboBox.addItem(iterator.next());
            }
            this.tableSelectionComboBox.setEnabled(true);
        }
        this.disableActions = false;
    }

    protected static String getVersion() {
        return VERSION;
    }

    protected ImageIcon getTabIcon() {
        return this.tabIcon;
    }
}

